/*
 * Copyright (C) 2024 iopsys Software Solutions AB
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation
 *
 *		Author: Anis Ellouze <anis.ellouze@pivasoftware.com>
 *		Author: Omar Kallel <omar.kallel@pivasoftware.com>
 *		Author: Amin Ben Ramdhane <amin.benramdhane@pivasoftware.com>
 *
 */

#ifndef __DHCPMNGR_H
#define __DHCPMNGR_H

#include "libbbfdm-api/dmcommon.h"

#define DHCP_LEASES_FILE "/tmp/dhcp.leases"
#define DHCP_CLIENT_OPTIONS_FILE "/var/dhcp.client.options"

struct dhcpmngr_dhcp_option_type {
	char *config_name;
	uint8_t tag;
	uint8_t type;
	uint8_t len;
};

extern DMOBJ tDHCPObjs[];

void dhcpmngr_convert_str_option_to_hex(unsigned int tag, const char *str, char *hex, size_t size);
void dhcpmngr_convert_hex_option_to_string(unsigned int tag, const char *hex, char *str, size_t size);
int dhcpmngr_get_dhcp_option_number_by_name(const char *tag_name);

#endif
