#!/bin/bash

echo "install dependencies"

home=$(pwd)

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1
	local ret=$?

	if [ "${ret}" -ne 0 ]; then
		echo "Failed to execute $@ ret (${ret})"
		exit 1
	fi
}

exec_cmd apt update
exec_cmd apt install -y iproute2
exec_cmd apt install -y libavahi-core-dev

# libeasy
cd /opt/dev
rm -fr libeasy
git clone -b devel https://dev.iopsys.eu/hal/libeasy.git
cd libeasy
cmake .
make CFLAGS+="-I/usr/include/libnl3"
mkdir -p /usr/include/easy
cp easy.h event.h utils.h if_utils.h debug.h hlist.h bufutil.h cryptutil.h ecc_cryptutil.h timestamp.h /usr/include/easy
cp -a libeasy*.so* /usr/lib

# libwifiutils + libwifi
cd /opt/dev
rm -fr libwifi
git clone -b devel https://dev.iopsys.eu/hal/libwifi.git
cd libwifi
cd libwifiutils
cmake .
make -j$(nproc)
cp wifidefs.h wifiutils.h /usr/include
cp -a libwifiutils.so /usr/lib
cd -

# ieee1905, map.so
cd /opt/dev
rm -fr ieee1905
exec_cmd git clone --depth 1 -b release-7.5 https://dev.iopsys.eu/iopsys/ieee1905.git
cd ieee1905
exec_cmd ./gitlab-ci/setup.sh
cd src
CFLAGS="-DHAS_UBUS -DEXTENSION_ALLOWED -DEASYMESH_VERSION=6" make
mkdir -p /usr/include /usr/lib/ieee1905
exec_cmd cp -a cmdu.h /usr/include/
exec_cmd cp -a cmdu_ackq.h /usr/include/
exec_cmd cp -a 1905_tlvs.h /usr/include/
exec_cmd cp -a i1905_wsc.h /usr/include/
exec_cmd cp -a timer_impl.h /usr/include/
exec_cmd cp -a libmidgen.so /usr/lib
exec_cmd cp -a libieee1905.so /usr/lib
exec_cmd cp -a ieee1905d /usr/sbin/
exec_cmd cp -a extensions/map/libmaputil.so /usr/lib
exec_cmd cp -a extensions/map/map.so /usr/lib
exec_cmd cp -a extensions/map/map_module.h /usr/include/
exec_cmd cp -a extensions/map/cntlrsync.h /usr/include/
exec_cmd cp -a extensions/map/easymesh.h /usr/include/

ldconfig

