# wfadata Schema

```
https://www.iopsys.eu/wfadata.json
```

| Custom Properties | Additional Properties |
| ----------------- | --------------------- |
| Forbidden         | Forbidden             |

# wfadata

| List of Methods |
| --------------- |
| [dump](#dump)   	| Method | wfadata (this schema) |
| [refresh](#refresh)   | Method | wfadata (this schema) |

## dump

### dump

Dump the data retrieved from the data collection agents

`dump`

- type: `Method`

### dump Type

`object` with following properties:

| Property | Type   | Required |
| -------- | ------ | -------- |
| `output` | object | Optional |

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property               | Type   | Required     |
| ---------------------- | ------ | ------------ |
| `DataElements:Network` | object | **Required** |
| `date`                 | string | **Required** |
| `description`          | string | **Required** |
| `name`                 | string | **Required** |
| `timestamp`            | string | **Required** |
| `version`              | string | **Required** |

#### DataElements:Network

This object describes a Wi-Fi network containing one or more devices.

`DataElements:Network`

- is **required**
- type: reference

##### DataElements:Network Type

`object` with following properties:

| Property          | Type    | Required     |
| ----------------- | ------- | ------------ |
| `ControllerID`    | string  | **Required** |
| `DeviceList`      | array   | **Required** |
| `ID`              | string  | **Required** |
| `NumberOfDevices` | integer | **Required** |
| `TimeStamp`       | string  | **Required** |

#### ControllerID

A unique identifier for a Multi-AP Controller.

`ControllerID`

- is **required**
- type: `string`

##### ControllerID Type

`string`

#### DeviceList

The list of network devices

`DeviceList`

- is **required**
- type: reference

##### DeviceList Type

Array type: reference

All items must be of the type: `object` with following properties:

| Property              | Type    | Required     |
| --------------------- | ------- | ------------ |
| `CollectionInterval`  | integer | **Required** |
| `ID`                  | string  | **Required** |
| `MultiAPCapabilities` | string  | **Required** |
| `NumberOfRadios`      | integer | **Required** |
| `RadioList`           | array   | **Required** |

#### CollectionInterval

The interval between the collection of consecutive measurements of the most frequently updated Data Element from this
device (milliseconds)

`CollectionInterval`

- is **required**
- type: `integer`

##### CollectionInterval Type

`integer`

- minimum value: `0`

#### ID

##### MAC Address

A unique identifier for this particular device within the Wi-Fi network

`ID`

- is **required**
- type: reference

##### ID Type

`string`

- minimum length: 17 characters
- maximum length: 17 characters All instances must conform to this regular expression (test examples
  [here](<https://regexr.com/?expression=%5E(%5B0-9a-fA-F%5D%5B0-9a-fA-F%5D%3A)%7B5%7D%5B0-9a-fA-F%5D%5B0-9a-fA-F%5D%24>)):

```regex
^([0-9a-fA-F][0-9a-fA-F]:){5}[0-9a-fA-F][0-9a-fA-F]$
```

#### MultiAPCapabilities

##### Binary encoded Number

The Multi-AP capabilities supported by this device as defined by the AP Capability TLV

`MultiAPCapabilities`

- is **required**
- type: reference

##### MultiAPCapabilities Type

`string`

#### NumberOfRadios

The number of radios in this AP

`NumberOfRadios`

- is **required**
- type: `integer`

##### NumberOfRadios Type

`integer`

- minimum value: `0`
- maximum value: `65535`

#### RadioList

The list of Radio objects

`RadioList`

- is **required**
- type: reference

##### RadioList Type

Array type: reference

All items must be of the type: `object` with following properties:

| Property                  | Type    | Required     |
| ------------------------- | ------- | ------------ |
| `BSSList`                 | array   | **Required** |
| `BackhaulSta`             |         | **Required** |
| `Capabilities`            |         | **Required** |
| `CurrentOperatingClasses` | array   | **Required** |
| `Enabled`                 | boolean | **Required** |
| `ID`                      | string  | **Required** |
| `Noise`                   | integer | **Required** |
| `NumberOfBSS`             | integer | **Required** |
| `NumberOfCurrOpClass`     | integer | **Required** |
| `NumberOfUnassocSta`      | integer | **Required** |
| `ReceiveOther`            | integer | **Required** |
| `ReceiveSelf`             | integer | **Required** |
| `ScanResultList`          |         | **Required** |
| `Transmit`                | integer | **Required** |
| `UnassociatedStaList`     | array   | **Required** |
| `Utilization`             | integer | **Required** |

#### BSSList

Array of BSS objects configured on this radio

`BSSList`

- is **required**
- type: reference

##### BSSList Type

Array type: reference

All items must be of the type: `object` with following properties:

| Property                 | Type    | Required     |
| ------------------------ | ------- | ------------ |
| `BSSID`                  | string  | **Required** |
| `BroadcastBytesReceived` | integer | **Required** |
| `BroadcastBytesSent`     | integer | **Required** |
| `Enabled`                | boolean | **Required** |
| `EstServiceParametersBE` | string  | **Required** |
| `EstServiceParametersBK` | string  | **Required** |
| `EstServiceParametersVI` | string  | **Required** |
| `EstServiceParametersVO` | string  | **Required** |
| `LastChange`             | integer | **Required** |
| `MulticastBytesReceived` | integer | **Required** |
| `MulticastBytesSent`     | integer | **Required** |
| `NumberOfSTA`            | integer | **Required** |
| `SSID`                   | string  | **Required** |
| `STAList`                | array   | **Required** |
| `TimeStamp`              | string  | **Required** |
| `UnicastBytesReceived`   | integer | **Required** |
| `UnicastBytesSent`       | integer | **Required** |

#### BSSID

##### MAC Address

The MAC address of the logical BSS (BSSID).

`BSSID`

- is **required**
- type: reference

##### BSSID Type

`string`

- minimum length: 17 characters
- maximum length: 17 characters All instances must conform to this regular expression (test examples
  [here](<https://regexr.com/?expression=%5E(%5B0-9a-fA-F%5D%5B0-9a-fA-F%5D%3A)%7B5%7D%5B0-9a-fA-F%5D%5B0-9a-fA-F%5D%24>)):

```regex
^([0-9a-fA-F][0-9a-fA-F]:){5}[0-9a-fA-F][0-9a-fA-F]$
```

#### BroadcastBytesReceived

BSS wide statistics for total broadcast bytes received

`BroadcastBytesReceived`

- is **required**
- type: `integer`

##### BroadcastBytesReceived Type

`integer`

- minimum value: `0`

#### BroadcastBytesSent

BSS wide statistics for total broadcast bytes transmitted

`BroadcastBytesSent`

- is **required**
- type: `integer`

##### BroadcastBytesSent Type

`integer`

- minimum value: `0`

#### Enabled

Whether the BSSID is currently enabled and beacon frames being sent.

`Enabled`

- is **required**
- type: `boolean`

##### Enabled Type

`boolean`

#### EstServiceParametersBE

##### Binary encoded Number

Estimated Service Parameters Information field for AC=BE

`EstServiceParametersBE`

- is **required**
- type: reference

##### EstServiceParametersBE Type

`string`

#### EstServiceParametersBK

##### Binary encoded Number

Estimated Service Parameters Information field for AC=BK

`EstServiceParametersBK`

- is **required**
- type: reference

##### EstServiceParametersBK Type

`string`

#### EstServiceParametersVI

##### Binary encoded Number

Estimated Service Parameters Information field for AC=VI

`EstServiceParametersVI`

- is **required**
- type: reference

##### EstServiceParametersVI Type

`string`

#### EstServiceParametersVO

##### Binary encoded Number

Estimated Service Parameters Information field for AC=VO

`EstServiceParametersVO`

- is **required**
- type: reference

##### EstServiceParametersVO Type

`string`

#### LastChange

Time in seconds since the last change to the .Enabled value.

`LastChange`

- is **required**
- type: `integer`

##### LastChange Type

`integer`

- minimum value: `0`

#### MulticastBytesReceived

BSS wide statistics for total multicast bytes received.

`MulticastBytesReceived`

- is **required**
- type: `integer`

##### MulticastBytesReceived Type

`integer`

- minimum value: `0`

#### MulticastBytesSent

BSS wide statistics for total multicast bytes transmitted

`MulticastBytesSent`

- is **required**
- type: `integer`

##### MulticastBytesSent Type

`integer`

- minimum value: `0`

#### NumberOfSTA

The number of STAs currently associated to this BSS.

`NumberOfSTA`

- is **required**
- type: `integer`

##### NumberOfSTA Type

`integer`

- minimum value: `0`
- maximum value: `65535`

#### SSID

The SSID in use for this BSS.

`SSID`

- is **required**
- type: `string`

##### SSID Type

`string`

#### STAList

The list of STAs associated to this BSS.

`STAList`

- is **required**
- type: reference

##### STAList Type

Array type: reference

All items must be of the type: `object` with following properties:

| Property                 | Type    | Required     |
| ------------------------ | ------- | ------------ |
| `BytesReceived`          | integer | **Required** |
| `BytesSent`              | integer | **Required** |
| `ErrorsReceived`         | integer | **Required** |
| `ErrorsSent`             | integer | **Required** |
| `EstMACDataRateDownlink` | integer | **Required** |
| `EstMACDataRateUplink`   | integer | **Required** |
| `HECapabilities`         | string  | **Required** |
| `HTCapabilities`         | string  | **Required** |
| `Hostname`               | string  | **Required** |
| `IPV4Address`            | string  | **Required** |
| `IPV6Address`            | string  | **Required** |
| `LastConnectTime`        | integer | **Required** |
| `LastDataDownlinkRate`   | integer | **Required** |
| `LastDataUplinkRate`     | integer | **Required** |
| `MACAddress`             | string  | **Required** |
| `MeasurementReport`      | array   | **Required** |
| `NumberOfMeasureReports` | integer | **Required** |
| `PacketsReceived`        | integer | **Required** |
| `PacketsSent`            | integer | **Required** |
| `RetransCount`           | integer | **Required** |
| `SignalStrength`         | integer | **Required** |
| `TimeStamp`              | string  | **Required** |
| `UtilizationReceive`     | integer | **Required** |
| `UtilizationTransmit`    | integer | **Required** |
| `VHTCapabilities`        | string  | **Required** |

#### BytesReceived

##### Unsigned integar with wrapping

The total number of bytes received from the associated STA.

`BytesReceived`

- is **required**
- type: reference

##### BytesReceived Type

`integer`

- minimum value: `0`

#### BytesSent

##### Unsigned integar with wrapping

The total number of bytes transmitted to the associated STA.

`BytesSent`

- is **required**
- type: reference

##### BytesSent Type

`integer`

- minimum value: `0`

#### ErrorsReceived

##### Unsigned integar with wrapping

The total number of inbound packets from the associated STA that contained errors preventing them from being delivered
to a higher-layer protocol

`ErrorsReceived`

- is **required**
- type: reference

##### ErrorsReceived Type

`integer`

- minimum value: `0`

#### ErrorsSent

##### Unsigned integar with wrapping

The total number of outbound packets that could not be transmitted to the associated STA because of errors. These might
be due to the number of retransmissions exceeding the retry limit or from other causes.

`ErrorsSent`

- is **required**
- type: reference

##### ErrorsSent Type

`integer`

- minimum value: `0`

#### EstMACDataRateDownlink

Estimate of the MAC layer throughput in Mbps achievable in the downlink

`EstMACDataRateDownlink`

- is **required**
- type: `integer`

##### EstMACDataRateDownlink Type

`integer`

- minimum value: `0`

#### EstMACDataRateUplink

Estimate of the MAC layer throughput in Mbps achievable in the uplink if 100% of channel airtime and BSS operating
bandwidth were to be available

`EstMACDataRateUplink`

- is **required**
- type: `integer`

##### EstMACDataRateUplink Type

`integer`

- minimum value: `0`

#### HECapabilities

##### Binary encoded Number

HE capabilities of the associated STA

`HECapabilities`

- is **required**
- type: reference

##### HECapabilities Type

`string`

#### HTCapabilities

##### Binary encoded Number

HT capabilities of the associated STA.

`HTCapabilities`

- is **required**
- type: reference

##### HTCapabilities Type

`string`

#### Hostname

Hostname assigned to the client.

`Hostname`

- is **required**
- type: `string`

##### Hostname Type

`string`

#### IPV4Address

IPV4 address assigned to the client.

`IPV4Address`

- is **required**
- type: `string`

##### IPV4Address Type

`string`

#### IPV6Address

IPV6 address assigned to the client.

`IPV6Address`

- is **required**
- type: `string`

##### IPV6Address Type

`string`

#### LastConnectTime

The time in seconds since the STA was associated

`LastConnectTime`

- is **required**
- type: `integer`

##### LastConnectTime Type

`integer`

- minimum value: `0`

#### LastDataDownlinkRate

The data transmit rate in Kbps that was most recently used for transmission of data PPDUs from the access point to the
associated STA

`LastDataDownlinkRate`

- is **required**
- type: `integer`

##### LastDataDownlinkRate Type

`integer`

- minimum value: `0`

#### LastDataUplinkRate

The data transmit rate in Kbps that was most recently used for transmission of data PPDUs from the associated STA to
the AP.

`LastDataUplinkRate`

- is **required**
- type: `integer`

##### LastDataUplinkRate Type

`integer`

- minimum value: `0`

#### MACAddress

##### MAC Address

The MAC address of an associated STA

`MACAddress`

- is **required**
- type: reference

##### MACAddress Type

`string`

- minimum length: 17 characters
- maximum length: 17 characters All instances must conform to this regular expression (test examples
  [here](<https://regexr.com/?expression=%5E(%5B0-9a-fA-F%5D%5B0-9a-fA-F%5D%3A)%7B5%7D%5B0-9a-fA-F%5D%5B0-9a-fA-F%5D%24>)):

```regex
^([0-9a-fA-F][0-9a-fA-F]:){5}[0-9a-fA-F][0-9a-fA-F]$
```

#### MeasurementReport

Array of Measurement Report element(s) that was received from the STA that constitute the latest Beacon report

`MeasurementReport`

- is **required**
- type: reference

##### MeasurementReport Type

Array type: reference

All items must be of the type: `string`

#### NumberOfMeasureReports

The number of measurement report elements

`NumberOfMeasureReports`

- is **required**
- type: `integer`

##### NumberOfMeasureReports Type

`integer`

- minimum value: `0`

#### PacketsReceived

##### Unsigned integar with wrapping

The total number of packets received from the associated STA

`PacketsReceived`

- is **required**
- type: reference

##### PacketsReceived Type

`integer`

- minimum value: `0`

#### PacketsSent

##### Unsigned integar with wrapping

The total number of packets transmitted to the associated STA.

`PacketsSent`

- is **required**
- type: reference

##### PacketsSent Type

`integer`

- minimum value: `0`

#### RetransCount

##### Unsigned integar with wrapping

The total number of transmitted packets to the associated STA which were retransmissions. Two retransmissions of the
same packet results in this counter incrementing by two.

`RetransCount`

- is **required**
- type: reference

##### RetransCount Type

`integer`

- minimum value: `0`

#### SignalStrength

An indicator of radio signal strength of the uplink from the associated STA to the access point - measured in dBm.

`SignalStrength`

- is **required**
- type: `integer`

##### SignalStrength Type

`integer`

- minimum value: `0`
- maximum value: `220`

#### TimeStamp

##### Timestamp in a format

The time this group was collected.

`TimeStamp`

- is **required**
- type: reference

##### TimeStamp Type

`string`

#### UtilizationReceive

The amount of time the radio has spent on the channel receiving data from this STA in milliseconds.

`UtilizationReceive`

- is **required**
- type: `integer`

##### UtilizationReceive Type

`integer`

- minimum value: `0`

#### UtilizationTransmit

The amount of time the radio has spent on the channel transmitting data to this STA in milliseconds

`UtilizationTransmit`

- is **required**
- type: `integer`

##### UtilizationTransmit Type

`integer`

- minimum value: `0`

#### VHTCapabilities

##### Binary encoded Number

VHT capabilities of the associated STA

`VHTCapabilities`

- is **required**
- type: reference

##### VHTCapabilities Type

`string`

This object describes a single STA.

#### TimeStamp

##### Timestamp in a format

The time this group was collected

`TimeStamp`

- is **required**
- type: reference

##### TimeStamp Type

`string`

#### UnicastBytesReceived

BSS wide statistics for total unicast bytes received.

`UnicastBytesReceived`

- is **required**
- type: `integer`

##### UnicastBytesReceived Type

`integer`

- minimum value: `0`

#### UnicastBytesSent

BSS wide statistics for total unicast bytes transmitted

`UnicastBytesSent`

- is **required**
- type: `integer`

##### UnicastBytesSent Type

`integer`

- minimum value: `0`

This object describes a single logical BSS operating on this radio.

#### BackhaulSta

Contains the MAC address of the STA on this radio providing Wi-Fi backhaul to this device

`BackhaulSta`

- is **required**
- type: complex

##### BackhaulSta Type

Unknown type ``.

```json
{
  "description": "Contains the MAC address of the STA on this radio providing Wi-Fi backhaul to this device",
  "ref": "#/definitions/DataElements:BackhaulSTA_t",
  "simpletype": "complex"
}
```

#### Capabilities

Describes the Wi-Fi capabilities of the radio.

`Capabilities`

- is **required**
- type: complex

##### Capabilities Type

Unknown type ``.

```json
{
  "description": "Describes the Wi-Fi capabilities of the radio.",
  "ref": "#/definitions/DataElements:Capabilities_t",
  "simpletype": "complex"
}
```

#### CurrentOperatingClasses

Describes the list of operating classes

`CurrentOperatingClasses`

- is **required**
- type: reference

##### CurrentOperatingClasses Type

Array type: reference

All items must be of the type: `object` with following properties:

| Property    | Type    | Required     |
| ----------- | ------- | ------------ |
| `Channel`   | integer | **Required** |
| `Class`     | integer | **Required** |
| `TimeStamp` | string  | **Required** |
| `TxPower`   | integer | **Required** |

#### Channel

The channel number in the operating class in the previous field that this radio is currently operating on.

`Channel`

- is **required**
- type: `integer`

##### Channel Type

`integer`

- minimum value: `0`
- maximum value: `255`

#### Class

Operating class per Table that this radio is currently operating on.

`Class`

- is **required**
- type: `integer`

##### Class Type

`integer`

- minimum value: `0`
- maximum value: `255`

#### TimeStamp

##### Timestamp in a format

The time this group was collected.

`TimeStamp`

- is **required**
- type: reference

##### TimeStamp Type

`string`

#### TxPower

Nominal transmit power EIRP that this radio is currently using for the current channel in the operating class

`TxPower`

- is **required**
- type: `integer`

##### TxPower Type

`integer`

- minimum value: `-127`
- maximum value: `127`

This object describes one of the current operating classes in use by the radio. One operating class is indicated for
each current operating bandwidth (e.g., 80, 40 and 20 MHz operating classes for a radio operating a BSS with supported
bandwidth of 80 MHz). The channel indicated for the 20 MHz operating class is equal to the current primary channel.

#### Enabled

Indicates whether this radio is enabled.

`Enabled`

- is **required**
- type: `boolean`

##### Enabled Type

`boolean`

#### ID

##### Binary encoded Number

Unique ID for this radio

`ID`

- is **required**
- type: reference

##### ID Type

`string`

#### Noise

An indicator of the average radio noise plus interference power measured for the primary operating channel

`Noise`

- is **required**
- type: `integer`

##### Noise Type

`integer`

- minimum value: `0`
- maximum value: `220`

#### NumberOfBSS

The number of logical BSSs configured on this radio.

`NumberOfBSS`

- is **required**
- type: `integer`

##### NumberOfBSS Type

`integer`

- minimum value: `0`
- maximum value: `65535`

#### NumberOfCurrOpClass

The number of current operating classes

`NumberOfCurrOpClass`

- is **required**
- type: `integer`

##### NumberOfCurrOpClass Type

`integer`

- minimum value: `0`

#### NumberOfUnassocSta

The number of unassociated STAs.

`NumberOfUnassocSta`

- is **required**
- type: `integer`

##### NumberOfUnassocSta Type

`integer`

- minimum value: `0`
- maximum value: `65535`

#### ReceiveOther

The percentage of time (linearly scaled with 255 representing 100%) the radio has spent on receiving valid IEEE 802.11
PPDUs that are not associated with any BSS operating on this radio. When more than one channel is in use by BSS
operating on the radio, then the ReceiveOther value is calculated only for the primary channel

`ReceiveOther`

- is **required**
- type: `integer`

##### ReceiveOther Type

`integer`

- minimum value: `0`
- maximum value: `255`

#### ReceiveSelf

The percentage of time (linearly scaled with 255 representing 100%) the radio has spent on receiving individually or
group addressed transmissions from any STA associated with any BSS operating on this radio. When more than one channel
is in use by BSS operating on the radio, then the ReceiveSelf value is calculated only for the primary channel.

`ReceiveSelf`

- is **required**
- type: `integer`

##### ReceiveSelf Type

`integer`

- minimum value: `0`
- maximum value: `255`

#### ScanResultList

The results of the latest scan for neighboring BSS by the radio.

`ScanResultList`

- is **required**
- type: complex

##### ScanResultList Type

Unknown type ``.

```json
{
  "description": "The results of the latest scan for neighboring BSS by the radio.",
  "ref": "#/definitions/DataElements:ScanResult_t",
  "simpletype": "complex"
}
```

#### Transmit

The percentage of time (linearly scaled with 255 representing 100%) the radio has spent on individually or group
addressed transmissions by the AP. When more than one channel is in use by BSS operating on the radio, then the
Transmit value is calculated only for the primary channel.

`Transmit`

- is **required**
- type: `integer`

##### Transmit Type

`integer`

- minimum value: `0`
- maximum value: `255`

#### UnassociatedStaList

The list of Non-AP STAs that have been discovered by the radio but are not associated to any of the BSS operating on
the radio

`UnassociatedStaList`

- is **required**
- type: reference

##### UnassociatedStaList Type

Array type: reference

All items must be of the type: `object` with following properties:

| Property         | Type    | Required     |
| ---------------- | ------- | ------------ |
| `MACAddress`     | string  | **Required** |
| `SignalStrength` | integer | **Required** |

#### MACAddress

##### MAC Address

The MAC address of a Non-AP STA that has been discovered by the radio but is not associated to any of the BSS operating
on the radio.

`MACAddress`

- is **required**
- type: reference

##### MACAddress Type

`string`

- minimum length: 17 characters
- maximum length: 17 characters All instances must conform to this regular expression (test examples
  [here](<https://regexr.com/?expression=%5E(%5B0-9a-fA-F%5D%5B0-9a-fA-F%5D%3A)%7B5%7D%5B0-9a-fA-F%5D%5B0-9a-fA-F%5D%24>)):

```regex
^([0-9a-fA-F][0-9a-fA-F]:){5}[0-9a-fA-F][0-9a-fA-F]$
```

#### SignalStrength

An indicator of radio signal strength (RCPI) of the uplink from the Non-AP STA - measured in dBm

`SignalStrength`

- is **required**
- type: `integer`

##### SignalStrength Type

`integer`

- minimum value: `0`
- maximum value: `220`

This object describes a single currently unassociated STA.

#### Utilization

The current total channel utilization on the current primary channel of the radio

`Utilization`

- is **required**
- type: `integer`

##### Utilization Type

`integer`

- minimum value: `0`
- maximum value: `255`

This object describes a single physical radio within a specific AP

This object describes a device.

#### ID

A unique identifier for this particular Wi-Fi network

`ID`

- is **required**
- type: `string`

##### ID Type

`string`

#### NumberOfDevices

Number of devices in the given network

`NumberOfDevices`

- is **required**
- type: `integer`

##### NumberOfDevices Type

`integer`

- minimum value: `0`
- maximum value: `65535`

#### TimeStamp

##### Timestamp in a format

The time this group was collected.

`TimeStamp`

- is **required**
- type: reference

##### TimeStamp Type

`string`

#### date

`date`

- is **required**
- type: `string`

##### date Type

`string`

#### description

`description`

- is **required**
- type: `string`

##### description Type

`string`

#### name

`name`

- is **required**
- type: `string`

##### name Type

`string`

#### timestamp

`timestamp`

- is **required**
- type: `string`

##### timestamp Type

`string`

#### version

`version`

- is **required**
- type: `string`

##### version Type

`string`

### Output Example

```json
{
  "date": "nostrud voluptate ut aliquip reprehenderit",
  "version": "dolore culpa",
  "description": "ad aliqua aute",
  "timestamp": "consequat eu eiusmod do in",
  "name": "culpa elit",
  "DataElements:Network": {
    "ID": "in consectetur quis",
    "NumberOfDevices": 1244,
    "ControllerID": "mollit in fugiat sit",
    "TimeStamp": "velit occaecat elit",
    "DeviceList": [
      {
        "ID": "6F:FE:dC:c0:2C:6D",
        "MultiAPCapabilities": "irure est nostrud",
        "NumberOfRadios": 20705,
        "CollectionInterval": 49614194,
        "RadioList": [
          {
            "ID": "eu cupidatat ipsum mollit proident",
            "Enabled": false,
            "CurrentOperatingClasses": [
              { "TimeStamp": "et exercitation", "Class": 72, "Channel": 85, "TxPower": 45 },
              { "TimeStamp": "occaecat aliquip", "Class": 107, "Channel": 181, "TxPower": 17 }
            ],
            "NumberOfCurrOpClass": 12219980,
            "Noise": 20,
            "Utilization": 95,
            "Transmit": 150,
            "ReceiveSelf": 47,
            "ReceiveOther": 63,
            "NumberOfBSS": 26027,
            "BSSList": [
              {
                "BSSID": "Ed:97:62:F6:4D:c2",
                "SSID": "sit id",
                "Enabled": true,
                "LastChange": 67469589,
                "TimeStamp": "irure nulla sint aliqua",
                "UnicastBytesSent": 68617699,
                "UnicastBytesReceived": 75475655,
                "MulticastBytesSent": 33349609,
                "MulticastBytesReceived": 54008945,
                "BroadcastBytesSent": 87021568,
                "BroadcastBytesReceived": 52690851,
                "STAList": [
                  {
                    "MACAddress": "be:B8:24:B1:D9:FE",
                    "TimeStamp": "Ut velit qui",
                    "HTCapabilities": "irure",
                    "VHTCapabilities": "non adipisicing Lorem minim commodo",
                    "HECapabilities": "nostrud qui reprehenderit aliquip sit",
                    "LastDataDownlinkRate": 38690506,
                    "LastDataUplinkRate": 88635765,
                    "UtilizationReceive": 11256238,
                    "UtilizationTransmit": 54501191,
                    "EstMACDataRateDownlink": 93137944,
                    "EstMACDataRateUplink": 81880184,
                    "SignalStrength": 46,
                    "LastConnectTime": 57222499,
                    "BytesSent": 70860562,
                    "BytesReceived": 59922405,
                    "PacketsSent": 75300635,
                    "PacketsReceived": 74569530,
                    "ErrorsSent": 51316521,
                    "ErrorsReceived": 32540020,
                    "RetransCount": 26515360,
                    "MeasurementReport": ["dolore", "consequat incididunt adi", "o"],
                    "NumberOfMeasureReports": 39351419,
                    "IPV4Address": "voluptate laborum minim labore",
                    "IPV6Address": "sunt deserunt qui",
                    "Hostname": "sed eiusmod"
                  },
                  {
                    "MACAddress": "e9:Cc:5d:c6:4B:a5",
                    "TimeStamp": "nulla ",
                    "HTCapabilities": "sit in adipisicing",
                    "VHTCapabilities": "tempor reprehenderit",
                    "HECapabilities": "mollit fugiat officia labor",
                    "LastDataDownlinkRate": 35321629,
                    "LastDataUplinkRate": 97868606,
                    "UtilizationReceive": 88900702,
                    "UtilizationTransmit": 26166844,
                    "EstMACDataRateDownlink": 42635435,
                    "EstMACDataRateUplink": 75056347,
                    "SignalStrength": 4,
                    "LastConnectTime": 51034013,
                    "BytesSent": 88907728,
                    "BytesReceived": 84470988,
                    "PacketsSent": 71110269,
                    "PacketsReceived": 39222979,
                    "ErrorsSent": 94147386,
                    "ErrorsReceived": 65484822,
                    "RetransCount": 59712535,
                    "MeasurementReport": [
                      "officia",
                      "nulla ullamco",
                      "aliqua voluptate ad eiusmod ut",
                      "deserunt al",
                      "ipsum non ea amet exercitation"
                    ],
                    "NumberOfMeasureReports": 31474364,
                    "IPV4Address": "id irure in Ut dolore",
                    "IPV6Address": "quis sint ullamco",
                    "Hostname": "id"
                  },
                  {
                    "MACAddress": "8A:CE:ED:24:b1:fE",
                    "TimeStamp": "fugiat",
                    "HTCapabilities": "fugiat",
                    "VHTCapabilities": "irure",
                    "HECapabilities": "cillum",
                    "LastDataDownlinkRate": 69859550,
                    "LastDataUplinkRate": 28222540,
                    "UtilizationReceive": 59182259,
                    "UtilizationTransmit": 57816840,
                    "EstMACDataRateDownlink": 82736723,
                    "EstMACDataRateUplink": 46227840,
                    "SignalStrength": 20,
                    "LastConnectTime": 83119868,
                    "BytesSent": 49906022,
                    "BytesReceived": 30634982,
                    "PacketsSent": 14937584,
                    "PacketsReceived": 63353371,
                    "ErrorsSent": 74445811,
                    "ErrorsReceived": 38165622,
                    "RetransCount": 895340,
                    "MeasurementReport": [
                      "enim quis aliqua qui et",
                      "exercitation nisi",
                      "est dolor aliquip magna et"
                    ],
                    "NumberOfMeasureReports": 18909721,
                    "IPV4Address": "non exercitation enim laboris",
                    "IPV6Address": "commodo amet aliquip nostrud esse",
                    "Hostname": "commodo aliquip pariatur"
                  },
                  {
                    "MACAddress": "39:bF:DC:AB:1B:90",
                    "TimeStamp": "sint nulla id velit qui",
                    "HTCapabilities": "officia",
                    "VHTCapabilities": "dolore",
                    "HECapabilities": "dolore ut",
                    "LastDataDownlinkRate": 28887120,
                    "LastDataUplinkRate": 74779568,
                    "UtilizationReceive": 67497149,
                    "UtilizationTransmit": 22660356,
                    "EstMACDataRateDownlink": 76339225,
                    "EstMACDataRateUplink": 39253776,
                    "SignalStrength": 86,
                    "LastConnectTime": 60092481,
                    "BytesSent": 31676680,
                    "BytesReceived": 7568352,
                    "PacketsSent": 25149376,
                    "PacketsReceived": 99836178,
                    "ErrorsSent": 49251038,
                    "ErrorsReceived": 8620771,
                    "RetransCount": 19817790,
                    "MeasurementReport": [
                      "velit anim",
                      "sint pariatur dolore ullamco magna",
                      "enim dolor deserunt dolor Lorem",
                      "nostrud ipsum nulla magna nisi",
                      "magna "
                    ],
                    "NumberOfMeasureReports": 36708079,
                    "IPV4Address": "do nisi",
                    "IPV6Address": "Excepteur dolor Ut commodo reprehenderit",
                    "Hostname": "in"
                  },
                  {
                    "MACAddress": "F7:7a:a3:ee:4b:cB",
                    "TimeStamp": "exercitation proident pariatur",
                    "HTCapabilities": "elit amet ut pariatur ullamco",
                    "VHTCapabilities": "in Duis cillum",
                    "HECapabilities": "amet non cillum",
                    "LastDataDownlinkRate": 19411195,
                    "LastDataUplinkRate": 99590972,
                    "UtilizationReceive": 73288556,
                    "UtilizationTransmit": 73954031,
                    "EstMACDataRateDownlink": 1339445,
                    "EstMACDataRateUplink": 93399316,
                    "SignalStrength": 108,
                    "LastConnectTime": 11942745,
                    "BytesSent": 54605124,
                    "BytesReceived": 23368757,
                    "PacketsSent": 74678616,
                    "PacketsReceived": 66160062,
                    "ErrorsSent": 36770853,
                    "ErrorsReceived": 14835555,
                    "RetransCount": 90318107,
                    "MeasurementReport": [
                      "in elit exercitation",
                      "voluptate nulla consectetur dolore consequat",
                      "magna",
                      "ut sunt adipisicing",
                      "Duis ipsum sint sit tempor"
                    ],
                    "NumberOfMeasureReports": 50139852,
                    "IPV4Address": "sunt in",
                    "IPV6Address": "sint tempor el",
                    "Hostname": "aliqua ad dolore"
                  }
                ],
                "NumberOfSTA": 18225,
                "EstServiceParametersBE": "adipisicing occaecat elit",
                "EstServiceParametersBK": "in sed",
                "EstServiceParametersVI": "minim incididunt nisi ea",
                "EstServiceParametersVO": "voluptate ad aliqui"
              },
              {
                "BSSID": "98:7b:A1:be:f4:C8",
                "SSID": "sunt",
                "Enabled": false,
                "LastChange": 95474198,
                "TimeStamp": "consectetur Lorem aliqua",
                "UnicastBytesSent": 73292223,
                "UnicastBytesReceived": 19692712,
                "MulticastBytesSent": 59857642,
                "MulticastBytesReceived": 82895250,
                "BroadcastBytesSent": 9713083,
                "BroadcastBytesReceived": 56998550,
                "STAList": [
                  {
                    "MACAddress": "48:41:77:cc:E2:9C",
                    "TimeStamp": "Lorem",
                    "HTCapabilities": "Excepteur fugiat",
                    "VHTCapabilities": "ipsum adipisicing eiusmod in",
                    "HECapabilities": "elit",
                    "LastDataDownlinkRate": 6787029,
                    "LastDataUplinkRate": 91514365,
                    "UtilizationReceive": 32217681,
                    "UtilizationTransmit": 37900406,
                    "EstMACDataRateDownlink": 61976194,
                    "EstMACDataRateUplink": 85347224,
                    "SignalStrength": 98,
                    "LastConnectTime": 59401785,
                    "BytesSent": 26473755,
                    "BytesReceived": 81743792,
                    "PacketsSent": 58862444,
                    "PacketsReceived": 15663648,
                    "ErrorsSent": 71661873,
                    "ErrorsReceived": 67138457,
                    "RetransCount": 34169762,
                    "MeasurementReport": [
                      "reprehenderit do ea",
                      "reprehenderit veniam eiusmod",
                      "ullamco qui culpa enim non"
                    ],
                    "NumberOfMeasureReports": 3686648,
                    "IPV4Address": "mollit ad do aliquip",
                    "IPV6Address": "adipis",
                    "Hostname": "deserunt esse in qui nisi"
                  },
                  {
                    "MACAddress": "eA:C1:7b:BF:7E:d5",
                    "TimeStamp": "in cillum sit",
                    "HTCapabilities": "Excepteur consectetur",
                    "VHTCapabilities": "sit commodo",
                    "HECapabilities": "consequat minim sint dolor",
                    "LastDataDownlinkRate": 54435948,
                    "LastDataUplinkRate": 40602477,
                    "UtilizationReceive": 37650347,
                    "UtilizationTransmit": 36524783,
                    "EstMACDataRateDownlink": 84682340,
                    "EstMACDataRateUplink": 12951345,
                    "SignalStrength": 4,
                    "LastConnectTime": 31432532,
                    "BytesSent": 13018783,
                    "BytesReceived": 41884479,
                    "PacketsSent": 51909410,
                    "PacketsReceived": 63603637,
                    "ErrorsSent": 60620513,
                    "ErrorsReceived": 4922918,
                    "RetransCount": 41543690,
                    "MeasurementReport": ["eu mollit non dolor", "tempor"],
                    "NumberOfMeasureReports": 60172655,
                    "IPV4Address": "fugiat aliqua non",
                    "IPV6Address": "voluptate",
                    "Hostname": "nul"
                  },
                  {
                    "MACAddress": "61:d3:Bd:79:4e:Fd",
                    "TimeStamp": "dolor",
                    "HTCapabilities": "consequat mollit nisi",
                    "VHTCapabilities": "do",
                    "HECapabilities": "sint tempor reprehenderit",
                    "LastDataDownlinkRate": 31707135,
                    "LastDataUplinkRate": 92854960,
                    "UtilizationReceive": 41300264,
                    "UtilizationTransmit": 87617720,
                    "EstMACDataRateDownlink": 57620967,
                    "EstMACDataRateUplink": 89183632,
                    "SignalStrength": 149,
                    "LastConnectTime": 91830225,
                    "BytesSent": 38432980,
                    "BytesReceived": 29805958,
                    "PacketsSent": 17062008,
                    "PacketsReceived": 66841205,
                    "ErrorsSent": 22109183,
                    "ErrorsReceived": 51979901,
                    "RetransCount": 71403683,
                    "MeasurementReport": ["sed", "ut sit", "nostrud ullamco occaecat"],
                    "NumberOfMeasureReports": 12633540,
                    "IPV4Address": "laboris sint ad culpa sunt",
                    "IPV6Address": "proident labore Excepteur qui",
                    "Hostname": "ad dolor sit"
                  }
                ],
                "NumberOfSTA": 46303,
                "EstServiceParametersBE": "anim cupidatat magna consequat deseru",
                "EstServiceParametersBK": "adipisicing do deserunt",
                "EstServiceParametersVI": "laborum proident Ut",
                "EstServiceParametersVO": "magna Duis sunt ipsum"
              },
              {
                "BSSID": "EF:dd:eC:a8:61:6E",
                "SSID": "nulla consectetur",
                "Enabled": false,
                "LastChange": 62289212,
                "TimeStamp": "id nulla nostrud",
                "UnicastBytesSent": 35515020,
                "UnicastBytesReceived": 87901791,
                "MulticastBytesSent": 47372151,
                "MulticastBytesReceived": 56815474,
                "BroadcastBytesSent": 13050490,
                "BroadcastBytesReceived": 29284562,
                "STAList": [
                  {
                    "MACAddress": "41:5f:79:Ed:D8:7d",
                    "TimeStamp": "eu",
                    "HTCapabilities": "in incididunt cillum pariatur",
                    "VHTCapabilities": "nostrud occaecat ut mollit veniam",
                    "HECapabilities": "non",
                    "LastDataDownlinkRate": 76478826,
                    "LastDataUplinkRate": 70394444,
                    "UtilizationReceive": 62149887,
                    "UtilizationTransmit": 54108273,
                    "EstMACDataRateDownlink": 28548827,
                    "EstMACDataRateUplink": 42389572,
                    "SignalStrength": 193,
                    "LastConnectTime": 77104223,
                    "BytesSent": 48302544,
                    "BytesReceived": 10709296,
                    "PacketsSent": 81030140,
                    "PacketsReceived": 67189648,
                    "ErrorsSent": 57344085,
                    "ErrorsReceived": 23849123,
                    "RetransCount": 68570634,
                    "MeasurementReport": [
                      "consequat labore ",
                      "in culpa",
                      "mollit amet",
                      "nostrud fugiat id culpa sed"
                    ],
                    "NumberOfMeasureReports": 65859347,
                    "IPV4Address": "reprehenderit elit labore culpa",
                    "IPV6Address": "ad do Duis",
                    "Hostname": "sed esse ex fugiat exercitation"
                  },
                  {
                    "MACAddress": "b0:EF:12:D2:0e:CD",
                    "TimeStamp": "reprehenderit",
                    "HTCapabilities": "aute ad",
                    "VHTCapabilities": "ipsum",
                    "HECapabilities": "eu",
                    "LastDataDownlinkRate": 6169128,
                    "LastDataUplinkRate": 95230037,
                    "UtilizationReceive": 29196333,
                    "UtilizationTransmit": 9389204,
                    "EstMACDataRateDownlink": 4465882,
                    "EstMACDataRateUplink": 87169368,
                    "SignalStrength": 135,
                    "LastConnectTime": 53859223,
                    "BytesSent": 57819344,
                    "BytesReceived": 94708187,
                    "PacketsSent": 52861996,
                    "PacketsReceived": 49931179,
                    "ErrorsSent": 20335886,
                    "ErrorsReceived": 8595554,
                    "RetransCount": 15244338,
                    "MeasurementReport": ["", "minim", "labore proident dolore"],
                    "NumberOfMeasureReports": 34322621,
                    "IPV4Address": "ut nulla in esse",
                    "IPV6Address": "est cillum exercitation consequat dolor",
                    "Hostname": "eu sint reprehenderit"
                  },
                  {
                    "MACAddress": "4a:0f:CD:E3:aA:50",
                    "TimeStamp": "nisi Lorem nostrud mollit",
                    "HTCapabilities": "commodo sunt",
                    "VHTCapabilities": "dolore mollit adipisicing dolor",
                    "HECapabilities": "pariatur Ut commodo",
                    "LastDataDownlinkRate": 87816188,
                    "LastDataUplinkRate": 63096915,
                    "UtilizationReceive": 64684618,
                    "UtilizationTransmit": 69706883,
                    "EstMACDataRateDownlink": 40857997,
                    "EstMACDataRateUplink": 92031554,
                    "SignalStrength": 105,
                    "LastConnectTime": 10089273,
                    "BytesSent": 11742696,
                    "BytesReceived": 15168163,
                    "PacketsSent": 99966142,
                    "PacketsReceived": 84052427,
                    "ErrorsSent": 93290582,
                    "ErrorsReceived": 10316910,
                    "RetransCount": 26259113,
                    "MeasurementReport": [
                      "culpa in",
                      "eiusmod",
                      "in reprehenderit",
                      "laborum officia laboris sit mollit"
                    ],
                    "NumberOfMeasureReports": 71672289,
                    "IPV4Address": "exercitation in officia quis",
                    "IPV6Address": "nulla sunt eiusmod",
                    "Hostname": "ut"
                  }
                ],
                "NumberOfSTA": 40092,
                "EstServiceParametersBE": "minim magna",
                "EstServiceParametersBK": "ut nulla Lorem",
                "EstServiceParametersVI": "commodo dolor eu consequat",
                "EstServiceParametersVO": "ex pariatur ea"
              },
              {
                "BSSID": "CA:F7:78:32:2e:BD",
                "SSID": "ipsum",
                "Enabled": true,
                "LastChange": 70938243,
                "TimeStamp": "",
                "UnicastBytesSent": 19698651,
                "UnicastBytesReceived": 74059699,
                "MulticastBytesSent": 11310922,
                "MulticastBytesReceived": 94154025,
                "BroadcastBytesSent": 89348282,
                "BroadcastBytesReceived": 10350009,
                "STAList": [
                  {
                    "MACAddress": "43:67:C9:c9:fB:A1",
                    "TimeStamp": "quis culpa",
                    "HTCapabilities": "anim aliquip",
                    "VHTCapabilities": "Excepteur f",
                    "HECapabilities": "eiusmod",
                    "LastDataDownlinkRate": 69464933,
                    "LastDataUplinkRate": 37885493,
                    "UtilizationReceive": 94993364,
                    "UtilizationTransmit": 2279425,
                    "EstMACDataRateDownlink": 93565398,
                    "EstMACDataRateUplink": 71914741,
                    "SignalStrength": 72,
                    "LastConnectTime": 49221599,
                    "BytesSent": 46157454,
                    "BytesReceived": 17591281,
                    "PacketsSent": 45411596,
                    "PacketsReceived": 900331,
                    "ErrorsSent": 89938922,
                    "ErrorsReceived": 11007173,
                    "RetransCount": 22375944,
                    "MeasurementReport": ["in", "id eiusmod", "non", "sint Ut anim dolore est"],
                    "NumberOfMeasureReports": 48683776,
                    "IPV4Address": "esse",
                    "IPV6Address": "esse ut tempor",
                    "Hostname": "Lorem fugiat in in exercitation"
                  },
                  {
                    "MACAddress": "0F:63:CA:36:e0:bF",
                    "TimeStamp": "sit nulla con",
                    "HTCapabilities": "proident qui",
                    "VHTCapabilities": "pariatur",
                    "HECapabilities": "incididunt vo",
                    "LastDataDownlinkRate": 2383194,
                    "LastDataUplinkRate": 23248716,
                    "UtilizationReceive": 8176815,
                    "UtilizationTransmit": 37727440,
                    "EstMACDataRateDownlink": 30839372,
                    "EstMACDataRateUplink": 19371702,
                    "SignalStrength": 180,
                    "LastConnectTime": 68844234,
                    "BytesSent": 49476770,
                    "BytesReceived": 77406964,
                    "PacketsSent": 79114014,
                    "PacketsReceived": 92190597,
                    "ErrorsSent": 99097618,
                    "ErrorsReceived": 48213625,
                    "RetransCount": 13600605,
                    "MeasurementReport": ["est dolor tempor Ut mollit", "veniam proident ad aliquip Duis"],
                    "NumberOfMeasureReports": 42239739,
                    "IPV4Address": "ullamco cillum",
                    "IPV6Address": "ea elit magna",
                    "Hostname": "conse"
                  }
                ],
                "NumberOfSTA": 6427,
                "EstServiceParametersBE": "exe",
                "EstServiceParametersBK": "voluptate in deserunt",
                "EstServiceParametersVI": "consequat et in consectetur proident",
                "EstServiceParametersVO": "ea"
              }
            ],
            "Capabilities": {
              "description": "Describes the Wi-Fi capabilities of the radio.",
              "ref": "#/definitions/DataElements:Capabilities_t"
            },
            "BackhaulSta": {
              "description": "Contains the MAC address of the STA on this radio providing Wi-Fi backhaul to this device",
              "ref": "#/definitions/DataElements:BackhaulSTA_t"
            },
            "ScanResultList": {
              "description": "The results of the latest scan for neighboring BSS by the radio.",
              "ref": "#/definitions/DataElements:ScanResult_t"
            },
            "UnassociatedStaList": [
              { "MACAddress": "13:8e:da:aE:BA:1C", "SignalStrength": 154 },
              { "MACAddress": "E3:57:f2:08:72:d0", "SignalStrength": 90 },
              { "MACAddress": "Ee:3f:Ab:D6:73:8d", "SignalStrength": 172 },
              { "MACAddress": "6b:1E:9C:EC:9E:cE", "SignalStrength": 187 }
            ],
            "NumberOfUnassocSta": 47435
          }
        ]
      },
      {
        "ID": "4b:B8:4f:F6:9e:be",
        "MultiAPCapabilities": "dolore magna",
        "NumberOfRadios": 23713,
        "CollectionInterval": 58542741,
        "RadioList": [
          {
            "ID": "consectetur do ipsum",
            "Enabled": true,
            "CurrentOperatingClasses": [
              { "TimeStamp": "nisi laboris ut et", "Class": 86, "Channel": 32, "TxPower": 30 },
              { "TimeStamp": "eu ir", "Class": 199, "Channel": 253, "TxPower": 73 },
              { "TimeStamp": "non exercitation", "Class": 117, "Channel": 255, "TxPower": -28 },
              { "TimeStamp": "dolor reprehenderit", "Class": 64, "Channel": 178, "TxPower": -78 }
            ],
            "NumberOfCurrOpClass": 88609187,
            "Noise": 116,
            "Utilization": 176,
            "Transmit": 242,
            "ReceiveSelf": 150,
            "ReceiveOther": 250,
            "NumberOfBSS": 46441,
            "BSSList": [
              {
                "BSSID": "c2:C3:3D:e8:E2:f1",
                "SSID": "tempor ex incididunt anim sit",
                "Enabled": false,
                "LastChange": 73097125,
                "TimeStamp": "adipisicing",
                "UnicastBytesSent": 48307469,
                "UnicastBytesReceived": 22727369,
                "MulticastBytesSent": 6684197,
                "MulticastBytesReceived": 81369495,
                "BroadcastBytesSent": 3033120,
                "BroadcastBytesReceived": 25120021,
                "STAList": [
                  {
                    "MACAddress": "bF:60:dD:00:13:A7",
                    "TimeStamp": "elit nulla fugia",
                    "HTCapabilities": "tempor magna dolore ",
                    "VHTCapabilities": "elit esse",
                    "HECapabilities": "nulla velit sit nisi est",
                    "LastDataDownlinkRate": 13985720,
                    "LastDataUplinkRate": 52313045,
                    "UtilizationReceive": 68509845,
                    "UtilizationTransmit": 12159439,
                    "EstMACDataRateDownlink": 70552069,
                    "EstMACDataRateUplink": 10796977,
                    "SignalStrength": 16,
                    "LastConnectTime": 49936790,
                    "BytesSent": 67366834,
                    "BytesReceived": 84178026,
                    "PacketsSent": 2317649,
                    "PacketsReceived": 35604128,
                    "ErrorsSent": 80071305,
                    "ErrorsReceived": 61664740,
                    "RetransCount": 71278641,
                    "MeasurementReport": ["tempor"],
                    "NumberOfMeasureReports": 71423756,
                    "IPV4Address": "commodo incididunt occaecat sunt",
                    "IPV6Address": "sed occae",
                    "Hostname": "incididunt veniam deserunt"
                  },
                  {
                    "MACAddress": "bE:96:bF:48:C0:A0",
                    "TimeStamp": "officia dolor ut culpa",
                    "HTCapabilities": "reprehender",
                    "VHTCapabilities": "labore Excepteur minim est",
                    "HECapabilities": "enim",
                    "LastDataDownlinkRate": 57050384,
                    "LastDataUplinkRate": 32941889,
                    "UtilizationReceive": 54690523,
                    "UtilizationTransmit": 88706320,
                    "EstMACDataRateDownlink": 3940134,
                    "EstMACDataRateUplink": 90057717,
                    "SignalStrength": 30,
                    "LastConnectTime": 71491582,
                    "BytesSent": 8406267,
                    "BytesReceived": 24269563,
                    "PacketsSent": 55516161,
                    "PacketsReceived": 82417786,
                    "ErrorsSent": 9513631,
                    "ErrorsReceived": 40312897,
                    "RetransCount": 63896251,
                    "MeasurementReport": ["est commodo adipisicing nulla eu"],
                    "NumberOfMeasureReports": 36791683,
                    "IPV4Address": "enim ipsum",
                    "IPV6Address": "in pariatur consequat commodo",
                    "Hostname": "aliqua ut fugiat commodo"
                  },
                  {
                    "MACAddress": "f8:Ed:c9:EB:10:26",
                    "TimeStamp": "deserunt Excepteur qui elit",
                    "HTCapabilities": "e",
                    "VHTCapabilities": "conse",
                    "HECapabilities": "do culpa anim officia eu",
                    "LastDataDownlinkRate": 23450948,
                    "LastDataUplinkRate": 38335689,
                    "UtilizationReceive": 39352342,
                    "UtilizationTransmit": 21395109,
                    "EstMACDataRateDownlink": 37738167,
                    "EstMACDataRateUplink": 12874239,
                    "SignalStrength": 153,
                    "LastConnectTime": 38542745,
                    "BytesSent": 35767845,
                    "BytesReceived": 25103395,
                    "PacketsSent": 46831263,
                    "PacketsReceived": 23306981,
                    "ErrorsSent": 61225758,
                    "ErrorsReceived": 22024061,
                    "RetransCount": 89373114,
                    "MeasurementReport": ["Duis nisi laboris labore", "aliqua"],
                    "NumberOfMeasureReports": 90815266,
                    "IPV4Address": "dolore non laborum laboris",
                    "IPV6Address": "nulla qui magna d",
                    "Hostname": "ex eu"
                  },
                  {
                    "MACAddress": "D5:C2:d4:26:2e:17",
                    "TimeStamp": "sunt Ut labore quis nostrud",
                    "HTCapabilities": "cupidatat ani",
                    "VHTCapabilities": "ut eu",
                    "HECapabilities": "minim deserunt anim ",
                    "LastDataDownlinkRate": 2720845,
                    "LastDataUplinkRate": 56569967,
                    "UtilizationReceive": 54490399,
                    "UtilizationTransmit": 33080268,
                    "EstMACDataRateDownlink": 26050905,
                    "EstMACDataRateUplink": 52371678,
                    "SignalStrength": 161,
                    "LastConnectTime": 40098863,
                    "BytesSent": 42116272,
                    "BytesReceived": 40503198,
                    "PacketsSent": 17828513,
                    "PacketsReceived": 88266348,
                    "ErrorsSent": 27975781,
                    "ErrorsReceived": 39313049,
                    "RetransCount": 55974516,
                    "MeasurementReport": ["in culpa"],
                    "NumberOfMeasureReports": 72786552,
                    "IPV4Address": "occaecat laboris",
                    "IPV6Address": "cupidatat co",
                    "Hostname": "irure"
                  },
                  {
                    "MACAddress": "F6:Ec:Ee:e4:2C:e8",
                    "TimeStamp": "sit voluptate ut",
                    "HTCapabilities": "nulla",
                    "VHTCapabilities": "cupidatat deserunt enim in",
                    "HECapabilities": "officia",
                    "LastDataDownlinkRate": 86835640,
                    "LastDataUplinkRate": 22393513,
                    "UtilizationReceive": 71308645,
                    "UtilizationTransmit": 46401401,
                    "EstMACDataRateDownlink": 16090956,
                    "EstMACDataRateUplink": 97624836,
                    "SignalStrength": 116,
                    "LastConnectTime": 1037129,
                    "BytesSent": 43144216,
                    "BytesReceived": 2238433,
                    "PacketsSent": 41912475,
                    "PacketsReceived": 70034960,
                    "ErrorsSent": 29475861,
                    "ErrorsReceived": 9802241,
                    "RetransCount": 17288895,
                    "MeasurementReport": ["labore", "et est", "proident", "dolo"],
                    "NumberOfMeasureReports": 38085216,
                    "IPV4Address": "adipisicing cillum nostrud",
                    "IPV6Address": "irure Ut laboris dolore",
                    "Hostname": "sunt qui cupidatat dolor Lorem"
                  }
                ],
                "NumberOfSTA": 50461,
                "EstServiceParametersBE": "non esse pariatur do ea",
                "EstServiceParametersBK": "do",
                "EstServiceParametersVI": "minim amet irure",
                "EstServiceParametersVO": "dolor"
              },
              {
                "BSSID": "a2:98:bA:91:7D:02",
                "SSID": "non dolor ipsum consequat",
                "Enabled": true,
                "LastChange": 22363698,
                "TimeStamp": "mollit nostrud ut",
                "UnicastBytesSent": 27994787,
                "UnicastBytesReceived": 68414134,
                "MulticastBytesSent": 88377617,
                "MulticastBytesReceived": 48138023,
                "BroadcastBytesSent": 15204986,
                "BroadcastBytesReceived": 27570982,
                "STAList": [
                  {
                    "MACAddress": "9E:AC:Ac:b0:3A:48",
                    "TimeStamp": "ut",
                    "HTCapabilities": "quis culpa",
                    "VHTCapabilities": "incididunt anim",
                    "HECapabilities": "nulla qui",
                    "LastDataDownlinkRate": 44799901,
                    "LastDataUplinkRate": 50621407,
                    "UtilizationReceive": 92191350,
                    "UtilizationTransmit": 72967537,
                    "EstMACDataRateDownlink": 12842802,
                    "EstMACDataRateUplink": 6980218,
                    "SignalStrength": 134,
                    "LastConnectTime": 86785315,
                    "BytesSent": 27637765,
                    "BytesReceived": 73659944,
                    "PacketsSent": 18702762,
                    "PacketsReceived": 56887460,
                    "ErrorsSent": 70984273,
                    "ErrorsReceived": 25880448,
                    "RetransCount": 12363236,
                    "MeasurementReport": ["aliquip"],
                    "NumberOfMeasureReports": 1465191,
                    "IPV4Address": "culpa sit nostrud sint",
                    "IPV6Address": "Lorem sint proident sunt Excepteur",
                    "Hostname": "sed Ut laboris ipsum"
                  }
                ],
                "NumberOfSTA": 7045,
                "EstServiceParametersBE": "in",
                "EstServiceParametersBK": "et nulla sed dolor",
                "EstServiceParametersVI": "adipisicing Excepteur dolor eu quis",
                "EstServiceParametersVO": "officia ullamco ut incididunt"
              },
              {
                "BSSID": "d5:09:fd:3e:01:95",
                "SSID": "ipsum eiusmod ut magna fugiat",
                "Enabled": false,
                "LastChange": 72459067,
                "TimeStamp": "aliqua do",
                "UnicastBytesSent": 38353631,
                "UnicastBytesReceived": 1786158,
                "MulticastBytesSent": 66566507,
                "MulticastBytesReceived": 29196805,
                "BroadcastBytesSent": 4279250,
                "BroadcastBytesReceived": 24407925,
                "STAList": [
                  {
                    "MACAddress": "f8:fE:c6:fd:94:6c",
                    "TimeStamp": "ipsum Duis",
                    "HTCapabilities": "ex amet Excepteur",
                    "VHTCapabilities": "do",
                    "HECapabilities": "velit do voluptate",
                    "LastDataDownlinkRate": 34689741,
                    "LastDataUplinkRate": 98767662,
                    "UtilizationReceive": 16529577,
                    "UtilizationTransmit": 26046473,
                    "EstMACDataRateDownlink": 84869838,
                    "EstMACDataRateUplink": 2473055,
                    "SignalStrength": 74,
                    "LastConnectTime": 8478288,
                    "BytesSent": 99186542,
                    "BytesReceived": 46107338,
                    "PacketsSent": 29025239,
                    "PacketsReceived": 37785046,
                    "ErrorsSent": 34566049,
                    "ErrorsReceived": 3958955,
                    "RetransCount": 90667044,
                    "MeasurementReport": [
                      "adipisicing cillum officia cupidatat",
                      "ullamco officia eiusmod",
                      "occaecat",
                      "sunt"
                    ],
                    "NumberOfMeasureReports": 17133532,
                    "IPV4Address": "mollit consectetur Ut",
                    "IPV6Address": "irure ex sed occaecat",
                    "Hostname": "aliquip eu amet voluptate reprehenderit"
                  },
                  {
                    "MACAddress": "Ad:aD:c5:6E:29:42",
                    "TimeStamp": "irure",
                    "HTCapabilities": "dolor nostrud minim",
                    "VHTCapabilities": "tempor sed adipisicing aliquip",
                    "HECapabilities": "ea ullamco",
                    "LastDataDownlinkRate": 18365510,
                    "LastDataUplinkRate": 93205695,
                    "UtilizationReceive": 60240807,
                    "UtilizationTransmit": 23626835,
                    "EstMACDataRateDownlink": 81949458,
                    "EstMACDataRateUplink": 17621902,
                    "SignalStrength": 14,
                    "LastConnectTime": 39072142,
                    "BytesSent": 52206319,
                    "BytesReceived": 1926454,
                    "PacketsSent": 13028672,
                    "PacketsReceived": 11503212,
                    "ErrorsSent": 52684570,
                    "ErrorsReceived": 76623363,
                    "RetransCount": 52455880,
                    "MeasurementReport": ["commodo Ut veniam proi"],
                    "NumberOfMeasureReports": 64526202,
                    "IPV4Address": "aliquip",
                    "IPV6Address": "el",
                    "Hostname": "sed"
                  }
                ],
                "NumberOfSTA": 40814,
                "EstServiceParametersBE": "velit in ullamco commodo Excepteur",
                "EstServiceParametersBK": "eiusmod sint",
                "EstServiceParametersVI": "in commodo",
                "EstServiceParametersVO": "Lorem exercitation commodo Ut"
              },
              {
                "BSSID": "Df:De:a5:d9:Fa:B8",
                "SSID": "consectetur occaecat",
                "Enabled": false,
                "LastChange": 40960675,
                "TimeStamp": "dolor ullamco",
                "UnicastBytesSent": 67679433,
                "UnicastBytesReceived": 44462794,
                "MulticastBytesSent": 76155258,
                "MulticastBytesReceived": 95332362,
                "BroadcastBytesSent": 71415369,
                "BroadcastBytesReceived": 1857796,
                "STAList": [
                  {
                    "MACAddress": "99:c3:8a:2A:7c:5e",
                    "TimeStamp": "cillum esse irure commodo incididunt",
                    "HTCapabilities": "incididunt elit amet id",
                    "VHTCapabilities": "commodo amet aliquip",
                    "HECapabilities": "voluptate Duis mollit sunt esse",
                    "LastDataDownlinkRate": 4706807,
                    "LastDataUplinkRate": 52681306,
                    "UtilizationReceive": 53533280,
                    "UtilizationTransmit": 37957531,
                    "EstMACDataRateDownlink": 52300427,
                    "EstMACDataRateUplink": 56756630,
                    "SignalStrength": 170,
                    "LastConnectTime": 30029721,
                    "BytesSent": 18830094,
                    "BytesReceived": 21808567,
                    "PacketsSent": 86833174,
                    "PacketsReceived": 8667621,
                    "ErrorsSent": 81437366,
                    "ErrorsReceived": 36712567,
                    "RetransCount": 71271979,
                    "MeasurementReport": ["ex laborum nostrud elit", "Excepteur"],
                    "NumberOfMeasureReports": 48959729,
                    "IPV4Address": "laborum consectetur deserunt ipsum dolore",
                    "IPV6Address": "aliqua sed dolore in occaecat",
                    "Hostname": "commodo nostrud"
                  },
                  {
                    "MACAddress": "B5:E8:fA:27:bB:7D",
                    "TimeStamp": "qui ullamco et",
                    "HTCapabilities": "ullamco ea deserunt exercitation",
                    "VHTCapabilities": "enim",
                    "HECapabilities": "commodo d",
                    "LastDataDownlinkRate": 16063231,
                    "LastDataUplinkRate": 69223186,
                    "UtilizationReceive": 10223705,
                    "UtilizationTransmit": 50266343,
                    "EstMACDataRateDownlink": 64522732,
                    "EstMACDataRateUplink": 90822128,
                    "SignalStrength": 41,
                    "LastConnectTime": 26460041,
                    "BytesSent": 21751406,
                    "BytesReceived": 91292679,
                    "PacketsSent": 78102508,
                    "PacketsReceived": 52218131,
                    "ErrorsSent": 37646789,
                    "ErrorsReceived": 34653509,
                    "RetransCount": 15871620,
                    "MeasurementReport": ["cupidatat", "irure nostrud adipisicing"],
                    "NumberOfMeasureReports": 12535877,
                    "IPV4Address": "ut",
                    "IPV6Address": "reprehenderit magna ea Ut in",
                    "Hostname": "exercitation eu anim enim ullamco"
                  },
                  {
                    "MACAddress": "02:DD:AC:fE:cd:8E",
                    "TimeStamp": "commodo est elit cupidatat aute",
                    "HTCapabilities": "in velit anim",
                    "VHTCapabilities": "eiusmod nostrud in id dolor",
                    "HECapabilities": "pari",
                    "LastDataDownlinkRate": 28165434,
                    "LastDataUplinkRate": 38361463,
                    "UtilizationReceive": 65039203,
                    "UtilizationTransmit": 77731504,
                    "EstMACDataRateDownlink": 37470420,
                    "EstMACDataRateUplink": 7040466,
                    "SignalStrength": 103,
                    "LastConnectTime": 59198613,
                    "BytesSent": 87518764,
                    "BytesReceived": 24660333,
                    "PacketsSent": 98819761,
                    "PacketsReceived": 20757277,
                    "ErrorsSent": 25398953,
                    "ErrorsReceived": 52236780,
                    "RetransCount": 91014793,
                    "MeasurementReport": ["laboris ea in Ut", "dolor", "consequat et ipsum", "volupta"],
                    "NumberOfMeasureReports": 29759859,
                    "IPV4Address": "in dolore sint et",
                    "IPV6Address": "in Lorem",
                    "Hostname": "commodo"
                  },
                  {
                    "MACAddress": "7c:0a:fA:7D:5C:92",
                    "TimeStamp": "magna Lorem",
                    "HTCapabilities": "sed sit ut",
                    "VHTCapabilities": "eiusmod minim dolor",
                    "HECapabilities": "minim dolor veniam",
                    "LastDataDownlinkRate": 72785480,
                    "LastDataUplinkRate": 9556913,
                    "UtilizationReceive": 89893415,
                    "UtilizationTransmit": 35313604,
                    "EstMACDataRateDownlink": 23419882,
                    "EstMACDataRateUplink": 34504882,
                    "SignalStrength": 40,
                    "LastConnectTime": 34018850,
                    "BytesSent": 82469613,
                    "BytesReceived": 27557156,
                    "PacketsSent": 162306,
                    "PacketsReceived": 7356219,
                    "ErrorsSent": 96651224,
                    "ErrorsReceived": 3193460,
                    "RetransCount": 96282591,
                    "MeasurementReport": [
                      "veniam",
                      "dolore sint voluptate minim",
                      "non sit elit sunt",
                      "officia Excepteur"
                    ],
                    "NumberOfMeasureReports": 20319578,
                    "IPV4Address": "ad Ut reprehenderi",
                    "IPV6Address": "mollit tempor fugiat anim",
                    "Hostname": "ad cillum quis ipsum consectetur"
                  },
                  {
                    "MACAddress": "88:4e:68:BC:CB:93",
                    "TimeStamp": "ea qu",
                    "HTCapabilities": "in",
                    "VHTCapabilities": "commodo dolor",
                    "HECapabilities": "dolor aliquip aliqua",
                    "LastDataDownlinkRate": 53273459,
                    "LastDataUplinkRate": 13172013,
                    "UtilizationReceive": 13303022,
                    "UtilizationTransmit": 73253776,
                    "EstMACDataRateDownlink": 95338298,
                    "EstMACDataRateUplink": 47779360,
                    "SignalStrength": 172,
                    "LastConnectTime": 24610110,
                    "BytesSent": 14913590,
                    "BytesReceived": 25152957,
                    "PacketsSent": 26485074,
                    "PacketsReceived": 95385297,
                    "ErrorsSent": 19465860,
                    "ErrorsReceived": 55766250,
                    "RetransCount": 78751265,
                    "MeasurementReport": [
                      "aute ea",
                      "Ut",
                      "irure consequat amet deserunt",
                      "culpa proident officia sint"
                    ],
                    "NumberOfMeasureReports": 20796396,
                    "IPV4Address": "ex deserunt",
                    "IPV6Address": "commodo esse irure ut",
                    "Hostname": "ipsum sit"
                  }
                ],
                "NumberOfSTA": 43382,
                "EstServiceParametersBE": "ipsum fugiat consectetur id co",
                "EstServiceParametersBK": "cillum nostrud Lorem",
                "EstServiceParametersVI": "dolor Ut magna veniam",
                "EstServiceParametersVO": "officia dolor incididunt enim"
              }
            ],
            "Capabilities": {
              "description": "Describes the Wi-Fi capabilities of the radio.",
              "ref": "#/definitions/DataElements:Capabilities_t"
            },
            "BackhaulSta": {
              "description": "Contains the MAC address of the STA on this radio providing Wi-Fi backhaul to this device",
              "ref": "#/definitions/DataElements:BackhaulSTA_t"
            },
            "ScanResultList": {
              "description": "The results of the latest scan for neighboring BSS by the radio.",
              "ref": "#/definitions/DataElements:ScanResult_t"
            },
            "UnassociatedStaList": [
              { "MACAddress": "F0:ce:95:ec:CD:c1", "SignalStrength": 39 },
              { "MACAddress": "Dc:2b:02:AA:F3:40", "SignalStrength": 203 },
              { "MACAddress": "fD:BB:3e:0B:C4:89", "SignalStrength": 144 },
              { "MACAddress": "BD:80:4C:0C:8b:Db", "SignalStrength": 110 },
              { "MACAddress": "9A:D1:04:F5:66:7b", "SignalStrength": 0 }
            ],
            "NumberOfUnassocSta": 25916
          }
        ]
      }
    ]
  }
}
```

## refresh

### refresh

Update the self/neighbor device dataelement

`refresh`

- type: `Method`
