/*
 * decollector_i.h
 * Collector private header file.
 *
 * Copyright (C) 2020-2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * See LICENSE file for license related information.
 */

#ifndef DECOLLECTOR_I_H
#define DECOLLECTOR_I_H

#include "timer.h"
#include <stdint.h>

enum {
	OPTIONAL,
	MANDATORY,
	CONDITIONAL,
};

struct getter_txn {
	uint16_t request;	/* (request)ed cmdu */
	uint16_t expect;	/* (expect)ed cmdu */
	uint8_t cnt;		/* num of (expect)ed cmdus received in a collection epoch */
	time_t tsp;		/* time when latest (expect)ed cmdu received */
	uint8_t applicability;	/* Optional, Mandatory or Conditional */
};

enum getter_state {
	GT_IDLE = 0,
	GT_RUNNING,
	GT_DONE,
};

extern struct getter_txn txnlist[];
#define NUM_TXN		12

struct getter_context {
	time_t start;
	time_t end;
	atimer_t t;
	uint32_t tmo;
	int retry;
	uint8_t state;
	int txni;
	struct getter_txn txn[NUM_TXN];
	uint32_t rxcnt[NUM_TXN];	/* total received (expect)ed cmdus */
	uint32_t error[NUM_TXN];	/* total errors in (expect)ed cmdus */
	uint16_t request;
	uint16_t expect;
	uint16_t last_sent_mid;
	void *collector;
	void *agent;
	uint32_t rbitmap;
};

const char *applicability_type2str(uint8_t t);

int getter_next_request(struct getter_context *gt);
void getter_clear_expect(struct getter_context *gt, uint16_t cmdutype);
bool getter_expect_pending_any(struct getter_context *gt);
bool getter_expect_pending(struct getter_context *gt, uint16_t cmdutype);
void getter_update_error(struct getter_context *gt, uint16_t cmdutype);
void getter_set_applicability(struct getter_context *gt, uint16_t cmdutype, uint8_t typ);

#endif	/* DECOLLECTOR_I_H */
