# Test Specification

Most of the functionality in `decollector` can be tested via its ubus APIs. Each API can be broken down into an individual test case to show full coverage is achieved.

# Sections

- [Prerequisites](#prerequisites)
- [Test Suites](#Test Suites)
- [Functional API Tests](#Functional API Tests)
- [Unit Tests](#Unit Tests)
- [Functional Tests](#Functional Tests)

## Prerequisites

The prerequisites for the `decollector` test suites are ubusd and ieee1905d.

| Dependency   | Link                                      | License  |
| ------------ | ----------------------------------------- | -------- |
| ubusd        | https://git.openwrt.org/project/ubus.git  | LGPL 2.1 |
| ieee1905     | https://dev.iopsys.eu/iopsys/ieee1905     | LGPL 2.0 |

## Test Suites

The `decollector` build pipeline has three test suites - functional-api, unit-test and functional-test suite.

### Functional API Tests

The functional API tests consists of two individual test suites, one per UBUS object under test. The functional API tests use the Ubus-API-validation
command-line interface tool to invoke a method, programmatically through
libubus, and validates it against the objects json-schema.

#### wifi.dataelements

| Execution ID | Method  | Description | Function ID                              |
| ------------ | ------- | ----------- | ---------------------------------------- |
| 1            | dump    | No Argument | [3](./functionspec.md#dump)    |
| 2            | refresh | No Argument | [4](./functionspec.md#refresh) |

### Unit Tests

The `decollector` unit tests are written in cmocka, invoking the ubus callbacks
directly from the source code, which is compiled into a shared library.
This means mocking the arguments of a cli or libubus invoke in a
`struct blob_attr *`. The results of the call will be logged to the logfile at
`/tmp/test.log`.

| Execution ID | Method  | Test Case Name                                       | Function ID Coverage           |
| ------------ | ------- | ---------------------------------------------------- | ------------------------------ |
| 1            | dump    | [test_api_decollector_dump](#test_api_decollector_dump)      | [1](./functionspec.md#dump)    |
| 2            | refresh | [test_api_decollector_refresh](test_api_decollector_refresh) | [2](./functionspec.md#refresh) |

#### test_api_decollector_dump

##### Description

Test the `decollector's` (wifi.dataelements object) ubus API `dump`, publishing the method [dump](./functionspec.md#dump).

##### Test Steps

Issuing a dump to a client from the decolletcor test platform.

Read the logfile and verify that the `dump` argument was accurately logged.

##### Test Expected Results

```
{
	"date": "Mon Sep 21 09:44:22 2020",
	"version": "",
	"description": "WFA Data Elements",
	"TimeStamp": "2020-08-21T09:44:22+00:00",
	"name": "wifi",
	"data": [
		{
			"wfa-dataelements:Network": {
				"ID": "",
				"NumberOfDevices": 1,
				"ControllerID": "00:00:00:00:00:00",
				"TimeStamp": "",
				"DeviceList": [
					{
						"ID": "00:00:00:00:00:00",
						"NumberOfRadios": 2,
						"CollectionInterval": 0,
						"RadioList": [
							{
								"ID": "00:00:00:00:00:00",
								"Noise": -92,
								"NumberOfBSS": 1,
								"Enabled": false,
								"NumberOfCurrOpClass": 1,
								"NumberOfUnassocSta": 0,
								"Utilization": 0,
								"Transmit": 0,
								"ReceiveSelf": 0,
								"RecieveOther": 0,
								"BSSList": [
									{
										"BSSID": "00:11:22:33:44:55",
										"SSID": "Test SSID 2Ghz",
										"TimeStamp": "2020-08-21T09:44:02+00:00",
										"Enabled": false,
										"LastChange": 0,
										"NumberofSTA": 1,
										"EstServiceParametersBE": "AAAA\n",
										"EstServiceParametersBK": "AAAA\n",
										"EstServiceParameterVO": "AAAA\n",
										"EstServieParameterVI": "AAAA\n",
										"UnicastBytesReceived": 950000,
										"UnicastBytesSent": 850000,
										"MulticastBytesReceived": 20000,
										"MulticastBytesSent": 200000,
										"BroadcastBytesReceived": 20000,
										"BroadcastBytesSent": 200000,
										"STAList": [
											{
												"MACAddress": "20:80:70:60:50:40",
												"TimeStamp": "2020-08-21T09:44:02+00:00",
												"SignalStrength": -45,
												"HTCapabilities": "\/w==\n",
												"VHTCapabilities": "AAAAAAAA\n",
												"EstMACDataRateDownlink": 0,
												"EstMACDataRateUplink": 0,
												"LastDataUplinkRate": 300,
												"UtilizationTransmit": 2,
												"UtilizationReceive": 0,
												"LastConnectTime": 600,
												"Hostname": "",
												"BytesSent": 3912221,
												"BytesReceived": 36176593,
												"PacketsSent": 23241,
												"PacketsReceived": 40204,
												"ErrorsSent": 0,
												"ErrorsReceived": 0,
												"NumberOfMeasureReports": 0,
												"Measurementreport": [
													
												]
											}
										]
									}
								],
								"Capabilities": {
									"NumberOfOpClass": 3,
									"OperatingClasses": [
										{
											"Class": 81,
											"MaxTxPower": 20,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 83,
											"MaxTxPower": 20,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 84,
											"MaxTxPower": 20,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										}
									],
									"HTCapabilities": "Dg==\n",
									"VHTCapabilities": "AA==\n"
								},
								"CurrentOperatingClasses": [
									{
										"TimeStamp": "2020-08-21T09:44:02+00:00",
										"Channel": 1,
										"Class": 4,
										"TxPower": 30
									}
								],
								"ScanResultList": [
									{
										"TimeStamp": "2020-08-21T09:44:02+00:00",
										"NumberOfOpClassScans": 3,
										"OpClassScanList": [
											{
												"OperatingClass": 81,
												"NumberOfChannelScans": 13,
												"ChannelScanList": [
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 1,
														"NumberofNeighbors": 1,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															{
																"StationCount": 3,
																"ChannelUtilization": 33,
																"BSSID": "20:11:12:13:14:15",
																"SSID": "Scan2.1",
																"SignalStrengh": -40,
																"ChannelBandwidth": 0
															}
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 2,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 3,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 4,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 5,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 6,
														"NumberofNeighbors": 1,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															{
																"StationCount": 1,
																"ChannelUtilization": 5,
																"BSSID": "20:21:22:23:24:25",
																"SSID": "Scan2.2",
																"SignalStrengh": -45,
																"ChannelBandwidth": 0
															}
														]
													},
													{
														"TimeStamp": "",
														"Channel": 0,
														"NumberofNeighbors": 0,
														"Noise": 0,
														"Utilization": 0,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "",
														"Channel": 0,
														"NumberofNeighbors": 0,
														"Noise": 0,
														"Utilization": 0,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "",
														"Channel": 0,
														"NumberofNeighbors": 0,
														"Noise": 0,
														"Utilization": 0,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "",
														"Channel": 0,
														"NumberofNeighbors": 0,
														"Noise": 0,
														"Utilization": 0,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "",
														"Channel": 0,
														"NumberofNeighbors": 0,
														"Noise": 0,
														"Utilization": 0,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "",
														"Channel": 0,
														"NumberofNeighbors": 0,
														"Noise": 0,
														"Utilization": 0,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "",
														"Channel": 0,
														"NumberofNeighbors": 0,
														"Noise": 0,
														"Utilization": 0,
														"NeighborList": [
															
														]
													}
												]
											},
											{
												"OperatingClass": 83,
												"NumberOfChannelScans": 0,
												"ChannelScanList": [
													
												]
											},
											{
												"OperatingClass": 84,
												"NumberOfChannelScans": 0,
												"ChannelScanList": [
													
												]
											}
										]
									}
								],
								"UnassociatedStaList": [
									
								],
								"BackhaulSta": {
									"MACAddress": "00:00:00:00:00:00"
								}
							},
							{
								"ID": "00:00:00:00:00:00",
								"Noise": -88,
								"NumberOfBSS": 1,
								"Enabled": false,
								"NumberOfCurrOpClass": 1,
								"NumberOfUnassocSta": 0,
								"Utilization": 0,
								"Transmit": 0,
								"ReceiveSelf": 0,
								"RecieveOther": 0,
								"BSSList": [
									{
										"BSSID": "aa:bb:cc:dd:ee:ff",
										"SSID": "Test SSID 5Ghz",
										"TimeStamp": "2020-08-21T09:44:02+00:00",
										"Enabled": false,
										"LastChange": 0,
										"NumberofSTA": 2,
										"EstServiceParametersBE": "AAAA\n",
										"EstServiceParametersBK": "AAAA\n",
										"EstServiceParameterVO": "AAAA\n",
										"EstServieParameterVI": "AAAA\n",
										"UnicastBytesReceived": 990000,
										"UnicastBytesSent": 800000,
										"MulticastBytesReceived": 10000,
										"MulticastBytesSent": 100000,
										"BroadcastBytesReceived": 10000,
										"BroadcastBytesSent": 100000,
										"STAList": [
											{
												"MACAddress": "50:80:70:60:50:40",
												"TimeStamp": "2020-08-21T09:44:02+00:00",
												"SignalStrength": -40,
												"HTCapabilities": "\/w==\n",
												"VHTCapabilities": "\/\/\/\/\/wAA\n",
												"EstMACDataRateDownlink": 555,
												"EstMACDataRateUplink": 500,
												"LastDataUplinkRate": 1300,
												"UtilizationTransmit": 58,
												"UtilizationReceive": 40,
												"LastConnectTime": 300,
												"Hostname": "",
												"BytesSent": 197716844,
												"BytesReceived": 198917288,
												"PacketsSent": 251851,
												"PacketsReceived": 137122,
												"ErrorsSent": 0,
												"ErrorsReceived": 0,
												"NumberOfMeasureReports": 0,
												"Measurementreport": [
													
												]
											},
											{
												"MACAddress": "50:31:32:33:34:35",
												"TimeStamp": "2020-08-21T09:44:02+00:00",
												"SignalStrength": -53,
												"HTCapabilities": "\/w==\n",
												"VHTCapabilities": "AAAAAAAA\n",
												"EstMACDataRateDownlink": 5,
												"EstMACDataRateUplink": 20,
												"LastDataUplinkRate": 300,
												"UtilizationTransmit": 8,
												"UtilizationReceive": 3,
												"LastConnectTime": 60,
												"Hostname": "",
												"BytesSent": 10789790,
												"BytesReceived": 22229360,
												"PacketsSent": 11311,
												"PacketsReceived": 26147,
												"ErrorsSent": 0,
												"ErrorsReceived": 0,
												"NumberOfMeasureReports": 0,
												"Measurementreport": [
													
												]
											}
										]
									}
								],
								"Capabilities": {
									"NumberOfOpClass": 13,
									"OperatingClasses": [
										{
											"Class": 115,
											"MaxTxPower": 23,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 118,
											"MaxTxPower": 23,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 121,
											"MaxTxPower": 30,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 116,
											"MaxTxPower": 23,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 119,
											"MaxTxPower": 23,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 122,
											"MaxTxPower": 30,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 117,
											"MaxTxPower": 23,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 120,
											"MaxTxPower": 23,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 123,
											"MaxTxPower": 30,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 125,
											"MaxTxPower": 30,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 128,
											"MaxTxPower": 30,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 129,
											"MaxTxPower": 23,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										},
										{
											"Class": 130,
											"MaxTxPower": 23,
											"NumberOfNonOperChan": 0,
											"NonOperable": [
												
											]
										}
									],
									"HTCapabilities": "Dg==\n",
									"VHTCapabilities": "AA==\n"
								},
								"CurrentOperatingClasses": [
									{
										"TimeStamp": "2020-08-21T09:44:02+00:00",
										"Channel": 100,
										"Class": 128,
										"TxPower": 30
									}
								],
								"ScanResultList": [
									{
										"TimeStamp": "2020-08-21T09:44:02+00:00",
										"NumberOfOpClassScans": 13,
										"OpClassScanList": [
											{
												"OperatingClass": 115,
												"NumberOfChannelScans": 4,
												"ChannelScanList": [
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 36,
														"NumberofNeighbors": 3,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															{
																"StationCount": 1,
																"ChannelUtilization": 0,
																"BSSID": "00:11:12:13:14:15",
																"SSID": "Scan5.1",
																"SignalStrengh": -50,
																"ChannelBandwidth": 2
															},
															{
																"StationCount": 2,
																"ChannelUtilization": 0,
																"BSSID": "00:51:52:53:54:55",
																"SSID": "Scan5.a-only",
																"SignalStrengh": -55,
																"ChannelBandwidth": 0
															},
															{
																"StationCount": 0,
																"ChannelUtilization": 0,
																"BSSID": "00:61:62:63:64:65",
																"SSID": "Scan5.an-only",
																"SignalStrengh": -51,
																"ChannelBandwidth": 1
															}
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 40,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 44,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 48,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													}
												]
											},
											{
												"OperatingClass": 118,
												"NumberOfChannelScans": 4,
												"ChannelScanList": [
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 52,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 56,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 60,
														"NumberofNeighbors": 2,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															{
																"StationCount": 2,
																"ChannelUtilization": 0,
																"BSSID": "00:21:22:23:24:25",
																"SSID": "Scan5.2",
																"SignalStrengh": -55,
																"ChannelBandwidth": 2
															},
															{
																"StationCount": 10,
																"ChannelUtilization": 0,
																"BSSID": "00:41:42:43:44:45",
																"SSID": "Scan5.4",
																"SignalStrengh": -61,
																"ChannelBandwidth": 2
															}
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 64,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													}
												]
											},
											{
												"OperatingClass": 121,
												"NumberOfChannelScans": 11,
												"ChannelScanList": [
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 100,
														"NumberofNeighbors": 1,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															{
																"StationCount": 3,
																"ChannelUtilization": 0,
																"BSSID": "00:31:32:33:34:35",
																"SSID": "Scan5.3",
																"SignalStrengh": -66,
																"ChannelBandwidth": 1
															}
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 104,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 108,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 112,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 116,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 120,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 124,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 128,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 132,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 136,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 140,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													}
												]
											},
											{
												"OperatingClass": 116,
												"NumberOfChannelScans": 0,
												"ChannelScanList": [
													
												]
											},
											{
												"OperatingClass": 119,
												"NumberOfChannelScans": 0,
												"ChannelScanList": [
													
												]
											},
											{
												"OperatingClass": 122,
												"NumberOfChannelScans": 0,
												"ChannelScanList": [
													
												]
											},
											{
												"OperatingClass": 117,
												"NumberOfChannelScans": 0,
												"ChannelScanList": [
													
												]
											},
											{
												"OperatingClass": 120,
												"NumberOfChannelScans": 0,
												"ChannelScanList": [
													
												]
											},
											{
												"OperatingClass": 123,
												"NumberOfChannelScans": 0,
												"ChannelScanList": [
													
												]
											},
											{
												"OperatingClass": 125,
												"NumberOfChannelScans": 6,
												"ChannelScanList": [
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 149,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 153,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 157,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 161,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 165,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													},
													{
														"TimeStamp": "2020-08-21T09:44:02+00:00",
														"Channel": 169,
														"NumberofNeighbors": 0,
														"Noise": 100,
														"Utilization": 50,
														"NeighborList": [
															
														]
													}
												]
											},
											{
												"OperatingClass": 128,
												"NumberOfChannelScans": 0,
												"ChannelScanList": [
													
												]
											},
											{
												"OperatingClass": 129,
												"NumberOfChannelScans": 0,
												"ChannelScanList": [
													
												]
											},
											{
												"OperatingClass": 130,
												"NumberOfChannelScans": 0,
												"ChannelScanList": [
													
												]
											}
										]
									}
								],
								"UnassociatedStaList": [
									
								],
								"BackhaulSta": {
									"MACAddress": "00:00:00:00:00:00"
								}
							}
						]
					}
				]
			}
		}
	]
}
```

#### test_api_wfadata_refresh

##### Description

Tests the `decollector's` (wifi.dataelements object) ubus API `refresh`.

##### Test Steps

Issuing a refresh to a client from the decollector test platform.

##### Test Expected Results

Start collecting the data elements.
