/*
 * timer.c
 * Timer wrapper functions around uloop_timeout
 *
 * Copyright (C) 2020 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: anjan.chanda@iopsys.eu
 *
 * See LICENSE file for license related information.
 *
 */
#include "timer.h"

#include <libubox/uloop.h>

void timer_init(atimer_t *t, void (*function)(atimer_t *))
{
	struct uloop_timeout *ut = (struct uloop_timeout *)t;

	ut->cb = (uloop_timeout_handler)function;
}

int timer_set(atimer_t *t, uint32_t tmo_ms)
{
	struct uloop_timeout *ut = (struct uloop_timeout *)t;

	return uloop_timeout_set(ut, tmo_ms);
}

int timer_del(atimer_t *t)
{
	struct uloop_timeout *ut = (struct uloop_timeout *)t;

	return uloop_timeout_cancel(ut);
}

int timer_pending(atimer_t *t)
{
	struct uloop_timeout *ut = (struct uloop_timeout *)t;

	return ut->pending == true ? 1 : 0;
}

