#!/bin/bash

echo "preparation script"
pwd

export LIB_DIR=${PWD}

echo "Cleaning..."
make clean
make -C test/cmocka clean

echo "Creating Library"
make wfa_delm_test

supervisorctl status all
supervisorctl update
supervisorctl restart ubusd ieee1905d wifimngr topologyd
sleep 2
supervisorctl status all

echo "Running the unit test cases, pwd ${LIB_DIR}"
make -C src unit-test
ret=$?

supervisorctl stop ubusd ieee1905d wifimngr topologyd
supervisorctl status all

#report part
#GitLab-CI output
gcovr -r .
# Artefact
gcovr -r . --xml -o ./unit-test-coverage.xml
date +%s > timestamp.log

echo "$0 Return status ${ret}"
exit ${ret}
