#!/bin/bash

echo "$0 preparation script"
pwd
make clean

make coverage -C ./

supervisorctl status all
supervisorctl update
supervisorctl restart ubusd wifimngr ieee1905d
sleep 3
supervisorctl restart decollector
sleep 3
supervisorctl status all

ubus list

# run API validation
ubus-api-validator -d ./test/api/json/ > ./api-result.log
sleep 3

supervisorctl stop decollector
supervisorctl stop ieee1905d wifimngr ubusd


#report part
gcovr -r . --xml -o ./api-test-coverage.xml
gcovr -r .
cp ./memory-report.xml ./api-test-memory-report.xml
tap-junit --input ./api-result.log --output report
date +%s > timestamp.log

echo "$0 exit status ${ret}"
exit ${ret}
