/*
 * debug.h - debug and logging header file
 *
 * Copyright (C) 2020 IOPSYS Software Solutions AB. All rights reserved.
 *
 */

#ifndef DEBUG_H
#define DEBUG_H

void start_logging(void *opts);
void stop_logging(void);
void log_message(int level, const char *fmt, ...)
#ifdef __GNUC__
	__attribute__((__format__(__printf__, 2, 3)));
#endif

#define err(...)	log_message(0, __VA_ARGS__)
#define warn(...)	log_message(1, __VA_ARGS__)
#define info(...)	log_message(2, __VA_ARGS__)
#define dbg(...)	log_message(3, __VA_ARGS__)

#endif /* DEBUG_H */
