# Function Specification

The scope of 'decollector' is to collect and show the EasyMesh network Device.WiFI.DataElements TR-181 DM tree over UBUS.

```
root@iopsys:~# ubus -v list wifi.dataelements
'wifi.dataelements' @35c11317
	"dump":{}
	"refresh":{}
	"status":{}
root@iopsys:~#
```

# Contents

- [wifi.dataelements](#wifi.dataelements)

## APIs

Decollector provides the UBUS object `wifi.dataelements`, which represents the Device.WiFi.DataElements TR-181 tree.

### wifi.dataelements

```
root@iopsys:~# ubus -v list wifi.dataelements
'wifi.dataelements' @ecab1485
	"dump":{}
	"refresh":{}
	"status":{}
```

| Method                        | Function ID |
| ----------------------------- | ----------- |
| [dump](#dump_collector)       | 1           |
| [refresh](#refresh_collector) | 2           |

#### Methods

Method description of the `wifi.dataelements` object.

##### dump_collector

Dumps the EasyMesh Multi-AP nodes in the network as per the TR-181 Device.WiFi.DataElements tree.

- [dump documentation](./api/wfadata.md#dump)

##### refresh_collector

(Re)start collecting EasyMesh messages to construct the Device.WiFi.DataElments tree.

- [refresh documentation](./api/wfadata.md#refresh)
