#ifndef BACKHAUL_TOPOLOGY_DBG_H
#define BACKHAUL_TOPOLOGY_DBG_H

#include <stdint.h>

struct list_head;
struct bh_topology_dev;
struct local_iface;
struct backhaul_info;

enum dbg_bh_topo_indent_lvl {
	INDENT_LVL_0 = 0,
	INDENT_LVL_1 = 1,
	INDENT_LVL_2 = 2,
	INDENT_LVL_3 = 3,
};

void dbg_dump_bh_topo_backhaul_info(const struct backhaul_info *bh_info,
				    enum dbg_bh_topo_indent_lvl indent_lvl);

void dbg_dump_bh_topo_local_iface(const struct local_iface *local_iface,
				  enum dbg_bh_topo_indent_lvl indent_lvl);

void dbg_dump_bh_topo_dev(const struct bh_topology_dev *bh_topo_dev,
			  enum dbg_bh_topo_indent_lvl indent_lvl);

void dbg_dump_bh_topo_devs(const struct list_head *bh_topo_dev_list,
			   enum dbg_bh_topo_indent_lvl indent_lvl);

void dbg_dump_bh_topo_link(const struct bh_topology_dev *bh_topo_dev,
			   enum dbg_bh_topo_indent_lvl indent_lvl);

#endif
