# Wi-Fi Data Elements Collector

The `decollector` process is responsible for gathering WiFi Data Elements and
helps in building the TR-181 Device.WiFi.DataElements tree.

It builds the WiFi DataElements tree by a) sniffing the EasyMesh Multi-AP CMDUs from EasyMesh Agents in the network, and b) interfacing with the EasyMesh Controller of the network.
Since, `decollector` runs within the Device and outputs data over the local bus (f.e. UBUS), it can be called a DE-Collector 'Proxy'.

`decollector` provides `wifi.dataelements` object over UBUS.

## decollector command line options

decollector can be started with the following command line options -
| options           | Meaning                                    |
|-------------------|--------------------------------------------|
| -h                | usage                                      |
| -D                | run in the background as a daemon          |
| -s <socket path>  | UBUS socket path                           |
| -t <seconds>      | periodic collection interval in seconds    |
| -d                | debug mode; more 'd's more verbose         |
| -p <pidfile>      | pid file path                              |
| -l                | log to syslog                              |

## UBUS API

`decollector` provides the following methods over UBUS via **wifi.dataelements** object -

```
root@iopsys:/tmp# ubus -v list wifi.dataelements
'wifi.dataelements' @4db2666e
        "dump":{}
        "refresh":{}
        "event":{}
        "status":{}
```

`decollector`'s 'dump' UBUS methods shows WiFi DataElements of all EasyMesh nodes in the network.
An example 'dump' output for two EasyMesh devices is given below -

```
root@iopsys:~# ubus call wifi.dataelements dump
{
        "date": "Mon Apr  8 16:54:45 2024",
        "version": "2.0",
        "description": "WFA Data Elements",
        "TimeStamp": "2024-04-08T16:54:45+01:00",
        "name": "wifi",
        "data": [
                {
                        "wfa-dataelements:Network": {
                                "ID": "",
                                "TimeStamp": "2024-04-08T16:54:45+01:00",
                                "ControllerID": "ae:91:9b:b7:03:e8",
                                "DeviceNumberOfEntries": 2,
                                "MSCSDisallowedStaList": "",
                                "SCSDisallowedStaList": "",
                                "SSIDNumberOfEntries": 6,
                                "SSID": [
                                        {
                                                "Enabled": true,
                                                "SSID": "IOPSYS-AC919BB703E8",
                                                "Band": "2",
                                                "HaulType": "Fronthaul"
                                        },
                                        {
                                                "Enabled": true,
                                                "SSID": "IOPSYS-AC919BB703E8",
                                                "Band": "5",
                                                "HaulType": "Fronthaul"
                                        },
                                        {
                                                "Enabled": true,
                                                "SSID": "IOPSYS-AC919BB703E8",
                                                "Band": "6",
                                                "HaulType": "Fronthaul"
                                        },
                                        {
                                                "Enabled": true,
                                                "SSID": "MAP-AC919BB703E8-BH",
                                                "Band": "2",
                                                "HaulType": "Backhaul"
                                        },
                                        {
                                                "Enabled": true,
                                                "SSID": "MAP-AC919BB703E8-BH",
                                                "Band": "5",
                                                "HaulType": "Backhaul"
                                        },
                                        {
                                                "Enabled": true,
                                                "SSID": "MAP-AC919BB703E8-BH",
                                                "Band": "6",
                                                "HaulType": "Backhaul"
                                        }
                                ],
                                "MultiAPSteeringSummaryStats": {
                                        "NoCandidateAPFailures": 0,
                                        "BlacklistAttempts": 0,
                                        "BlacklistSuccesses": 0,
                                        "BlacklistFailures": 0,
                                        "BTMAttempts": 0,
                                        "BTMSuccesses": 0,
                                        "BTMFailures": 0,
                                        "BTMQueryResponses": 0
                                },
                                "DeviceList": [
                                        {
                                                "ID": "ae:91:9b:b7:03:e8",
                                                "MultiAPCapabilities": "oA==",
                                                "CollectionInterval": 60,
                                                "ReportUnsuccessfulAssociations": false,
                                                "MaxReportingRate": 0,
                                                "APMetricsReportingInterval": 0,
                                                "Manufacturer": "IOPSYS",
                                                "SerialNumber": "+119746+2329000004",
                                                "ManufacturerModel": "TODO",
                                                "SoftwareVersion": "7.4.0alpha3_dev-15-g35b93e4bd3",
                                                "ExecutionEnv": "",
                                                "DSCPMap": "TODO",
                                                "MaxPrioritizationRules": 0,
                                                "PrioritizationSupport": false,
                                                "MaxVIDs": 255,
                                                "APMetricsWiFi6": "TODO bool",
                                                "CountryCode": "DE",
                                                "LocalSteeringDisallowedSTAList": [

                                                ],
                                                "BTMSteeringDisalloywedSTAList": [

                                                ],
                                                "DFSEnable": true,
                                                "ReportIndependentScans": false,
                                                "STASteeringState": false,
                                                "CoordinatedCACAllowed": false,
                                                "TrafficSeparationAllowed": false,
                                                "ServicePrioritizationAllowed": "TODO bool",
                                                "RadioNumberOfEntries": 3,
                                                "Default8021QNumberOfEntries": 1,
                                                "SSIDtoVIDMappingNumberOfEntries": 6,
                                                "CACStatusNumberOfEntries": 3,
                                                "IEEE1905SecurityNumberOfEntries": 1,
                                                "SPRuleNumberOfEntries": 0,
                                                "AnticipatedChannelsNumberOfEntries": 0,
                                                "AnticipatedChannelUsageNumberOfEntries": 0,
                                                "Default8021Q": [
                                                        {
                                                                "Enable": true,
                                                                "PrimaryVID": 1,
                                                                "DefaultPCP": 0
                                                        }
                                                ],
                                                "SSIDtoVIDMapping": [
                                                        {
                                                                "SSID": "IOPSYS-AC919BB703E8",
                                                                "VID": 1
                                                        },
                                                        {
                                                                "SSID": "IOPSYS-AC919BB703E8",
                                                                "VID": 1
                                                        },
                                                        {
                                                                "SSID": "IOPSYS-AC919BB703E8",
                                                                "VID": 1
                                                        },
                                                        {
                                                                "SSID": "MAP-AC919BB703E8-BH",
                                                                "VID": 1
                                                        },
                                                        {
                                                                "SSID": "MAP-AC919BB703E8-BH",
                                                                "VID": 1
                                                        },
                                                        {
                                                                "SSID": "MAP-AC919BB703E8-BH",
                                                                "VID": 1
                                                        }
                                                ],
                                                "CACStatus": [
                                                        {
                                                                "TimeStamp": "2024-04-08T16:54:11+01:00",
                                                                "CACAvailableChannelNumberOfEntries": 130,
                                                                "CACNonOccupancyChannelNumberOfEntries": 0,
                                                                "CACActiveChannelNumberOfEntries": 0,
                                                                "CACAvailableChannel": [
                                                                        {
                                                                                "OpClass": 137,
                                                                                "Channel": 63,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 137,
                                                                                "Channel": 31,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 134,
                                                                                "Channel": 79,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 134,
                                                                                "Channel": 47,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 134,
                                                                                "Channel": 15,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 87,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 71,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 55,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 39,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 23,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 7,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 91,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 83,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 75,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 67,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 59,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 51,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 43,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 35,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 27,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 19,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 11,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 3,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 93,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 89,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 85,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 81,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 77,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 73,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 69,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 65,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 61,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 57,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 53,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 49,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 45,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 41,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 37,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 33,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 29,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 25,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 21,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 17,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 13,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 9,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 5,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 1,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 129,
                                                                                "Channel": 114,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 129,
                                                                                "Channel": 50,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 155,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 122,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 106,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 58,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 42,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 127,
                                                                                "Channel": 161,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 127,
                                                                                "Channel": 153,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 126,
                                                                                "Channel": 157,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 126,
                                                                                "Channel": 149,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 125,
                                                                                "Channel": 161,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 125,
                                                                                "Channel": 157,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 125,
                                                                                "Channel": 153,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 125,
                                                                                "Channel": 149,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 124,
                                                                                "Channel": 161,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 124,
                                                                                "Channel": 157,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 124,
                                                                                "Channel": 153,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 124,
                                                                                "Channel": 149,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 123,
                                                                                "Channel": 128,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 123,
                                                                                "Channel": 120,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 123,
                                                                                "Channel": 112,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 123,
                                                                                "Channel": 104,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 122,
                                                                                "Channel": 124,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 122,
                                                                                "Channel": 116,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 122,
                                                                                "Channel": 108,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 122,
                                                                                "Channel": 100,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 144,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 128,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 124,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 120,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 116,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 112,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 108,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 104,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 100,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 120,
                                                                                "Channel": 64,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 120,
                                                                                "Channel": 56,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 119,
                                                                                "Channel": 60,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 119,
                                                                                "Channel": 52,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 118,
                                                                                "Channel": 64,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 118,
                                                                                "Channel": 60,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 118,
                                                                                "Channel": 56,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 118,
                                                                                "Channel": 52,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 117,
                                                                                "Channel": 48,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 117,
                                                                                "Channel": 40,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 116,
                                                                                "Channel": 44,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 116,
                                                                                "Channel": 36,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 115,
                                                                                "Channel": 48,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 115,
                                                                                "Channel": 44,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 115,
                                                                                "Channel": 40,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 115,
                                                                                "Channel": 36,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 13,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 12,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 11,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 10,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 9,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 8,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 7,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 6,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 5,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 9,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 8,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 7,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 6,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 5,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 4,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 3,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 2,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 1,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 13,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 12,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 11,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 10,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 9,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 8,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 7,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 6,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 5,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 4,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 3,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 2,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 1,
                                                                                "Minutes": 0
                                                                        }
                                                                ],
                                                                "CACNonOccupancyChannel": [

                                                                ],
                                                                "CACActiveChannel": [

                                                                ]
                                                        },
                                                        {
                                                                "TimeStamp": "2024-04-08T16:51:32+01:00",
                                                                "CACAvailableChannelNumberOfEntries": 130,
                                                                "CACNonOccupancyChannelNumberOfEntries": 0,
                                                                "CACActiveChannelNumberOfEntries": 0,
                                                                "CACAvailableChannel": [
                                                                        {
                                                                                "OpClass": 137,
                                                                                "Channel": 63,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 137,
                                                                                "Channel": 31,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 134,
                                                                                "Channel": 79,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 134,
                                                                                "Channel": 47,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 134,
                                                                                "Channel": 15,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 87,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 71,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 55,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 39,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 23,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 7,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 91,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 83,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 75,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 67,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 59,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 51,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 43,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 35,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 27,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 19,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 11,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 3,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 93,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 89,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 85,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 81,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 77,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 73,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 69,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 65,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 61,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 57,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 53,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 49,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 45,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 41,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 37,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 33,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 29,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 25,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 21,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 17,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 13,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 9,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 5,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 1,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 129,
                                                                                "Channel": 114,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 129,
                                                                                "Channel": 50,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 155,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 122,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 106,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 58,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 42,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 127,
                                                                                "Channel": 161,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 127,
                                                                                "Channel": 153,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 126,
                                                                                "Channel": 157,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 126,
                                                                                "Channel": 149,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 125,
                                                                                "Channel": 161,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 125,
                                                                                "Channel": 157,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 125,
                                                                                "Channel": 153,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 125,
                                                                                "Channel": 149,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 124,
                                                                                "Channel": 161,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 124,
                                                                                "Channel": 157,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 124,
                                                                                "Channel": 153,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 124,
                                                                                "Channel": 149,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 123,
                                                                                "Channel": 128,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 123,
                                                                                "Channel": 120,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 123,
                                                                                "Channel": 112,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 123,
                                                                                "Channel": 104,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 122,
                                                                                "Channel": 124,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 122,
                                                                                "Channel": 116,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 122,
                                                                                "Channel": 108,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 122,
                                                                                "Channel": 100,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 144,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 128,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 124,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 120,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 116,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 112,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 108,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 104,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 100,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 120,
                                                                                "Channel": 64,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 120,
                                                                                "Channel": 56,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 119,
                                                                                "Channel": 60,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 119,
                                                                                "Channel": 52,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 118,
                                                                                "Channel": 64,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 118,
                                                                                "Channel": 60,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 118,
                                                                                "Channel": 56,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 118,
                                                                                "Channel": 52,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 117,
                                                                                "Channel": 48,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 117,
                                                                                "Channel": 40,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 116,
                                                                                "Channel": 44,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 116,
                                                                                "Channel": 36,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 115,
                                                                                "Channel": 48,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 115,
                                                                                "Channel": 44,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 115,
                                                                                "Channel": 40,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 115,
                                                                                "Channel": 36,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 13,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 12,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 11,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 10,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 9,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 8,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 7,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 6,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 5,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 9,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 8,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 7,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 6,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 5,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 4,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 3,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 2,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 1,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 13,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 12,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 11,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 10,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 9,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 8,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 7,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 6,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 5,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 4,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 3,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 2,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 1,
                                                                                "Minutes": 0
                                                                        }
                                                                ],
                                                                "CACNonOccupancyChannel": [

                                                                ],
                                                                "CACActiveChannel": [

                                                                ]
                                                        },
                                                        {
                                                                "TimeStamp": "2024-04-08T16:49:11+01:00",
                                                                "CACAvailableChannelNumberOfEntries": 130,
                                                                "CACNonOccupancyChannelNumberOfEntries": 0,
                                                                "CACActiveChannelNumberOfEntries": 0,
                                                                "CACAvailableChannel": [
                                                                        {
                                                                                "OpClass": 137,
                                                                                "Channel": 63,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 137,
                                                                                "Channel": 31,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 134,
                                                                                "Channel": 79,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 134,
                                                                                "Channel": 47,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 134,
                                                                                "Channel": 15,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 87,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 71,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 55,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 39,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 23,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 133,
                                                                                "Channel": 7,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 91,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 83,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 75,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 67,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 59,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 51,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 43,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 35,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 27,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 19,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 11,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 132,
                                                                                "Channel": 3,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 93,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 89,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 85,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 81,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 77,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 73,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 69,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 65,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 61,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 57,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 53,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 49,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 45,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 41,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 37,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 33,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 29,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 25,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 21,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 17,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 13,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 9,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 5,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 131,
                                                                                "Channel": 1,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 129,
                                                                                "Channel": 114,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 129,
                                                                                "Channel": 50,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 155,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 122,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 106,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 58,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 128,
                                                                                "Channel": 42,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 127,
                                                                                "Channel": 161,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 127,
                                                                                "Channel": 153,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 126,
                                                                                "Channel": 157,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 126,
                                                                                "Channel": 149,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 125,
                                                                                "Channel": 161,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 125,
                                                                                "Channel": 157,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 125,
                                                                                "Channel": 153,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 125,
                                                                                "Channel": 149,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 124,
                                                                                "Channel": 161,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 124,
                                                                                "Channel": 157,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 124,
                                                                                "Channel": 153,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 124,
                                                                                "Channel": 149,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 123,
                                                                                "Channel": 128,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 123,
                                                                                "Channel": 120,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 123,
                                                                                "Channel": 112,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 123,
                                                                                "Channel": 104,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 122,
                                                                                "Channel": 124,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 122,
                                                                                "Channel": 116,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 122,
                                                                                "Channel": 108,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 122,
                                                                                "Channel": 100,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 144,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 128,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 124,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 120,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 116,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 112,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 108,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 104,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 121,
                                                                                "Channel": 100,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 120,
                                                                                "Channel": 64,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 120,
                                                                                "Channel": 56,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 119,
                                                                                "Channel": 60,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 119,
                                                                                "Channel": 52,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 118,
                                                                                "Channel": 64,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 118,
                                                                                "Channel": 60,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 118,
                                                                                "Channel": 56,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 118,
                                                                                "Channel": 52,
                                                                                "Minutes": 60
                                                                        },
                                                                        {
                                                                                "OpClass": 117,
                                                                                "Channel": 48,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 117,
                                                                                "Channel": 40,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 116,
                                                                                "Channel": 44,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 116,
                                                                                "Channel": 36,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 115,
                                                                                "Channel": 48,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 115,
                                                                                "Channel": 44,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 115,
                                                                                "Channel": 40,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 115,
                                                                                "Channel": 36,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 13,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 12,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 11,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 10,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 9,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 8,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 7,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 6,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 84,
                                                                                "Channel": 5,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 9,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 8,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 7,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 6,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 5,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 4,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 3,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 2,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 83,
                                                                                "Channel": 1,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 13,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 12,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 11,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 10,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 9,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 8,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 7,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 6,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 5,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 4,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 3,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 2,
                                                                                "Minutes": 0
                                                                        },
                                                                        {
                                                                                "OpClass": 81,
                                                                                "Channel": 1,
                                                                                "Minutes": 0
                                                                        }
                                                                ],
                                                                "CACNonOccupancyChannel": [

                                                                ],
                                                                "CACActiveChannel": [

                                                                ]
                                                        }
                                                ],
                                                "SPRule": [

                                                ],
                                                "IEEE1905Security": [
                                                        {
                                                                "OnboardingProtocol": 0,
                                                                "IntegrityAlgorithm": 0,
                                                                "EncryptionAlgorithm": 0
                                                        }
                                                ],
                                                "AnticipatedChannels": [

                                                ],
                                                "AnticipatedChannelUsage": [

                                                ],
                                                "MultiAPDevice": {
                                                        "ManufacturerOUI": "AE919B",
                                                        "LastContactTime": "2024-04-08T16:54:44+01:00",
                                                        "AssocIEEE1905DeviceRef": "",
                                                        "EasyMeshControllerOperationMode": "Running",
                                                        "EasyMeshAgentOperationMode": "Running",
                                                        "Backhaul": {
                                                                "LinkType": "None",
                                                                "BackhaulMACAddress": "00:00:00:00:00:00",
                                                                "BackhaulDeviceID": "00:00:00:00:00:00",
                                                                "MACAddress": "00:00:00:00:00:00",
                                                                "CurrentOperatingClassProfileNumberOfEntries": 0,
                                                                "CurrentOperatingClassProfileList": [

                                                                ],
                                                                "Stats": {
                                                                        "BytesSent": 0,
                                                                        "BytesReceived": 0,
                                                                        "PacketsSent": 0,
                                                                        "PacketsReceived": 0,
                                                                        "ErrorsSent": 0,
                                                                        "ErrorsReceived": 0,
                                                                        "LinkUtilization": 0,
                                                                        "SignalStrength": 0,
                                                                        "LastDataDownlinkRate": 0,
                                                                        "LastDataUplinkRate": 0,
                                                                        "TimeStamp": ""
                                                                }
                                                        }
                                                },
                                                "RadioList": [
                                                        {
                                                                "ID": "rJGbtwPs",
                                                                "Enabled": "true",
                                                                "Noise": 36,
                                                                "Utilization": 176,
                                                                "Transmit": 113,
                                                                "ReceiveSelf": 81,
                                                                "ReceiveOther": 0,
                                                                "TrafficSeparationCombinedFronthaul": false,
                                                                "TrafficSeparationCombinedBackhaul": false,
                                                                "SteeringPolicy": 0,
                                                                "ChannelUtilizationThreshold": 0,
                                                                "RCPISteeringThreshold": 0,
                                                                "STAReportingRCPIThreshold": 0,
                                                                "STAReportingRCPIHysteresisMarginOverride": 0,
                                                                "ChannelUtilizationReportingThreshold": 0,
                                                                "AssociatedSTATrafficStatsInclusionPolicy": "TODO bool",
                                                                "AssociatedSTALinkMetricsInclusionPolicy": "TODO bool",
                                                                "ChipsetVendor": "0x17cb",
                                                                "APMetricsWiFi6": "TODO bool",
                                                                "CurrentOperatingClassProfileNumberOfEntries": 1,
                                                                "UnassociatedSTANumberOfEntries": 0,
                                                                "BSSNumberOfEntries": 2,
                                                                "ScanResultNumberOfEntries": 0,
                                                                "DisAllowedOpClassChannelsNumberOfEntries": 0,
                                                                "ScanResult": [

                                                                ],
                                                                "BackhaulSta": {
                                                                        "MACAddress": "00:00:00:00:00:00"
                                                                },
                                                                "ScanCapability": {
                                                                        "OnBootOnly": false,
                                                                        "Impact": 4,
                                                                        "MinimumInterval": 3,
                                                                        "OpClassChannelsNumberOfEntries": 1,
                                                                        "OpClassChannels": [
                                                                                {
                                                                                        "OpClass": 81,
                                                                                        "ChannelList": [

                                                                                        ]
                                                                                }
                                                                        ]
                                                                },
                                                                "CACCapability": {
                                                                        "CACMethodNumberOfEntries": 0,
                                                                        "CACMethod": [

                                                                        ]
                                                                },
                                                                "Capabilities": {
                                                                        "HTCapabilities": "/A==",
                                                                        "VHTCapabilities": "qv+q/2ww",
                                                                        "CapableOperatingClassProfileNumberOfEntries": 3,
                                                                        "AKMFrontHaulNumberOfEntries": 0,
                                                                        "AKMBackhaulNumberOfEntries": 0,
                                                                        "WiFi6APRole": {
                                                                                "HE160": false,
                                                                                "HE8080": false,
                                                                                "MCSNSS": "qv+q/w==",
                                                                                "SUBeamformer": true,
                                                                                "SUBeamformee": false,
                                                                                "MUBeamformer": true,
                                                                                "Beamformee80orLess": true,
                                                                                "BeamformeeAbove80": false,
                                                                                "ULMUMIMO": true,
                                                                                "ULOFDMA": false,
                                                                                "MaxDLMUMIMO": 0,
                                                                                "MaxULMUMIMO": 0,
                                                                                "MaxDLOFDMA": 0,
                                                                                "MaxULOFDMA": 0,
                                                                                "RTS": false,
                                                                                "MURTS": false,
                                                                                "MultiBSSID": false,
                                                                                "MUEDCA": false,
                                                                                "TWTRequestor": false,
                                                                                "TWTResponder": true,
                                                                                "SpatialReuse": false,
                                                                                "AnticipatedChannelUsage": false
                                                                        },
                                                                        "WiFi6bSTARole": {
                                                                                "HE160": false,
                                                                                "HE8080": false,
                                                                                "MCSNSS": "AAAAAA==",
                                                                                "SUBeamformer": false,
                                                                                "SUBeamformee": false,
                                                                                "MUBeamformer": false,
                                                                                "Beamformee80orLess": false,
                                                                                "BeamformeeAbove80": false,
                                                                                "ULMUMIMO": false,
                                                                                "ULOFDMA": false,
                                                                                "MaxDLMUMIMO": 0,
                                                                                "MaxULMUMIMO": 0,
                                                                                "MaxDLOFDMA": 0,
                                                                                "MaxULOFDMA": 0,
                                                                                "RTS": false,
                                                                                "MURTS": false,
                                                                                "MultiBSSID": false,
                                                                                "MUEDCA": false,
                                                                                "TWTRequestor": false,
                                                                                "TWTResponder": false,
                                                                                "SpatialReuse": false,
                                                                                "AnticipatedChannelUsage": false
                                                                        },
                                                                        "AKMFrontHaul": [

                                                                        ],
                                                                        "AKMBackhaul": [

                                                                        ],
                                                                        "CapableOperatingClassProfile": [
                                                                                {
                                                                                        "Class": 81,
                                                                                        "MaxTxPower": 20,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 83,
                                                                                        "MaxTxPower": 20,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 84,
                                                                                        "MaxTxPower": 20,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                }
                                                                        ]
                                                                },
                                                                "CurrentOperatingClassProfile": [
                                                                        {
                                                                                "Class": 81,
                                                                                "Channel": 11,
                                                                                "TxPower": 0,
                                                                                "TransmitPowerLimit": 0,
                                                                                "TimeStamp": "1970-01-01T03:44:56+01:00"
                                                                        }
                                                                ],
                                                                "DisAllowedOpClassChannels": [

                                                                ],
                                                                "SpatialReuse": {
                                                                        "PartialBSSColor": 0,
                                                                        "BSSColor": 0,
                                                                        "HESIGASpatialReuseValue15Allowed": false,
                                                                        "SRGInformationValid": false,
                                                                        "NonSRGOffsetValid": false,
                                                                        "PSRDisallowed": false,
                                                                        "NonSRGOBSSPDMaxOffset": 0,
                                                                        "SRGOBSSPDMinOffset": 0,
                                                                        "SRGOBSSPDMaxOffset": 0,
                                                                        "SRGBSSColorBitmap": "0000000000000000",
                                                                        "SRGPartialBSSIDBitmap": "0000000000000000",
                                                                        "NeighborBSSColorInUseBitmap": "0000000000000000"
                                                                },
                                                                "BSSList": [
                                                                        {
                                                                                "BSSID": "ae:91:9b:b7:03:ec",
                                                                                "SSID": "MAP-AC919BB703E8-BH",
                                                                                "Enabled": "true",
                                                                                "LastChange": 0,
                                                                                "TimeStamp": "2024-04-08T16:54:32+01:00",
                                                                                "UnicastBytesSent": 0,
                                                                                "UnicastBytesReceived": 0,
                                                                                "MulticastBytesSent": 0,
                                                                                "MulticastBytesReceived": 0,
                                                                                "BroadcastBytesSent": 0,
                                                                                "BroadcastBytesReceived": 0,
                                                                                "ByteCounterUnits": 0,
                                                                                "Profile1bSTAsDisallowed": "TODO bool",
                                                                                "Profile2bSTAsDisallowed": "TODO bool",
                                                                                "AssociationAllowanceStatus": 0,
                                                                                "EstServiceParametersBE": "TODO base64(0:3)",
                                                                                "EstServiceParametersBK": "TODO base64(0:3)",
                                                                                "EstServiceParametersVI": "TODO base64(0:3)",
                                                                                "EstServiceParametersVO": "TODO base64(0:3)",
                                                                                "BackhaulUse": true,
                                                                                "FronthaulUse": false,
                                                                                "R1disallowed": true,
                                                                                "R2disallowed": false,
                                                                                "MultiBSSID": false,
                                                                                "TransmittedBSSID": false,
                                                                                "FronthaulAKMsAllowed": [

                                                                                ],
                                                                                "BackhaulAKMsAllowed": [

                                                                                ],
                                                                                "STANumberOfEntries": 0,
                                                                                "QMDescriptorNumberOfEntries": 0,
                                                                                "QMDescriptor": [

                                                                                ],
                                                                                "MultiAPSteering": {
                                                                                        "BlacklistAttempts": 0,
                                                                                        "BTMAttempts": 0,
                                                                                        "BTMQueryResponses": 0
                                                                                },
                                                                                "STAList": [

                                                                                ]
                                                                        },
                                                                        {
                                                                                "BSSID": "ac:91:9b:b7:03:ec",
                                                                                "SSID": "IOPSYS-AC919BB703E8",
                                                                                "Enabled": "true",
                                                                                "LastChange": 0,
                                                                                "TimeStamp": "2024-04-08T16:54:32+01:00",
                                                                                "UnicastBytesSent": 0,
                                                                                "UnicastBytesReceived": 0,
                                                                                "MulticastBytesSent": 0,
                                                                                "MulticastBytesReceived": 0,
                                                                                "BroadcastBytesSent": 0,
                                                                                "BroadcastBytesReceived": 0,
                                                                                "ByteCounterUnits": 0,
                                                                                "Profile1bSTAsDisallowed": "TODO bool",
                                                                                "Profile2bSTAsDisallowed": "TODO bool",
                                                                                "AssociationAllowanceStatus": 0,
                                                                                "EstServiceParametersBE": "TODO base64(0:3)",
                                                                                "EstServiceParametersBK": "TODO base64(0:3)",
                                                                                "EstServiceParametersVI": "TODO base64(0:3)",
                                                                                "EstServiceParametersVO": "TODO base64(0:3)",
                                                                                "BackhaulUse": false,
                                                                                "FronthaulUse": true,
                                                                                "R1disallowed": false,
                                                                                "R2disallowed": false,
                                                                                "MultiBSSID": false,
                                                                                "TransmittedBSSID": false,
                                                                                "FronthaulAKMsAllowed": [

                                                                                ],
                                                                                "BackhaulAKMsAllowed": [

                                                                                ],
                                                                                "STANumberOfEntries": 0,
                                                                                "QMDescriptorNumberOfEntries": 0,
                                                                                "QMDescriptor": [

                                                                                ],
                                                                                "MultiAPSteering": {
                                                                                        "BlacklistAttempts": 0,
                                                                                        "BTMAttempts": 0,
                                                                                        "BTMQueryResponses": 0
                                                                                },
                                                                                "STAList": [

                                                                                ]
                                                                        }
                                                                ],
                                                                "UnassociatedSTA": [

                                                                ],
                                                                "MultiAPRadio": {

                                                                }
                                                        },
                                                        {
                                                                "ID": "rJGbtwPt",
                                                                "Enabled": "true",
                                                                "Noise": 4,
                                                                "Utilization": 5,
                                                                "Transmit": 137,
                                                                "ReceiveSelf": 117,
                                                                "ReceiveOther": 0,
                                                                "TrafficSeparationCombinedFronthaul": false,
                                                                "TrafficSeparationCombinedBackhaul": false,
                                                                "SteeringPolicy": 0,
                                                                "ChannelUtilizationThreshold": 0,
                                                                "RCPISteeringThreshold": 0,
                                                                "STAReportingRCPIThreshold": 0,
                                                                "STAReportingRCPIHysteresisMarginOverride": 0,
                                                                "ChannelUtilizationReportingThreshold": 0,
                                                                "AssociatedSTATrafficStatsInclusionPolicy": "TODO bool",
                                                                "AssociatedSTALinkMetricsInclusionPolicy": "TODO bool",
                                                                "ChipsetVendor": "0x17cb",
                                                                "APMetricsWiFi6": "TODO bool",
                                                                "CurrentOperatingClassProfileNumberOfEntries": 1,
                                                                "UnassociatedSTANumberOfEntries": 0,
                                                                "BSSNumberOfEntries": 2,
                                                                "ScanResultNumberOfEntries": 0,
                                                                "DisAllowedOpClassChannelsNumberOfEntries": 0,
                                                                "ScanResult": [

                                                                ],
                                                                "BackhaulSta": {
                                                                        "MACAddress": "00:00:00:00:00:00"
                                                                },
                                                                "ScanCapability": {
                                                                        "OnBootOnly": false,
                                                                        "Impact": 4,
                                                                        "MinimumInterval": 3,
                                                                        "OpClassChannelsNumberOfEntries": 5,
                                                                        "OpClassChannels": [
                                                                                {
                                                                                        "OpClass": 115,
                                                                                        "ChannelList": [

                                                                                        ]
                                                                                },
                                                                                {
                                                                                        "OpClass": 118,
                                                                                        "ChannelList": [

                                                                                        ]
                                                                                },
                                                                                {
                                                                                        "OpClass": 121,
                                                                                        "ChannelList": [

                                                                                        ]
                                                                                },
                                                                                {
                                                                                        "OpClass": 124,
                                                                                        "ChannelList": [

                                                                                        ]
                                                                                },
                                                                                {
                                                                                        "OpClass": 125,
                                                                                        "ChannelList": [
                                                                                                149,
                                                                                                153,
                                                                                                157,
                                                                                                161
                                                                                        ]
                                                                                }
                                                                        ]
                                                                },
                                                                "CACCapability": {
                                                                        "CACMethodNumberOfEntries": 4,
                                                                        "CACMethod": [
                                                                                {
                                                                                        "Method": 2,
                                                                                        "NumberOfSeconds": 600,
                                                                                        "OpClassChannelsNumberOfEntries": 5,
                                                                                        "OpClassChannels": [
                                                                                                {
                                                                                                        "OpClass": 121,
                                                                                                        "ChannelList": [
                                                                                                                120,
                                                                                                                124,
                                                                                                                128
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 122,
                                                                                                        "ChannelList": [
                                                                                                                116,
                                                                                                                124
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 123,
                                                                                                        "ChannelList": [
                                                                                                                120,
                                                                                                                128
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 128,
                                                                                                        "ChannelList": [
                                                                                                                122
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 129,
                                                                                                        "ChannelList": [
                                                                                                                114
                                                                                                        ]
                                                                                                }
                                                                                        ]
                                                                                },
                                                                                {
                                                                                        "Method": 2,
                                                                                        "NumberOfSeconds": 60,
                                                                                        "OpClassChannelsNumberOfEntries": 8,
                                                                                        "OpClassChannels": [
                                                                                                {
                                                                                                        "OpClass": 118,
                                                                                                        "ChannelList": [
                                                                                                                52,
                                                                                                                56,
                                                                                                                60,
                                                                                                                64
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 119,
                                                                                                        "ChannelList": [
                                                                                                                52,
                                                                                                                60
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 120,
                                                                                                        "ChannelList": [
                                                                                                                56,
                                                                                                                64
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 121,
                                                                                                        "ChannelList": [
                                                                                                                100,
                                                                                                                104,
                                                                                                                108,
                                                                                                                112,
                                                                                                                116,
                                                                                                                132,
                                                                                                                136,
                                                                                                                140
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 122,
                                                                                                        "ChannelList": [
                                                                                                                100,
                                                                                                                108,
                                                                                                                132,
                                                                                                                140
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 123,
                                                                                                        "ChannelList": [
                                                                                                                104,
                                                                                                                112,
                                                                                                                136,
                                                                                                                144
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 128,
                                                                                                        "ChannelList": [
                                                                                                                58,
                                                                                                                106,
                                                                                                                138
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 129,
                                                                                                        "ChannelList": [
                                                                                                                50
                                                                                                        ]
                                                                                                }
                                                                                        ]
                                                                                },
                                                                                {
                                                                                        "Method": 0,
                                                                                        "NumberOfSeconds": 600,
                                                                                        "OpClassChannelsNumberOfEntries": 5,
                                                                                        "OpClassChannels": [
                                                                                                {
                                                                                                        "OpClass": 121,
                                                                                                        "ChannelList": [
                                                                                                                120,
                                                                                                                124,
                                                                                                                128
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 122,
                                                                                                        "ChannelList": [
                                                                                                                116,
                                                                                                                124
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 123,
                                                                                                        "ChannelList": [
                                                                                                                120,
                                                                                                                128
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 128,
                                                                                                        "ChannelList": [
                                                                                                                122
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 129,
                                                                                                        "ChannelList": [
                                                                                                                114
                                                                                                        ]
                                                                                                }
                                                                                        ]
                                                                                },
                                                                                {
                                                                                        "Method": 0,
                                                                                        "NumberOfSeconds": 60,
                                                                                        "OpClassChannelsNumberOfEntries": 8,
                                                                                        "OpClassChannels": [
                                                                                                {
                                                                                                        "OpClass": 118,
                                                                                                        "ChannelList": [
                                                                                                                52,
                                                                                                                56,
                                                                                                                60,
                                                                                                                64
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 119,
                                                                                                        "ChannelList": [
                                                                                                                52,
                                                                                                                60
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 120,
                                                                                                        "ChannelList": [
                                                                                                                56,
                                                                                                                64
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 121,
                                                                                                        "ChannelList": [
                                                                                                                100,
                                                                                                                104,
                                                                                                                108,
                                                                                                                112,
                                                                                                                116,
                                                                                                                132,
                                                                                                                136,
                                                                                                                140
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 122,
                                                                                                        "ChannelList": [
                                                                                                                100,
                                                                                                                108,
                                                                                                                132,
                                                                                                                140
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 123,
                                                                                                        "ChannelList": [
                                                                                                                104,
                                                                                                                112,
                                                                                                                136,
                                                                                                                144
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 128,
                                                                                                        "ChannelList": [
                                                                                                                58,
                                                                                                                106,
                                                                                                                138
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 129,
                                                                                                        "ChannelList": [
                                                                                                                50
                                                                                                        ]
                                                                                                }
                                                                                        ]
                                                                                }
                                                                        ]
                                                                },
                                                                "Capabilities": {
                                                                        "HTCapabilities": "/g==",
                                                                        "VHTCapabilities": "qv+q/28w",
                                                                        "CapableOperatingClassProfileNumberOfEntries": 15,
                                                                        "AKMFrontHaulNumberOfEntries": 0,
                                                                        "AKMBackhaulNumberOfEntries": 0,
                                                                        "WiFi6APRole": {
                                                                                "HE160": false,
                                                                                "HE8080": false,
                                                                                "MCSNSS": "qv+q/w==",
                                                                                "SUBeamformer": true,
                                                                                "SUBeamformee": false,
                                                                                "MUBeamformer": true,
                                                                                "Beamformee80orLess": true,
                                                                                "BeamformeeAbove80": true,
                                                                                "ULMUMIMO": true,
                                                                                "ULOFDMA": false,
                                                                                "MaxDLMUMIMO": 0,
                                                                                "MaxULMUMIMO": 0,
                                                                                "MaxDLOFDMA": 0,
                                                                                "MaxULOFDMA": 0,
                                                                                "RTS": false,
                                                                                "MURTS": false,
                                                                                "MultiBSSID": false,
                                                                                "MUEDCA": false,
                                                                                "TWTRequestor": false,
                                                                                "TWTResponder": true,
                                                                                "SpatialReuse": false,
                                                                                "AnticipatedChannelUsage": false
                                                                        },
                                                                        "WiFi6bSTARole": {
                                                                                "HE160": false,
                                                                                "HE8080": false,
                                                                                "MCSNSS": "AAAAAA==",
                                                                                "SUBeamformer": false,
                                                                                "SUBeamformee": false,
                                                                                "MUBeamformer": false,
                                                                                "Beamformee80orLess": false,
                                                                                "BeamformeeAbove80": false,
                                                                                "ULMUMIMO": false,
                                                                                "ULOFDMA": false,
                                                                                "MaxDLMUMIMO": 0,
                                                                                "MaxULMUMIMO": 0,
                                                                                "MaxDLOFDMA": 0,
                                                                                "MaxULOFDMA": 0,
                                                                                "RTS": false,
                                                                                "MURTS": false,
                                                                                "MultiBSSID": false,
                                                                                "MUEDCA": false,
                                                                                "TWTRequestor": false,
                                                                                "TWTResponder": false,
                                                                                "SpatialReuse": false,
                                                                                "AnticipatedChannelUsage": false
                                                                        },
                                                                        "AKMFrontHaul": [

                                                                        ],
                                                                        "AKMBackhaul": [

                                                                        ],
                                                                        "CapableOperatingClassProfile": [
                                                                                {
                                                                                        "Class": 115,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 116,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 117,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 118,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 119,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 120,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 121,
                                                                                        "MaxTxPower": 30,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 122,
                                                                                        "MaxTxPower": 30,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 123,
                                                                                        "MaxTxPower": 30,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 124,
                                                                                        "MaxTxPower": 13,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 125,
                                                                                        "MaxTxPower": 13,
                                                                                        "NonOperable": [
                                                                                                165,
                                                                                                169,
                                                                                                173,
                                                                                                177
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 4
                                                                                },
                                                                                {
                                                                                        "Class": 126,
                                                                                        "MaxTxPower": 13,
                                                                                        "NonOperable": [
                                                                                                165,
                                                                                                173
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 2
                                                                                },
                                                                                {
                                                                                        "Class": 127,
                                                                                        "MaxTxPower": 13,
                                                                                        "NonOperable": [
                                                                                                169,
                                                                                                177
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 2
                                                                                },
                                                                                {
                                                                                        "Class": 128,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [
                                                                                                171
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 1
                                                                                },
                                                                                {
                                                                                        "Class": 129,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [
                                                                                                163
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 1
                                                                                }
                                                                        ]
                                                                },
                                                                "CurrentOperatingClassProfile": [
                                                                        {
                                                                                "Class": 128,
                                                                                "Channel": 36,
                                                                                "TxPower": 0,
                                                                                "TransmitPowerLimit": 0,
                                                                                "TimeStamp": "1970-01-01T03:44:56+01:00"
                                                                        }
                                                                ],
                                                                "DisAllowedOpClassChannels": [

                                                                ],
                                                                "SpatialReuse": {
                                                                        "PartialBSSColor": 0,
                                                                        "BSSColor": 0,
                                                                        "HESIGASpatialReuseValue15Allowed": false,
                                                                        "SRGInformationValid": false,
                                                                        "NonSRGOffsetValid": false,
                                                                        "PSRDisallowed": false,
                                                                        "NonSRGOBSSPDMaxOffset": 0,
                                                                        "SRGOBSSPDMinOffset": 0,
                                                                        "SRGOBSSPDMaxOffset": 0,
                                                                        "SRGBSSColorBitmap": "0000000000000000",
                                                                        "SRGPartialBSSIDBitmap": "0000000000000000",
                                                                        "NeighborBSSColorInUseBitmap": "0000000000000000"
                                                                },
                                                                "BSSList": [
                                                                        {
                                                                                "BSSID": "ae:91:9b:b7:04:ed",
                                                                                "SSID": "MAP-AC919BB703E8-BH",
                                                                                "Enabled": "true",
                                                                                "LastChange": 0,
                                                                                "TimeStamp": "2024-04-08T16:54:32+01:00",
                                                                                "UnicastBytesSent": 0,
                                                                                "UnicastBytesReceived": 0,
                                                                                "MulticastBytesSent": 0,
                                                                                "MulticastBytesReceived": 0,
                                                                                "BroadcastBytesSent": 0,
                                                                                "BroadcastBytesReceived": 0,
                                                                                "ByteCounterUnits": 0,
                                                                                "Profile1bSTAsDisallowed": "TODO bool",
                                                                                "Profile2bSTAsDisallowed": "TODO bool",
                                                                                "AssociationAllowanceStatus": 0,
                                                                                "EstServiceParametersBE": "TODO base64(0:3)",
                                                                                "EstServiceParametersBK": "TODO base64(0:3)",
                                                                                "EstServiceParametersVI": "TODO base64(0:3)",
                                                                                "EstServiceParametersVO": "TODO base64(0:3)",
                                                                                "BackhaulUse": true,
                                                                                "FronthaulUse": false,
                                                                                "R1disallowed": true,
                                                                                "R2disallowed": false,
                                                                                "MultiBSSID": false,
                                                                                "TransmittedBSSID": false,
                                                                                "FronthaulAKMsAllowed": [

                                                                                ],
                                                                                "BackhaulAKMsAllowed": [

                                                                                ],
                                                                                "STANumberOfEntries": 1,
                                                                                "QMDescriptorNumberOfEntries": 0,
                                                                                "QMDescriptor": [

                                                                                ],
                                                                                "MultiAPSteering": {
                                                                                        "BlacklistAttempts": 0,
                                                                                        "BTMAttempts": 0,
                                                                                        "BTMQueryResponses": 0
                                                                                },
                                                                                "STAList": [
                                                                                        {
                                                                                                "MACAddress": "44:d4:37:e7:45:bf",
                                                                                                "TimeStamp": "2024-04-08T16:54:32+01:00",
                                                                                                "HTCapabilities": "AA==",
                                                                                                "VHTCapabilities": "AAAAAAAA",
                                                                                                "HECapabilities": "AAAAAA==",
                                                                                                "ClientCapabilities": "",
                                                                                                "LastDataDownlinkRate": 2161,
                                                                                                "LastDataUplinkRate": 2401,
                                                                                                "UtilizationReceive": 0,
                                                                                                "UtilizationTransmit": 0,
                                                                                                "EstMACDataRateDownlink": 1306,
                                                                                                "EstMACDataRateUplink": 1306,
                                                                                                "SignalStrength": 168,
                                                                                                "LastConnectTime": 586,
                                                                                                "BytesSent": 405193,
                                                                                                "BytesReceived": 478732,
                                                                                                "PacketsSent": 1453,
                                                                                                "PacketsReceived": 1857,
                                                                                                "ErrorsSent": 0,
                                                                                                "ErrorsReceived": 0,
                                                                                                "RetransCount": 45,
                                                                                                "NumberOfMeasureReports": 0,
                                                                                                "MeasurementReport": [

                                                                                                ],
                                                                                                "IPV4Address": "0.0.0.0",
                                                                                                "IPV6Address": "::",
                                                                                                "Hostname": "",
                                                                                                "CellularDataPreference": "TODO",
                                                                                                "ReAssociationDelay": 0,
                                                                                                "TIDQueueSizesNumberOfEntries": 0,
                                                                                                "MultiAPSTA": {
                                                                                                        "AssociationTime": "TODO dateTime",
                                                                                                        "Noise": 0,
                                                                                                        "SteeringHistoryNumberOfEntries": 0,
                                                                                                        "SteeringSummaryStats": {
                                                                                                                "NoCandidateAPFailures": 0,
                                                                                                                "BlacklistAttempts": 0,
                                                                                                                "BlacklistSuccesses": 0,
                                                                                                                "BlacklistFailures": 0,
                                                                                                                "BTMAttempts": 0,
                                                                                                                "BTMSuccesses": 0,
                                                                                                                "BTMFailures": 0,
                                                                                                                "BTMQueryResponses": 0,
                                                                                                                "LastSteerTime": 0
                                                                                                        },
                                                                                                        "SteeringHistory": [

                                                                                                        ]
                                                                                                },
                                                                                                "WiFi6Capabilities": {
                                                                                                        "HE160": false,
                                                                                                        "HE8080": false,
                                                                                                        "MCSNSS": "AAAAAA==",
                                                                                                        "SUBeamformer": false,
                                                                                                        "SUBeamformee": false,
                                                                                                        "MUBeamformer": false,
                                                                                                        "Beamformee80orLess": false,
                                                                                                        "BeamformeeAbove80": false,
                                                                                                        "ULMUMIMO": false,
                                                                                                        "ULOFDMA": false,
                                                                                                        "MaxDLMUMIMO": 0,
                                                                                                        "MaxULMUMIMO": 0,
                                                                                                        "MaxDLOFDMA": 0,
                                                                                                        "MaxULOFDMA": 0,
                                                                                                        "RTS": false,
                                                                                                        "MURTS": false,
                                                                                                        "MultiBSSID": false,
                                                                                                        "MUEDCA": false,
                                                                                                        "TWTRequestor": false,
                                                                                                        "TWTResponder": false,
                                                                                                        "SpatialReuse": false,
                                                                                                        "AnticipatedChannelUsage": false
                                                                                                },
                                                                                                "TIDQueueSizes": [

                                                                                                ]
                                                                                        }
                                                                                ]
                                                                        },
                                                                        {
                                                                                "BSSID": "ac:91:9b:b7:04:ed",
                                                                                "SSID": "IOPSYS-AC919BB703E8",
                                                                                "Enabled": "true",
                                                                                "LastChange": 0,
                                                                                "TimeStamp": "2024-04-08T16:54:32+01:00",
                                                                                "UnicastBytesSent": 0,
                                                                                "UnicastBytesReceived": 0,
                                                                                "MulticastBytesSent": 0,
                                                                                "MulticastBytesReceived": 0,
                                                                                "BroadcastBytesSent": 0,
                                                                                "BroadcastBytesReceived": 0,
                                                                                "ByteCounterUnits": 0,
                                                                                "Profile1bSTAsDisallowed": "TODO bool",
                                                                                "Profile2bSTAsDisallowed": "TODO bool",
                                                                                "AssociationAllowanceStatus": 0,
                                                                                "EstServiceParametersBE": "TODO base64(0:3)",
                                                                                "EstServiceParametersBK": "TODO base64(0:3)",
                                                                                "EstServiceParametersVI": "TODO base64(0:3)",
                                                                                "EstServiceParametersVO": "TODO base64(0:3)",
                                                                                "BackhaulUse": false,
                                                                                "FronthaulUse": true,
                                                                                "R1disallowed": false,
                                                                                "R2disallowed": false,
                                                                                "MultiBSSID": false,
                                                                                "TransmittedBSSID": false,
                                                                                "FronthaulAKMsAllowed": [

                                                                                ],
                                                                                "BackhaulAKMsAllowed": [

                                                                                ],
                                                                                "STANumberOfEntries": 0,
                                                                                "QMDescriptorNumberOfEntries": 0,
                                                                                "QMDescriptor": [

                                                                                ],
                                                                                "MultiAPSteering": {
                                                                                        "BlacklistAttempts": 0,
                                                                                        "BTMAttempts": 0,
                                                                                        "BTMQueryResponses": 0
                                                                                },
                                                                                "STAList": [

                                                                                ]
                                                                        }
                                                                ],
                                                                "UnassociatedSTA": [

                                                                ],
                                                                "MultiAPRadio": {

                                                                }
                                                        },
                                                        {
                                                                "ID": "rJGbtwPu",
                                                                "Enabled": "true",
                                                                "Noise": 32,
                                                                "Utilization": 82,
                                                                "Transmit": 215,
                                                                "ReceiveSelf": 0,
                                                                "ReceiveOther": 0,
                                                                "TrafficSeparationCombinedFronthaul": false,
                                                                "TrafficSeparationCombinedBackhaul": false,
                                                                "SteeringPolicy": 0,
                                                                "ChannelUtilizationThreshold": 0,
                                                                "RCPISteeringThreshold": 0,
                                                                "STAReportingRCPIThreshold": 0,
                                                                "STAReportingRCPIHysteresisMarginOverride": 0,
                                                                "ChannelUtilizationReportingThreshold": 0,
                                                                "AssociatedSTATrafficStatsInclusionPolicy": "TODO bool",
                                                                "AssociatedSTALinkMetricsInclusionPolicy": "TODO bool",
                                                                "ChipsetVendor": "0x17cb",
                                                                "APMetricsWiFi6": "TODO bool",
                                                                "CurrentOperatingClassProfileNumberOfEntries": 1,
                                                                "UnassociatedSTANumberOfEntries": 0,
                                                                "BSSNumberOfEntries": 2,
                                                                "ScanResultNumberOfEntries": 0,
                                                                "DisAllowedOpClassChannelsNumberOfEntries": 0,
                                                                "ScanResult": [

                                                                ],
                                                                "BackhaulSta": {
                                                                        "MACAddress": "00:00:00:00:00:00"
                                                                },
                                                                "ScanCapability": {
                                                                        "OnBootOnly": false,
                                                                        "Impact": 4,
                                                                        "MinimumInterval": 3,
                                                                        "OpClassChannelsNumberOfEntries": 1,
                                                                        "OpClassChannels": [
                                                                                {
                                                                                        "OpClass": 131,
                                                                                        "ChannelList": [
                                                                                                1,
                                                                                                5,
                                                                                                9,
                                                                                                13,
                                                                                                17,
                                                                                                21,
                                                                                                25,
                                                                                                29,
                                                                                                33,
                                                                                                37,
                                                                                                41,
                                                                                                45,
                                                                                                49,
                                                                                                53,
                                                                                                57,
                                                                                                61,
                                                                                                65,
                                                                                                69,
                                                                                                73,
                                                                                                77,
                                                                                                81,
                                                                                                85,
                                                                                                89,
                                                                                                93
                                                                                        ]
                                                                                }
                                                                        ]
                                                                },
                                                                "CACCapability": {
                                                                        "CACMethodNumberOfEntries": 0,
                                                                        "CACMethod": [

                                                                        ]
                                                                },
                                                                "Capabilities": {
                                                                        "HTCapabilities": "AA==",
                                                                        "VHTCapabilities": "AAAAAAAA",
                                                                        "CapableOperatingClassProfileNumberOfEntries": 5,
                                                                        "AKMFrontHaulNumberOfEntries": 0,
                                                                        "AKMBackhaulNumberOfEntries": 0,
                                                                        "WiFi6APRole": {
                                                                                "HE160": false,
                                                                                "HE8080": false,
                                                                                "MCSNSS": "qv+q/w==",
                                                                                "SUBeamformer": true,
                                                                                "SUBeamformee": false,
                                                                                "MUBeamformer": true,
                                                                                "Beamformee80orLess": true,
                                                                                "BeamformeeAbove80": true,
                                                                                "ULMUMIMO": true,
                                                                                "ULOFDMA": false,
                                                                                "MaxDLMUMIMO": 0,
                                                                                "MaxULMUMIMO": 0,
                                                                                "MaxDLOFDMA": 0,
                                                                                "MaxULOFDMA": 0,
                                                                                "RTS": false,
                                                                                "MURTS": false,
                                                                                "MultiBSSID": true,
                                                                                "MUEDCA": false,
                                                                                "TWTRequestor": false,
                                                                                "TWTResponder": true,
                                                                                "SpatialReuse": false,
                                                                                "AnticipatedChannelUsage": false
                                                                        },
                                                                        "WiFi6bSTARole": {
                                                                                "HE160": false,
                                                                                "HE8080": false,
                                                                                "MCSNSS": "AAAAAA==",
                                                                                "SUBeamformer": false,
                                                                                "SUBeamformee": false,
                                                                                "MUBeamformer": false,
                                                                                "Beamformee80orLess": false,
                                                                                "BeamformeeAbove80": false,
                                                                                "ULMUMIMO": false,
                                                                                "ULOFDMA": false,
                                                                                "MaxDLMUMIMO": 0,
                                                                                "MaxULMUMIMO": 0,
                                                                                "MaxDLOFDMA": 0,
                                                                                "MaxULOFDMA": 0,
                                                                                "RTS": false,
                                                                                "MURTS": false,
                                                                                "MultiBSSID": false,
                                                                                "MUEDCA": false,
                                                                                "TWTRequestor": false,
                                                                                "TWTResponder": false,
                                                                                "SpatialReuse": false,
                                                                                "AnticipatedChannelUsage": false
                                                                        },
                                                                        "AKMFrontHaul": [

                                                                        ],
                                                                        "AKMBackhaul": [

                                                                        ],
                                                                        "CapableOperatingClassProfile": [
                                                                                {
                                                                                        "Class": 131,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [
                                                                                                97,
                                                                                                101,
                                                                                                105,
                                                                                                109,
                                                                                                113,
                                                                                                117,
                                                                                                121,
                                                                                                125,
                                                                                                129,
                                                                                                133,
                                                                                                137,
                                                                                                141,
                                                                                                145,
                                                                                                149,
                                                                                                153,
                                                                                                157,
                                                                                                161,
                                                                                                165,
                                                                                                169,
                                                                                                173,
                                                                                                177,
                                                                                                181,
                                                                                                185,
                                                                                                189,
                                                                                                193,
                                                                                                197,
                                                                                                201,
                                                                                                205,
                                                                                                209,
                                                                                                213,
                                                                                                217,
                                                                                                221,
                                                                                                225,
                                                                                                229,
                                                                                                233
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 35
                                                                                },
                                                                                {
                                                                                        "Class": 132,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [
                                                                                                99,
                                                                                                107,
                                                                                                115,
                                                                                                123,
                                                                                                131,
                                                                                                139,
                                                                                                147,
                                                                                                155,
                                                                                                163,
                                                                                                171,
                                                                                                179,
                                                                                                187,
                                                                                                195,
                                                                                                203,
                                                                                                211,
                                                                                                219,
                                                                                                227
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 17
                                                                                },
                                                                                {
                                                                                        "Class": 133,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [
                                                                                                103,
                                                                                                119,
                                                                                                135,
                                                                                                151,
                                                                                                167,
                                                                                                183,
                                                                                                199,
                                                                                                215
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 8
                                                                                },
                                                                                {
                                                                                        "Class": 134,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [
                                                                                                111,
                                                                                                143,
                                                                                                175,
                                                                                                207
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 4
                                                                                },
                                                                                {
                                                                                        "Class": 137,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [
                                                                                                95,
                                                                                                127,
                                                                                                159,
                                                                                                191
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 4
                                                                                }
                                                                        ]
                                                                },
                                                                "CurrentOperatingClassProfile": [
                                                                        {
                                                                                "Class": 137,
                                                                                "Channel": 53,
                                                                                "TxPower": 0,
                                                                                "TransmitPowerLimit": 0,
                                                                                "TimeStamp": "1970-01-01T03:44:56+01:00"
                                                                        }
                                                                ],
                                                                "DisAllowedOpClassChannels": [

                                                                ],
                                                                "SpatialReuse": {
                                                                        "PartialBSSColor": 0,
                                                                        "BSSColor": 0,
                                                                        "HESIGASpatialReuseValue15Allowed": false,
                                                                        "SRGInformationValid": false,
                                                                        "NonSRGOffsetValid": false,
                                                                        "PSRDisallowed": false,
                                                                        "NonSRGOBSSPDMaxOffset": 0,
                                                                        "SRGOBSSPDMinOffset": 0,
                                                                        "SRGOBSSPDMaxOffset": 0,
                                                                        "SRGBSSColorBitmap": "0000000000000000",
                                                                        "SRGPartialBSSIDBitmap": "0000000000000000",
                                                                        "NeighborBSSColorInUseBitmap": "0000000000000000"
                                                                },
                                                                "BSSList": [
                                                                        {
                                                                                "BSSID": "ac:91:9b:b7:05:ef",
                                                                                "SSID": "MAP-AC919BB703E8-BH",
                                                                                "Enabled": "true",
                                                                                "LastChange": 0,
                                                                                "TimeStamp": "2024-04-08T16:54:32+01:00",
                                                                                "UnicastBytesSent": 0,
                                                                                "UnicastBytesReceived": 0,
                                                                                "MulticastBytesSent": 0,
                                                                                "MulticastBytesReceived": 0,
                                                                                "BroadcastBytesSent": 0,
                                                                                "BroadcastBytesReceived": 0,
                                                                                "ByteCounterUnits": 0,
                                                                                "Profile1bSTAsDisallowed": "TODO bool",
                                                                                "Profile2bSTAsDisallowed": "TODO bool",
                                                                                "AssociationAllowanceStatus": 0,
                                                                                "EstServiceParametersBE": "TODO base64(0:3)",
                                                                                "EstServiceParametersBK": "TODO base64(0:3)",
                                                                                "EstServiceParametersVI": "TODO base64(0:3)",
                                                                                "EstServiceParametersVO": "TODO base64(0:3)",
                                                                                "BackhaulUse": true,
                                                                                "FronthaulUse": false,
                                                                                "R1disallowed": true,
                                                                                "R2disallowed": false,
                                                                                "MultiBSSID": false,
                                                                                "TransmittedBSSID": false,
                                                                                "FronthaulAKMsAllowed": [

                                                                                ],
                                                                                "BackhaulAKMsAllowed": [

                                                                                ],
                                                                                "STANumberOfEntries": 0,
                                                                                "QMDescriptorNumberOfEntries": 0,
                                                                                "QMDescriptor": [

                                                                                ],
                                                                                "MultiAPSteering": {
                                                                                        "BlacklistAttempts": 0,
                                                                                        "BTMAttempts": 0,
                                                                                        "BTMQueryResponses": 0
                                                                                },
                                                                                "STAList": [

                                                                                ]
                                                                        },
                                                                        {
                                                                                "BSSID": "ac:91:9b:b7:05:ee",
                                                                                "SSID": "IOPSYS-AC919BB703E8",
                                                                                "Enabled": "true",
                                                                                "LastChange": 0,
                                                                                "TimeStamp": "2024-04-08T16:54:32+01:00",
                                                                                "UnicastBytesSent": 0,
                                                                                "UnicastBytesReceived": 0,
                                                                                "MulticastBytesSent": 0,
                                                                                "MulticastBytesReceived": 0,
                                                                                "BroadcastBytesSent": 0,
                                                                                "BroadcastBytesReceived": 0,
                                                                                "ByteCounterUnits": 0,
                                                                                "Profile1bSTAsDisallowed": "TODO bool",
                                                                                "Profile2bSTAsDisallowed": "TODO bool",
                                                                                "AssociationAllowanceStatus": 0,
                                                                                "EstServiceParametersBE": "TODO base64(0:3)",
                                                                                "EstServiceParametersBK": "TODO base64(0:3)",
                                                                                "EstServiceParametersVI": "TODO base64(0:3)",
                                                                                "EstServiceParametersVO": "TODO base64(0:3)",
                                                                                "BackhaulUse": false,
                                                                                "FronthaulUse": true,
                                                                                "R1disallowed": false,
                                                                                "R2disallowed": false,
                                                                                "MultiBSSID": false,
                                                                                "TransmittedBSSID": false,
                                                                                "FronthaulAKMsAllowed": [

                                                                                ],
                                                                                "BackhaulAKMsAllowed": [

                                                                                ],
                                                                                "STANumberOfEntries": 0,
                                                                                "QMDescriptorNumberOfEntries": 0,
                                                                                "QMDescriptor": [

                                                                                ],
                                                                                "MultiAPSteering": {
                                                                                        "BlacklistAttempts": 0,
                                                                                        "BTMAttempts": 0,
                                                                                        "BTMQueryResponses": 0
                                                                                },
                                                                                "STAList": [

                                                                                ]
                                                                        }
                                                                ],
                                                                "UnassociatedSTA": [

                                                                ],
                                                                "MultiAPRadio": {

                                                                }
                                                        }
                                                ]
                                        },
                                        {
                                                "ID": "46:d4:37:e7:45:b0",
                                                "MultiAPCapabilities": "oA==",
                                                "CollectionInterval": 60,
                                                "ReportUnsuccessfulAssociations": false,
                                                "MaxReportingRate": 0,
                                                "APMetricsReportingInterval": 0,
                                                "Manufacturer": "IOPSYS",
                                                "SerialNumber": "Y.072312016B",
                                                "ManufacturerModel": "TODO",
                                                "SoftwareVersion": "7.3.1rc1-4-gc52c7c8d7b-eval",
                                                "ExecutionEnv": "",
                                                "DSCPMap": "TODO",
                                                "MaxPrioritizationRules": 0,
                                                "PrioritizationSupport": false,
                                                "MaxVIDs": 255,
                                                "APMetricsWiFi6": "TODO bool",
                                                "CountryCode": "DE",
                                                "LocalSteeringDisallowedSTAList": [

                                                ],
                                                "BTMSteeringDisalloywedSTAList": [

                                                ],
                                                "DFSEnable": true,
                                                "ReportIndependentScans": false,
                                                "STASteeringState": false,
                                                "CoordinatedCACAllowed": false,
                                                "TrafficSeparationAllowed": false,
                                                "ServicePrioritizationAllowed": "TODO bool",
                                                "RadioNumberOfEntries": 2,
                                                "Default8021QNumberOfEntries": 1,
                                                "SSIDtoVIDMappingNumberOfEntries": 6,
                                                "CACStatusNumberOfEntries": 3,
                                                "IEEE1905SecurityNumberOfEntries": 1,
                                                "SPRuleNumberOfEntries": 0,
                                                "AnticipatedChannelsNumberOfEntries": 0,
                                                "AnticipatedChannelUsageNumberOfEntries": 0,
                                                "Default8021Q": [
                                                        {
                                                                "Enable": true,
                                                                "PrimaryVID": 1,
                                                                "DefaultPCP": 0
                                                        }
                                                ],
                                                "SSIDtoVIDMapping": [
                                                        {
                                                                "SSID": "IOPSYS-AC919BB703E8",
                                                                "VID": 1
                                                        },
                                                        {
                                                                "SSID": "IOPSYS-AC919BB703E8",
                                                                "VID": 1
                                                        },
                                                        {
                                                                "SSID": "IOPSYS-AC919BB703E8",
                                                                "VID": 1
                                                        },
                                                        {
                                                                "SSID": "MAP-AC919BB703E8-BH",
                                                                "VID": 1
                                                        },
                                                        {
                                                                "SSID": "MAP-AC919BB703E8-BH",
                                                                "VID": 1
                                                        },
                                                        {
                                                                "SSID": "MAP-AC919BB703E8-BH",
                                                                "VID": 1
                                                        }
                                                ],
                                                "CACStatus": [
                                                        {
                                                                "TimeStamp": "2024-04-08T16:53:19+01:00",
                                                                "CACAvailableChannelNumberOfEntries": 0,
                                                                "CACNonOccupancyChannelNumberOfEntries": 0,
                                                                "CACActiveChannelNumberOfEntries": 0,
                                                                "CACAvailableChannel": [

                                                                ],
                                                                "CACNonOccupancyChannel": [

                                                                ],
                                                                "CACActiveChannel": [

                                                                ]
                                                        },
                                                        {
                                                                "TimeStamp": "2024-04-08T16:51:17+01:00",
                                                                "CACAvailableChannelNumberOfEntries": 0,
                                                                "CACNonOccupancyChannelNumberOfEntries": 0,
                                                                "CACActiveChannelNumberOfEntries": 0,
                                                                "CACAvailableChannel": [

                                                                ],
                                                                "CACNonOccupancyChannel": [

                                                                ],
                                                                "CACActiveChannel": [

                                                                ]
                                                        },
                                                        {
                                                                "TimeStamp": "2024-04-08T16:49:15+01:00",
                                                                "CACAvailableChannelNumberOfEntries": 0,
                                                                "CACNonOccupancyChannelNumberOfEntries": 0,
                                                                "CACActiveChannelNumberOfEntries": 0,
                                                                "CACAvailableChannel": [

                                                                ],
                                                                "CACNonOccupancyChannel": [

                                                                ],
                                                                "CACActiveChannel": [

                                                                ]
                                                        }
                                                ],
                                                "SPRule": [

                                                ],
                                                "IEEE1905Security": [
                                                        {
                                                                "OnboardingProtocol": 0,
                                                                "IntegrityAlgorithm": 0,
                                                                "EncryptionAlgorithm": 0
                                                        }
                                                ],
                                                "AnticipatedChannels": [

                                                ],
                                                "AnticipatedChannelUsage": [

                                                ],
                                                "MultiAPDevice": {
                                                        "ManufacturerOUI": "46D437",
                                                        "LastContactTime": "2024-04-08T16:54:44+01:00",
                                                        "AssocIEEE1905DeviceRef": "",
                                                        "EasyMeshControllerOperationMode": "NotSupported",
                                                        "EasyMeshAgentOperationMode": "Running",
                                                        "Backhaul": {
                                                                "LinkType": "Wi-Fi",
                                                                "BackhaulMACAddress": "ae:91:9b:b7:04:ed",
                                                                "BackhaulDeviceID": "ae:91:9b:b7:03:e8",
                                                                "MACAddress": "44:d4:37:e7:45:bf",
                                                                "CurrentOperatingClassProfileNumberOfEntries": 0,
                                                                "CurrentOperatingClassProfileList": [

                                                                ],
                                                                "Stats": {
                                                                        "BytesSent": 0,
                                                                        "BytesReceived": 0,
                                                                        "PacketsSent": 1796,
                                                                        "PacketsReceived": 1185,
                                                                        "ErrorsSent": 0,
                                                                        "ErrorsReceived": 0,
                                                                        "LinkUtilization": 0,
                                                                        "SignalStrength": 154,
                                                                        "LastDataDownlinkRate": 0,
                                                                        "LastDataUplinkRate": 2217984,
                                                                        "TimeStamp": "2024-04-08T16:54:33+01:00"
                                                                }
                                                        }
                                                },
                                                "RadioList": [
                                                        {
                                                                "ID": "RNQ350W/",
                                                                "Enabled": "true",
                                                                "Noise": 42,
                                                                "Utilization": 61,
                                                                "Transmit": 5,
                                                                "ReceiveSelf": 2,
                                                                "ReceiveOther": 48,
                                                                "TrafficSeparationCombinedFronthaul": false,
                                                                "TrafficSeparationCombinedBackhaul": false,
                                                                "SteeringPolicy": 0,
                                                                "ChannelUtilizationThreshold": 0,
                                                                "RCPISteeringThreshold": 0,
                                                                "STAReportingRCPIThreshold": 0,
                                                                "STAReportingRCPIHysteresisMarginOverride": 0,
                                                                "ChannelUtilizationReportingThreshold": 0,
                                                                "AssociatedSTATrafficStatsInclusionPolicy": "TODO bool",
                                                                "AssociatedSTALinkMetricsInclusionPolicy": "TODO bool",
                                                                "ChipsetVendor": "0x14e4",
                                                                "APMetricsWiFi6": "TODO bool",
                                                                "CurrentOperatingClassProfileNumberOfEntries": 1,
                                                                "UnassociatedSTANumberOfEntries": 0,
                                                                "BSSNumberOfEntries": 2,
                                                                "ScanResultNumberOfEntries": 0,
                                                                "DisAllowedOpClassChannelsNumberOfEntries": 0,
                                                                "ScanResult": [

                                                                ],
                                                                "BackhaulSta": {
                                                                        "MACAddress": "44:d4:37:e7:45:bf"
                                                                },
                                                                "ScanCapability": {
                                                                        "OnBootOnly": false,
                                                                        "Impact": 4,
                                                                        "MinimumInterval": 3,
                                                                        "OpClassChannelsNumberOfEntries": 3,
                                                                        "OpClassChannels": [
                                                                                {
                                                                                        "OpClass": 115,
                                                                                        "ChannelList": [

                                                                                        ]
                                                                                },
                                                                                {
                                                                                        "OpClass": 118,
                                                                                        "ChannelList": [

                                                                                        ]
                                                                                },
                                                                                {
                                                                                        "OpClass": 121,
                                                                                        "ChannelList": [
                                                                                                100,
                                                                                                104,
                                                                                                108,
                                                                                                112,
                                                                                                116,
                                                                                                120,
                                                                                                124,
                                                                                                128,
                                                                                                132,
                                                                                                136,
                                                                                                140
                                                                                        ]
                                                                                }
                                                                        ]
                                                                },
                                                                "CACCapability": {
                                                                        "CACMethodNumberOfEntries": 4,
                                                                        "CACMethod": [
                                                                                {
                                                                                        "Method": 2,
                                                                                        "NumberOfSeconds": 600,
                                                                                        "OpClassChannelsNumberOfEntries": 5,
                                                                                        "OpClassChannels": [
                                                                                                {
                                                                                                        "OpClass": 121,
                                                                                                        "ChannelList": [
                                                                                                                120,
                                                                                                                124,
                                                                                                                128
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 122,
                                                                                                        "ChannelList": [
                                                                                                                116,
                                                                                                                124
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 123,
                                                                                                        "ChannelList": [
                                                                                                                120,
                                                                                                                128
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 128,
                                                                                                        "ChannelList": [
                                                                                                                122
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 129,
                                                                                                        "ChannelList": [
                                                                                                                114
                                                                                                        ]
                                                                                                }
                                                                                        ]
                                                                                },
                                                                                {
                                                                                        "Method": 2,
                                                                                        "NumberOfSeconds": 60,
                                                                                        "OpClassChannelsNumberOfEntries": 8,
                                                                                        "OpClassChannels": [
                                                                                                {
                                                                                                        "OpClass": 118,
                                                                                                        "ChannelList": [
                                                                                                                52,
                                                                                                                56,
                                                                                                                60,
                                                                                                                64
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 119,
                                                                                                        "ChannelList": [
                                                                                                                52,
                                                                                                                60
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 120,
                                                                                                        "ChannelList": [
                                                                                                                56,
                                                                                                                64
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 121,
                                                                                                        "ChannelList": [
                                                                                                                100,
                                                                                                                104,
                                                                                                                108,
                                                                                                                112,
                                                                                                                116,
                                                                                                                132,
                                                                                                                136,
                                                                                                                140
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 122,
                                                                                                        "ChannelList": [
                                                                                                                100,
                                                                                                                108,
                                                                                                                132,
                                                                                                                140
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 123,
                                                                                                        "ChannelList": [
                                                                                                                104,
                                                                                                                112,
                                                                                                                136
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 128,
                                                                                                        "ChannelList": [
                                                                                                                58,
                                                                                                                106
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 129,
                                                                                                        "ChannelList": [
                                                                                                                50
                                                                                                        ]
                                                                                                }
                                                                                        ]
                                                                                },
                                                                                {
                                                                                        "Method": 0,
                                                                                        "NumberOfSeconds": 600,
                                                                                        "OpClassChannelsNumberOfEntries": 5,
                                                                                        "OpClassChannels": [
                                                                                                {
                                                                                                        "OpClass": 121,
                                                                                                        "ChannelList": [
                                                                                                                120,
                                                                                                                124,
                                                                                                                128
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 122,
                                                                                                        "ChannelList": [
                                                                                                                116,
                                                                                                                124
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 123,
                                                                                                        "ChannelList": [
                                                                                                                120,
                                                                                                                128
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 128,
                                                                                                        "ChannelList": [
                                                                                                                122
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 129,
                                                                                                        "ChannelList": [
                                                                                                                114
                                                                                                        ]
                                                                                                }
                                                                                        ]
                                                                                },
                                                                                {
                                                                                        "Method": 0,
                                                                                        "NumberOfSeconds": 60,
                                                                                        "OpClassChannelsNumberOfEntries": 8,
                                                                                        "OpClassChannels": [
                                                                                                {
                                                                                                        "OpClass": 118,
                                                                                                        "ChannelList": [
                                                                                                                52,
                                                                                                                56,
                                                                                                                60,
                                                                                                                64
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 119,
                                                                                                        "ChannelList": [
                                                                                                                52,
                                                                                                                60
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 120,
                                                                                                        "ChannelList": [
                                                                                                                56,
                                                                                                                64
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 121,
                                                                                                        "ChannelList": [
                                                                                                                100,
                                                                                                                104,
                                                                                                                108,
                                                                                                                112,
                                                                                                                116,
                                                                                                                132,
                                                                                                                136,
                                                                                                                140
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 122,
                                                                                                        "ChannelList": [
                                                                                                                100,
                                                                                                                108,
                                                                                                                132,
                                                                                                                140
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 123,
                                                                                                        "ChannelList": [
                                                                                                                104,
                                                                                                                112,
                                                                                                                136
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 128,
                                                                                                        "ChannelList": [
                                                                                                                58,
                                                                                                                106
                                                                                                        ]
                                                                                                },
                                                                                                {
                                                                                                        "OpClass": 129,
                                                                                                        "ChannelList": [
                                                                                                                50
                                                                                                        ]
                                                                                                }
                                                                                        ]
                                                                                }
                                                                        ]
                                                                },
                                                                "Capabilities": {
                                                                        "HTCapabilities": "/g==",
                                                                        "VHTCapabilities": "qv+q/24w",
                                                                        "CapableOperatingClassProfileNumberOfEntries": 11,
                                                                        "AKMFrontHaulNumberOfEntries": 0,
                                                                        "AKMBackhaulNumberOfEntries": 0,
                                                                        "WiFi6APRole": {
                                                                                "HE160": false,
                                                                                "HE8080": false,
                                                                                "MCSNSS": "qv+q/w==",
                                                                                "SUBeamformer": true,
                                                                                "SUBeamformee": false,
                                                                                "MUBeamformer": true,
                                                                                "Beamformee80orLess": false,
                                                                                "BeamformeeAbove80": false,
                                                                                "ULMUMIMO": true,
                                                                                "ULOFDMA": false,
                                                                                "MaxDLMUMIMO": 0,
                                                                                "MaxULMUMIMO": 0,
                                                                                "MaxDLOFDMA": 0,
                                                                                "MaxULOFDMA": 0,
                                                                                "RTS": false,
                                                                                "MURTS": false,
                                                                                "MultiBSSID": false,
                                                                                "MUEDCA": false,
                                                                                "TWTRequestor": false,
                                                                                "TWTResponder": true,
                                                                                "SpatialReuse": false,
                                                                                "AnticipatedChannelUsage": false
                                                                        },
                                                                        "WiFi6bSTARole": {
                                                                                "HE160": false,
                                                                                "HE8080": false,
                                                                                "MCSNSS": "AAAAAA==",
                                                                                "SUBeamformer": false,
                                                                                "SUBeamformee": false,
                                                                                "MUBeamformer": false,
                                                                                "Beamformee80orLess": false,
                                                                                "BeamformeeAbove80": false,
                                                                                "ULMUMIMO": false,
                                                                                "ULOFDMA": false,
                                                                                "MaxDLMUMIMO": 0,
                                                                                "MaxULMUMIMO": 0,
                                                                                "MaxDLOFDMA": 0,
                                                                                "MaxULOFDMA": 0,
                                                                                "RTS": false,
                                                                                "MURTS": false,
                                                                                "MultiBSSID": false,
                                                                                "MUEDCA": false,
                                                                                "TWTRequestor": false,
                                                                                "TWTResponder": false,
                                                                                "SpatialReuse": false,
                                                                                "AnticipatedChannelUsage": false
                                                                        },
                                                                        "AKMFrontHaul": [

                                                                        ],
                                                                        "AKMBackhaul": [

                                                                        ],
                                                                        "CapableOperatingClassProfile": [
                                                                                {
                                                                                        "Class": 115,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 116,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 117,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 118,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 119,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 120,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 121,
                                                                                        "MaxTxPower": 30,
                                                                                        "NonOperable": [
                                                                                                144
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 1
                                                                                },
                                                                                {
                                                                                        "Class": 122,
                                                                                        "MaxTxPower": 30,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 123,
                                                                                        "MaxTxPower": 30,
                                                                                        "NonOperable": [
                                                                                                144
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 1
                                                                                },
                                                                                {
                                                                                        "Class": 128,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [
                                                                                                138,
                                                                                                155,
                                                                                                171
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 3
                                                                                },
                                                                                {
                                                                                        "Class": 129,
                                                                                        "MaxTxPower": 23,
                                                                                        "NonOperable": [
                                                                                                163
                                                                                        ],
                                                                                        "NumberOfNonOperChan": 1
                                                                                }
                                                                        ]
                                                                },
                                                                "CurrentOperatingClassProfile": [
                                                                        {
                                                                                "Class": 128,
                                                                                "Channel": 36,
                                                                                "TxPower": 23,
                                                                                "TransmitPowerLimit": 0,
                                                                                "TimeStamp": "1970-01-01T03:44:38+01:00"
                                                                        }
                                                                ],
                                                                "DisAllowedOpClassChannels": [

                                                                ],
                                                                "SpatialReuse": {
                                                                        "PartialBSSColor": 0,
                                                                        "BSSColor": 0,
                                                                        "HESIGASpatialReuseValue15Allowed": false,
                                                                        "SRGInformationValid": false,
                                                                        "NonSRGOffsetValid": false,
                                                                        "PSRDisallowed": false,
                                                                        "NonSRGOBSSPDMaxOffset": 0,
                                                                        "SRGOBSSPDMinOffset": 0,
                                                                        "SRGOBSSPDMaxOffset": 0,
                                                                        "SRGBSSColorBitmap": "0000000000000000",
                                                                        "SRGPartialBSSIDBitmap": "0000000000000000",
                                                                        "NeighborBSSColorInUseBitmap": "0000000000000000"
                                                                },
                                                                "BSSList": [
                                                                        {
                                                                                "BSSID": "fe:d4:37:e7:45:b9",
                                                                                "SSID": "MAP-AC919BB703E8-BH",
                                                                                "Enabled": "true",
                                                                                "LastChange": 0,
                                                                                "TimeStamp": "2024-04-08T16:54:43+01:00",
                                                                                "UnicastBytesSent": 0,
                                                                                "UnicastBytesReceived": 0,
                                                                                "MulticastBytesSent": 16,
                                                                                "MulticastBytesReceived": 0,
                                                                                "BroadcastBytesSent": 1,
                                                                                "BroadcastBytesReceived": 0,
                                                                                "ByteCounterUnits": 0,
                                                                                "Profile1bSTAsDisallowed": "TODO bool",
                                                                                "Profile2bSTAsDisallowed": "TODO bool",
                                                                                "AssociationAllowanceStatus": 0,
                                                                                "EstServiceParametersBE": "TODO base64(0:3)",
                                                                                "EstServiceParametersBK": "TODO base64(0:3)",
                                                                                "EstServiceParametersVI": "TODO base64(0:3)",
                                                                                "EstServiceParametersVO": "TODO base64(0:3)",
                                                                                "BackhaulUse": true,
                                                                                "FronthaulUse": false,
                                                                                "R1disallowed": true,
                                                                                "R2disallowed": false,
                                                                                "MultiBSSID": false,
                                                                                "TransmittedBSSID": false,
                                                                                "FronthaulAKMsAllowed": [

                                                                                ],
                                                                                "BackhaulAKMsAllowed": [

                                                                                ],
                                                                                "STANumberOfEntries": 0,
                                                                                "QMDescriptorNumberOfEntries": 0,
                                                                                "QMDescriptor": [

                                                                                ],
                                                                                "MultiAPSteering": {
                                                                                        "BlacklistAttempts": 0,
                                                                                        "BTMAttempts": 0,
                                                                                        "BTMQueryResponses": 0
                                                                                },
                                                                                "STAList": [

                                                                                ]
                                                                        },
                                                                        {
                                                                                "BSSID": "fe:d4:37:e7:45:b8",
                                                                                "SSID": "IOPSYS-AC919BB703E8",
                                                                                "Enabled": "true",
                                                                                "LastChange": 0,
                                                                                "TimeStamp": "2024-04-08T16:54:43+01:00",
                                                                                "UnicastBytesSent": 0,
                                                                                "UnicastBytesReceived": 0,
                                                                                "MulticastBytesSent": 15,
                                                                                "MulticastBytesReceived": 0,
                                                                                "BroadcastBytesSent": 1,
                                                                                "BroadcastBytesReceived": 0,
                                                                                "ByteCounterUnits": 0,
                                                                                "Profile1bSTAsDisallowed": "TODO bool",
                                                                                "Profile2bSTAsDisallowed": "TODO bool",
                                                                                "AssociationAllowanceStatus": 0,
                                                                                "EstServiceParametersBE": "TODO base64(0:3)",
                                                                                "EstServiceParametersBK": "TODO base64(0:3)",
                                                                                "EstServiceParametersVI": "TODO base64(0:3)",
                                                                                "EstServiceParametersVO": "TODO base64(0:3)",
                                                                                "BackhaulUse": false,
                                                                                "FronthaulUse": true,
                                                                                "R1disallowed": false,
                                                                                "R2disallowed": false,
                                                                                "MultiBSSID": false,
                                                                                "TransmittedBSSID": false,
                                                                                "FronthaulAKMsAllowed": [

                                                                                ],
                                                                                "BackhaulAKMsAllowed": [

                                                                                ],
                                                                                "STANumberOfEntries": 0,
                                                                                "QMDescriptorNumberOfEntries": 0,
                                                                                "QMDescriptor": [

                                                                                ],
                                                                                "MultiAPSteering": {
                                                                                        "BlacklistAttempts": 0,
                                                                                        "BTMAttempts": 0,
                                                                                        "BTMQueryResponses": 0
                                                                                },
                                                                                "STAList": [

                                                                                ]
                                                                        }
                                                                ],
                                                                "UnassociatedSTA": [

                                                                ],
                                                                "MultiAPRadio": {

                                                                }
                                                        },
                                                        {
                                                                "ID": "RNQ350W+",
                                                                "Enabled": "true",
                                                                "Noise": 60,
                                                                "Utilization": 61,
                                                                "Transmit": 5,
                                                                "ReceiveSelf": 0,
                                                                "ReceiveOther": 38,
                                                                "TrafficSeparationCombinedFronthaul": false,
                                                                "TrafficSeparationCombinedBackhaul": false,
                                                                "SteeringPolicy": 0,
                                                                "ChannelUtilizationThreshold": 0,
                                                                "RCPISteeringThreshold": 0,
                                                                "STAReportingRCPIThreshold": 0,
                                                                "STAReportingRCPIHysteresisMarginOverride": 0,
                                                                "ChannelUtilizationReportingThreshold": 0,
                                                                "AssociatedSTATrafficStatsInclusionPolicy": "TODO bool",
                                                                "AssociatedSTALinkMetricsInclusionPolicy": "TODO bool",
                                                                "ChipsetVendor": "0x14e4",
                                                                "APMetricsWiFi6": "TODO bool",
                                                                "CurrentOperatingClassProfileNumberOfEntries": 1,
                                                                "UnassociatedSTANumberOfEntries": 0,
                                                                "BSSNumberOfEntries": 2,
                                                                "ScanResultNumberOfEntries": 0,
                                                                "DisAllowedOpClassChannelsNumberOfEntries": 0,
                                                                "ScanResult": [

                                                                ],
                                                                "BackhaulSta": {
                                                                        "MACAddress": "44:d4:37:e7:45:be"
                                                                },
                                                                "ScanCapability": {
                                                                        "OnBootOnly": false,
                                                                        "Impact": 4,
                                                                        "MinimumInterval": 3,
                                                                        "OpClassChannelsNumberOfEntries": 1,
                                                                        "OpClassChannels": [
                                                                                {
                                                                                        "OpClass": 81,
                                                                                        "ChannelList": [

                                                                                        ]
                                                                                }
                                                                        ]
                                                                },
                                                                "CACCapability": {
                                                                        "CACMethodNumberOfEntries": 0,
                                                                        "CACMethod": [

                                                                        ]
                                                                },
                                                                "Capabilities": {
                                                                        "HTCapabilities": "WA==",
                                                                        "VHTCapabilities": "AAAAAAAA",
                                                                        "CapableOperatingClassProfileNumberOfEntries": 3,
                                                                        "AKMFrontHaulNumberOfEntries": 0,
                                                                        "AKMBackhaulNumberOfEntries": 0,
                                                                        "WiFi6APRole": {
                                                                                "HE160": false,
                                                                                "HE8080": false,
                                                                                "MCSNSS": "+v/6/w==",
                                                                                "SUBeamformer": true,
                                                                                "SUBeamformee": true,
                                                                                "MUBeamformer": true,
                                                                                "Beamformee80orLess": true,
                                                                                "BeamformeeAbove80": false,
                                                                                "ULMUMIMO": false,
                                                                                "ULOFDMA": false,
                                                                                "MaxDLMUMIMO": 0,
                                                                                "MaxULMUMIMO": 0,
                                                                                "MaxDLOFDMA": 0,
                                                                                "MaxULOFDMA": 0,
                                                                                "RTS": false,
                                                                                "MURTS": false,
                                                                                "MultiBSSID": false,
                                                                                "MUEDCA": false,
                                                                                "TWTRequestor": false,
                                                                                "TWTResponder": true,
                                                                                "SpatialReuse": false,
                                                                                "AnticipatedChannelUsage": false
                                                                        },
                                                                        "WiFi6bSTARole": {
                                                                                "HE160": false,
                                                                                "HE8080": false,
                                                                                "MCSNSS": "AAAAAA==",
                                                                                "SUBeamformer": false,
                                                                                "SUBeamformee": false,
                                                                                "MUBeamformer": false,
                                                                                "Beamformee80orLess": false,
                                                                                "BeamformeeAbove80": false,
                                                                                "ULMUMIMO": false,
                                                                                "ULOFDMA": false,
                                                                                "MaxDLMUMIMO": 0,
                                                                                "MaxULMUMIMO": 0,
                                                                                "MaxDLOFDMA": 0,
                                                                                "MaxULOFDMA": 0,
                                                                                "RTS": false,
                                                                                "MURTS": false,
                                                                                "MultiBSSID": false,
                                                                                "MUEDCA": false,
                                                                                "TWTRequestor": false,
                                                                                "TWTResponder": false,
                                                                                "SpatialReuse": false,
                                                                                "AnticipatedChannelUsage": false
                                                                        },
                                                                        "AKMFrontHaul": [

                                                                        ],
                                                                        "AKMBackhaul": [

                                                                        ],
                                                                        "CapableOperatingClassProfile": [
                                                                                {
                                                                                        "Class": 81,
                                                                                        "MaxTxPower": 20,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 83,
                                                                                        "MaxTxPower": 20,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                },
                                                                                {
                                                                                        "Class": 84,
                                                                                        "MaxTxPower": 20,
                                                                                        "NonOperable": [

                                                                                        ],
                                                                                        "NumberOfNonOperChan": 0
                                                                                }
                                                                        ]
                                                                },
                                                                "CurrentOperatingClassProfile": [
                                                                        {
                                                                                "Class": 81,
                                                                                "Channel": 11,
                                                                                "TxPower": 20,
                                                                                "TransmitPowerLimit": 0,
                                                                                "TimeStamp": "1970-01-01T03:44:38+01:00"
                                                                        }
                                                                ],
                                                                "DisAllowedOpClassChannels": [

                                                                ],
                                                                "SpatialReuse": {
                                                                        "PartialBSSColor": 0,
                                                                        "BSSColor": 0,
                                                                        "HESIGASpatialReuseValue15Allowed": false,
                                                                        "SRGInformationValid": false,
                                                                        "NonSRGOffsetValid": false,
                                                                        "PSRDisallowed": false,
                                                                        "NonSRGOBSSPDMaxOffset": 0,
                                                                        "SRGOBSSPDMinOffset": 0,
                                                                        "SRGOBSSPDMaxOffset": 0,
                                                                        "SRGBSSColorBitmap": "0000000000000000",
                                                                        "SRGPartialBSSIDBitmap": "0000000000000000",
                                                                        "NeighborBSSColorInUseBitmap": "0000000000000000"
                                                                },
                                                                "BSSList": [
                                                                        {
                                                                                "BSSID": "fa:d4:37:e7:45:b0",
                                                                                "SSID": "MAP-AC919BB703E8-BH",
                                                                                "Enabled": "true",
                                                                                "LastChange": 0,
                                                                                "TimeStamp": "2024-04-08T16:54:43+01:00",
                                                                                "UnicastBytesSent": 0,
                                                                                "UnicastBytesReceived": 0,
                                                                                "MulticastBytesSent": 15,
                                                                                "MulticastBytesReceived": 0,
                                                                                "BroadcastBytesSent": 1,
                                                                                "BroadcastBytesReceived": 0,
                                                                                "ByteCounterUnits": 0,
                                                                                "Profile1bSTAsDisallowed": "TODO bool",
                                                                                "Profile2bSTAsDisallowed": "TODO bool",
                                                                                "AssociationAllowanceStatus": 0,
                                                                                "EstServiceParametersBE": "TODO base64(0:3)",
                                                                                "EstServiceParametersBK": "TODO base64(0:3)",
                                                                                "EstServiceParametersVI": "TODO base64(0:3)",
                                                                                "EstServiceParametersVO": "TODO base64(0:3)",
                                                                                "BackhaulUse": true,
                                                                                "FronthaulUse": false,
                                                                                "R1disallowed": true,
                                                                                "R2disallowed": false,
                                                                                "MultiBSSID": false,
                                                                                "TransmittedBSSID": false,
                                                                                "FronthaulAKMsAllowed": [

                                                                                ],
                                                                                "BackhaulAKMsAllowed": [

                                                                                ],
                                                                                "STANumberOfEntries": 0,
                                                                                "QMDescriptorNumberOfEntries": 0,
                                                                                "QMDescriptor": [

                                                                                ],
                                                                                "MultiAPSteering": {
                                                                                        "BlacklistAttempts": 0,
                                                                                        "BTMAttempts": 0,
                                                                                        "BTMQueryResponses": 0
                                                                                },
                                                                                "STAList": [

                                                                                ]
                                                                        },
                                                                        {
                                                                                "BSSID": "fa:d4:37:e7:45:bf",
                                                                                "SSID": "IOPSYS-AC919BB703E8",
                                                                                "Enabled": "true",
                                                                                "LastChange": 0,
                                                                                "TimeStamp": "2024-04-08T16:54:43+01:00",
                                                                                "UnicastBytesSent": 0,
                                                                                "UnicastBytesReceived": 0,
                                                                                "MulticastBytesSent": 13,
                                                                                "MulticastBytesReceived": 0,
                                                                                "BroadcastBytesSent": 1,
                                                                                "BroadcastBytesReceived": 0,
                                                                                "ByteCounterUnits": 0,
                                                                                "Profile1bSTAsDisallowed": "TODO bool",
                                                                                "Profile2bSTAsDisallowed": "TODO bool",
                                                                                "AssociationAllowanceStatus": 0,
                                                                                "EstServiceParametersBE": "TODO base64(0:3)",
                                                                                "EstServiceParametersBK": "TODO base64(0:3)",
                                                                                "EstServiceParametersVI": "TODO base64(0:3)",
                                                                                "EstServiceParametersVO": "TODO base64(0:3)",
                                                                                "BackhaulUse": false,
                                                                                "FronthaulUse": true,
                                                                                "R1disallowed": false,
                                                                                "R2disallowed": false,
                                                                                "MultiBSSID": false,
                                                                                "TransmittedBSSID": false,
                                                                                "FronthaulAKMsAllowed": [

                                                                                ],
                                                                                "BackhaulAKMsAllowed": [

                                                                                ],
                                                                                "STANumberOfEntries": 0,
                                                                                "QMDescriptorNumberOfEntries": 0,
                                                                                "QMDescriptor": [

                                                                                ],
                                                                                "MultiAPSteering": {
                                                                                        "BlacklistAttempts": 0,
                                                                                        "BTMAttempts": 0,
                                                                                        "BTMQueryResponses": 0
                                                                                },
                                                                                "STAList": [

                                                                                ]
                                                                        }
                                                                ],
                                                                "UnassociatedSTA": [

                                                                ],
                                                                "MultiAPRadio": {

                                                                }
                                                        }
                                                ]
                                        }
                                ]
                        }
                }
        ]
}

```
WiFi STA association and disassociation events in the network are available through the 'event' method.
Example -

```
root@iopsys:~# ubus call wifi.dataelements event
{
	"notification": [
		{
			"eventTime": "2020-10-24T01:09:34+01:00",
			"wfa-dataelements:AssociationEvent": {
				"AssocData": {
					"BSSID": "00:22:07:6b:17:52",
					"MACAddress": "54:b8:02:80:25:e8",
					"StatusCode": 0,
					"HTCapabilities": "AA==\n",
					"VHTCapabilities": "AAAAAAAA\n"
				}
			}
		},
		{
			"eventTime": "2020-10-24T01:10:03+01:00",
			"wfa-dataelements:AssociationEvent": {
				"AssocData": {
					"BSSID": "00:22:07:6b:17:51",
					"MACAddress": "d2:a2:d1:17:27:f7",
					"StatusCode": 0,
					"HTCapabilities": "AA==\n",
					"VHTCapabilities": "AAAAAAAA\n"
				}
			}
		},
		{
			"eventTime": "2020-10-24T01:10:20+01:00",
			"wfa-dataelements:DisassociationEvent": {
				"DisassocData": {
					"BSSID": "00:22:07:6b:17:51",
					"MACAddress": "d2:a2:d1:17:27:f7",
					"ReasonCode": 0,
					"BytesSent": 181625,
					"BytesReceived": 11497,
					"PacketsSent": 1951,
					"PacketsReceived": 105,
					"ErrorsSent": 0,
					"ErrorsReceived": 0,
					"RetransCount": 0
				}
			}
		}
	]
}
```

## Completeness of the WiFi DataElements output

The 'status' command can be used to know which CMDUs are **mandatory** for Data Model
completeness. The EasyMesh CMDUs received by `decollector` alongwith the
timestamps when last received are available in the 'status' output.

For each EasyMesh device, the 'status' field will show either "complete" or "incomplete"
depending on whether `decollector` has seen or not seen the **mandatory** CMDUs
from the EasyMesh device respectively.

Example of 'status' output from two EasyMesh devices connected via WiFi backhaul -

```
root@iopsys:~# ubus call wifi.dataelements status
{
        "state": "idle",
        "refresh_count": 8,
        "refresh_interval": 60,
        "refresh_next": 19,
        "DeviceList": [
                {
                        "macaddr": "ae:91:9b:b7:03:e8",
                        "status": "complete",
                        "cmdu": [
                                {
                                        "type": "TOPOLOGY_RESPONSE",
                                        "applicability": "mandatory",
                                        "last_rxtime": "2024-04-08T16:25:11Z",
                                        "last_rxcnt": 2,
                                        "total_rxcnt": 16,
                                        "total_error": 0
                                },
                                {
                                        "type": "AP_CAPABILITY_REPORT",
                                        "applicability": "mandatory",
                                        "last_rxtime": "2024-04-08T16:25:11Z",
                                        "last_rxcnt": 2,
                                        "total_rxcnt": 16,
                                        "total_error": 0
                                },
                                {
                                        "type": "AP_METRICS_RESPONSE",
                                        "applicability": "mandatory",
                                        "last_rxtime": "2024-04-08T16:25:32Z",
                                        "last_rxcnt": 42,
                                        "total_rxcnt": 476,
                                        "total_error": 0
                                },
                                {
                                        "type": "BACKHAUL_STA_CAPABILITY_REPORT",
                                        "applicability": "conditional",
                                        "last_rxtime": "2024-04-08T16:25:11Z",
                                        "last_rxcnt": 1,
                                        "total_rxcnt": 8,
                                        "total_error": 0
                                },
                                {
                                        "type": "LINK_METRIC_RESPONSE",
                                        "applicability": "mandatory",
                                        "last_rxtime": "1970-01-01T00:00:00Z",
                                        "last_rxcnt": 0,
                                        "total_rxcnt": 3,
                                        "total_error": 25
                                },
                                {
                                        "type": "CLIENT_CAPABILITY_REPORT",
                                        "applicability": "mandatory",
                                        "last_rxtime": "1970-01-01T00:00:00Z",
                                        "last_rxcnt": 0,
                                        "total_rxcnt": 2,
                                        "total_error": 0
                                },
                                {
                                        "type": "AP_AUTOCONFIGURATION_RESPONSE",
                                        "applicability": "mandatory",
                                        "last_rxtime": "1970-01-01T00:00:00Z",
                                        "last_rxcnt": 0,
                                        "total_rxcnt": 18,
                                        "total_error": 0
                                },
                                {
                                        "type": "OPERATING_CHANNEL_REPORT",
                                        "applicability": "mandatory",
                                        "last_rxtime": "2024-04-08T16:25:19Z",
                                        "last_rxcnt": 2,
                                        "total_rxcnt": 11,
                                        "total_error": 0
                                },
                                {
                                        "type": "CHANNEL_SCAN_REPORT",
                                        "applicability": "optional",
                                        "last_rxtime": "1970-01-01T00:00:00Z",
                                        "last_rxcnt": 0,
                                        "total_rxcnt": 0,
                                        "total_error": 0
                                },
                                {
                                        "type": "CHANNEL_PREFERENCE_REPORT",
                                        "applicability": "optional",
                                        "last_rxtime": "2024-04-08T16:25:11Z",
                                        "last_rxcnt": 1,
                                        "total_rxcnt": 4,
                                        "total_error": 0
                                },
                                {
                                        "type": "BEACON_METRICS_RESPONSE",
                                        "applicability": "optional",
                                        "last_rxtime": "1970-01-01T00:00:00Z",
                                        "last_rxcnt": 0,
                                        "total_rxcnt": 0,
                                        "total_error": 0
                                }
                        ]
                },
                {
                        "macaddr": "46:d4:37:e7:45:b0",
                        "status": "complete",
                        "cmdu": [
                                {
                                        "type": "TOPOLOGY_RESPONSE",
                                        "applicability": "mandatory",
                                        "last_rxtime": "2024-04-08T16:25:32Z",
                                        "last_rxcnt": 23,
                                        "total_rxcnt": 134,
                                        "total_error": 0
                                },
                                {
                                        "type": "AP_CAPABILITY_REPORT",
                                        "applicability": "mandatory",
                                        "last_rxtime": "2024-04-08T16:25:11Z",
                                        "last_rxcnt": 2,
                                        "total_rxcnt": 9,
                                        "total_error": 0
                                },
                                {
                                        "type": "AP_METRICS_RESPONSE",
                                        "applicability": "mandatory",
                                        "last_rxtime": "2024-04-08T16:25:33Z",
                                        "last_rxcnt": 40,
                                        "total_rxcnt": 246,
                                        "total_error": 0
                                },
                                {
                                        "type": "BACKHAUL_STA_CAPABILITY_REPORT",
                                        "applicability": "conditional",
                                        "last_rxtime": "2024-04-08T16:25:11Z",
                                        "last_rxcnt": 1,
                                        "total_rxcnt": 4,
                                        "total_error": 0
                                },
                                {
                                        "type": "LINK_METRIC_RESPONSE",
                                        "applicability": "mandatory",
                                        "last_rxtime": "2024-04-08T16:24:53Z",
                                        "last_rxcnt": 1,
                                        "total_rxcnt": 4,
                                        "total_error": 14
                                },
                                {
                                        "type": "CLIENT_CAPABILITY_REPORT",
                                        "applicability": "conditional",
                                        "last_rxtime": "1970-01-01T00:00:00Z",
                                        "last_rxcnt": 0,
                                        "total_rxcnt": 0,
                                        "total_error": 0
                                },
                                {
                                        "type": "AP_AUTOCONFIGURATION_RESPONSE",
                                        "applicability": "optional",
                                        "last_rxtime": "1970-01-01T00:00:00Z",
                                        "last_rxcnt": 0,
                                        "total_rxcnt": 0,
                                        "total_error": 0
                                },
                                {
                                        "type": "OPERATING_CHANNEL_REPORT",
                                        "applicability": "mandatory",
                                        "last_rxtime": "2024-04-08T16:25:28Z",
                                        "last_rxcnt": 2,
                                        "total_rxcnt": 8,
                                        "total_error": 0
                                },
                                {
                                        "type": "CHANNEL_SCAN_REPORT",
                                        "applicability": "optional",
                                        "last_rxtime": "1970-01-01T00:00:00Z",
                                        "last_rxcnt": 0,
                                        "total_rxcnt": 0,
                                        "total_error": 0
                                },
                                {
                                        "type": "CHANNEL_PREFERENCE_REPORT",
                                        "applicability": "optional",
                                        "last_rxtime": "2024-04-08T16:25:28Z",
                                        "last_rxcnt": 1,
                                        "total_rxcnt": 4,
                                        "total_error": 0
                                },
                                {
                                        "type": "BEACON_METRICS_RESPONSE",
                                        "applicability": "optional",
                                        "last_rxtime": "1970-01-01T00:00:00Z",
                                        "last_rxcnt": 0,
                                        "total_rxcnt": 0,
                                        "total_error": 0
                                }
                        ]
                }
        ]
}

```
