# DDNS Manager
DDNS manager is a lightweight program to manage Device.DynamicDNS. TR069 datamodel as per 2.16 version.
This package is dependent on openwrt ddns-script package for the backend job of managing dynamic DNS updation.
We need to create this separate because there is a limitation in ddns-script package that it supports only
one host in every DNS client section in the UCI. Where as datamodel definition allows multiple host under
one DNS client object.
So to achieve the datamodel specification there was one option to patch the openwrt ddns-script package.

We found it not good enough to patch the ddns-script package in openwrt and hence decided to create this
'ddnsmngr' package to achive the datamodel specification.

## Package details
1. In this package we have used bbfdm micro-service mechanism to register the Device.DynamicDNS. datamodel
tree.
2. We have created separate UCI and init script namely "/etc/config/ddnsmngr" and "/etc/init.d/ddnsmngr"
respecively. Datamodel interaction will be with these files rather than the standard ddns-script UCI and
init script.
3. We have added a shell script in this package namely "ddnsmngr_updater.sh" which will spawn one ddns process
for each configured hosts as it is now being done from the standard "dynamic_dns_updater.sh" in the ddns-script
package.
We avoided the patch work in "ddns-script" package by introducing this script.  This script uses apis from the
"dynamic_dns_functions.sh" script in ddns-script package and does the ddns work.

## UCI format
Below is the format of the UCI:
```
config ddnsmngr 'global'
	option configfile '/var/run/ddnsmngr/ddnsmngr.json'
	option ddns_dateformat '%F %R'
	option ddns_rundir '/var/run/ddnsmngr'
	option ddns_logdir '/var/log/ddnsmngr'
	option ddns_loglines '250'
	option upd_privateip '0'
	option use_curl '1'

config client 'client_1'
	option enabled '1'
	option service_name 'dynu.com'
	option interface 'wan'
	option ip_network 'wan'
	option username 'xxxxxx'
	option password 'xxxxxx'
	option use_ipv6 '0'
	option force_ipversion '0'
	option use_https '0'
	option force_dnstcp '0'

config host 'client_1_host_1'
	option enabled '1'
	option dm_parent 'client_1'
	option lookup_host 'device1.loseyourip.com'

config host 'client_1_host_2'
	option enabled '1'
	option dm_parent 'client_1'
	option lookup_host 'device2.loseyourip.com'
```

## How it works
1. The init script of 'ddnsmngr' package parses each host section in the UCI and creates a 
1:1 client-host json configuration in the file mentioned in 'configfile' option of UCI. The
default file is "/var/run/ddnsmngr/ddnsmngr.json".
2. For above UCI config the json configuration would be like:
```
{
  "services": [
    {
      "interface": "wan",
      "service_name": "dynu.com",
      "username": "xxxxxx",
      "password": "xxxxxx",
      "lookup_host": "device1.loseyourip.com",
      "ip_network": "wan",
      "proc_info_file": "client_1_host_1",
      "use_ipv6": "0",
      "force_ipversion": "0",
      "use_https": "0",
      "force_dnstcp": "0"
    },
    {
      "interface": "wan",
      "service_name": "dynu.com",
      "username": "xxxxxx",
      "password": "xxxxxx",
      "lookup_host": "device2.loseyourip.com",
      "ip_network": "wan",
      "proc_info_file": "client_1_host_2",
      "use_ipv6": "0",
      "force_ipversion": "0",
      "use_https": "0",
      "force_dnstcp": "0"
    }
  ]
}
```
3. Init script then calls the "ddnsmngr_updater.sh" script with this json object as an argument.
4. "ddnsmngr_updater.sh" script then validates each object in the "services" array and starts
process for every valid object.

## ddnsmngr_updater.sh VS dynamic_dns_updater.sh
In ddns-script package "dynamic_dns_updater.sh" script spawn processes for every DDNS client
object and every process can take care of a single host.

"ddnsmngr_updater.sh" spawn a separate process for each host and hence every hostname is being
updated by a dedicated process.

## Backend Support
We have analysed several dynamic DNS client packages for the purpose of using as a backend of
this ddnsmngr package, out of which "ddns-script" and "inadyn" are the two packages we have
found suitable for the implementation.
Below are the details of the packages which were analysed

| Package      | Language | License | Pros/Cons                                        |
| ------------ | -------- | ------- | ------------------------------------------------ |
| Enhanced-duc | C        | NA      | Update URL is hard coded and so a few service provider which uses this url format only work with this package. It also can not support custom providers |
| ddclient     | perl     | GPLv2   | Can not support custom providers at runtime, to add custom providers need to make changes in code |
| ddnsc        | python & REST | GPLv3 | Only a few providers are supported and with this package also custom providers can not be supported at runtime. A python plugin with REST api is need to be written for every custom providers |
| ndyndns      | C        | BSD     | Only supports DynDNS and Namecheap providers. Also this package is no longer in development or maintenance |
| inadyn       | C        | GPLv2   | Custom providers can be added at runtime. It is available in openwrt_package. It do not rely on DNS to identify if an update is required and supports multiple hostname configuration. We need to do some changes in its logging mechanism |
| ddns-script  | Shell    |         | Custom providers can be added at runtime. It is also available in openwrt_package. It does rely on DNS to identify if an update is required. Do not support multiple hostname but with some alternative implementation mutiple host can be supported |
