# UCI schema

<tbody>
  <tr>
    <td colspan="2">
      <div style="font-weight: bold;">bulkdata</div>
      <table style="width: 100%;">
        <tbody>
          <tr>
            <td><div style="font-weight: bold; font-size: 14px;">section</div></td>
            <td><div style="font-weight: bold; font-size: 14px;">description</div></td>
            <td><div style="font-weight: bold; font-size: 14px;">multi</div></td>
            <td><div style="font-weight: bold; font-size: 14px;">options</div></td>
          </tr>
          <tr>
            <td class="td_row_even"><div class="td_row_even">bulkdata</div></td>
            <td class="td_row_even"><div class="td_row_even">Configure the bulkdata parameters</div></td>
            <td class="td_row_even"><div class="td_row_even">false</div></td>
            <td class="td_row_even">
              <table style="width: 100%;">
                <tbody>
                  <tr>
                    <td><div style="font-weight: bold; font-size: 14px;">name</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">type</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">required</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">default</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">description</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">enable</div></td>
                    <td class="td_row_even"><div class="td_row_even">boolean</div></td>
                    <td class="td_row_even"><div class="td_row_even">yes</div></td>
                    <td class="td_row_even"><div class="td_row_even">0</div></td>
                    <td class="td_row_even"><div class="td_row_even">If set to <b>1</b>, bulkdata feature will be enabled</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">log_level</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">integer</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">3</div></td>
                    <td class="td_row_odd">
		      <div class="td_row_odd">
		        Specifies the log type to use. Supported values are:
			<table>
			  <tr>
			    <td> value </td>
			    <td> type </td>
			  <tr>
			  <tr>
			    <td> 1 </td>
			    <td> ERROR </td>
			  </tr>
			  <tr>
			    <td> 2 </td>
			    <td> WARNING </td>
			  </tr>
			  <tr>
			    <td> 3 </td>
			    <td> INFO </td>
			  </tr>
			  <tr>
			    <td> 4 </td>
			    <td> DEBUG </td>
			  </tr>
			</table>
		      </div>
		    </td>
                  </tr>
                </tbody>
              </table>
            </td>
          </tr>
          <tr>
            <td class="td_row_odd"><div class="td_row_odd">profile</div></td>
            <td class="td_row_odd"><div class="td_row_odd">Configure bulkdata profile</div></td>
            <td class="td_row_odd"><div class="td_row_odd">true</div></td>
            <td class="td_row_odd">
              <table style="width: 100%;">
                <tbody>
                  <tr>
                    <td><div style="font-weight: bold; font-size: 14px;">name</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">type</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">required</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">default</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">description</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">enable</div></td>
                    <td class="td_row_even"><div class="td_row_even">boolean</div></td>
                    <td class="td_row_even"><div class="td_row_even">yes</div></td>
                    <td class="td_row_even"><div class="td_row_even">0</div></td>
                    <td class="td_row_even"><div class="td_row_even">If set to <b>1</b>, bulkdata will enable this profile</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">name</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">string</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd"><div class="td_row_odd">The name of the profile</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">nbre_of_retained_failed_reports</div></td>
                    <td class="td_row_even"><div class="td_row_even">integer</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even"><div class="td_row_even">The number of failed reports to be retained and transmitted at the end of current reporting interval</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">protocol</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">string</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd"><div class="td_row_odd">The protocol used for the collection profile</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">encoding_type</div></td>
                    <td class="td_row_even"><div class="td_row_even">string</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even"><div class="td_row_even">The encoding type used for the collection profile</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">reporting_interval</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">uinteger</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd"><div class="td_row_odd">The reporting interval in seconds</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">time_reference</div></td>
                    <td class="td_row_even"><div class="td_row_even">integer</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even"><div class="td_row_even">The time reference to determine when the profile will be transmitted to the ACS collector</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">csv_encoding_field_seperator</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">string</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd"><div class="td_row_odd">The field separator to use when encoding CSV data</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">csv_encoding_row_seperator</div></td>
                    <td class="td_row_even"><div class="td_row_even">string</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even"><div class="td_row_even">The row separator to use when encoding CSV data</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">csv_encoding_escape_character</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">string</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd"><div class="td_row_odd">The escape character to use when encoding CSV data</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">csv_encoding_report_format</div></td>
                    <td class="td_row_even"><div class="td_row_even">string</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even">
		      <div class="td_row_even">
		        Describes how reports will be formatted. Two possible formats are supported:
			<table>
			<tr><td>ParameterPerRow</td></tr>
			<tr><td>ParameterPerColumn</td></tr>
			</table>
		      </div>
		    </td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">csv_encoding_row_time_stamp</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">string</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd">
		      <div class="td_row_odd">
		        The format of the timestamp to use for data inserted into the row. The row time stamp supported are:
			<table>
			<tr><td>Unix-Epoch</td></tr>
			<tr><td>ISO-8601</td></tr>
			<tr><td>None</td></tr>
			</table>
		      </div>
		    </td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">json_encoding_report_format</div></td>
                    <td class="td_row_even"><div class="td_row_even">string</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even">
		      <div class="td_row_even">
		        Describes the report format. The supported report formats are:
			<table>
			<tr><td>ObjectHierarchy</td></tr>
			<tr><td>NameValuePair</td></tr>
			</table>
		      </div>
		    </td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">json_encoding_report_time_stamp</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">string</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd">
		      <div class="td_row_odd">
		        The format of the timestamp to use for the JSON Object named "CollectionTime". The supported timestamp are:
			<table>
			<tr><td>Unix-Epoch</td></tr>
			<tr><td>ISO-8601</td></tr>
			<tr><td>None</td></tr>
			</table>
		      </div>
		    </td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">http_url</div></td>
                    <td class="td_row_even"><div class="td_row_even">string</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even"><div class="td_row_even">The URL of the collection server</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">http_username</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">string</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd"><div class="td_row_odd">The username of the collection server</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">http_password</div></td>
                    <td class="td_row_even"><div class="td_row_even">string</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even"><div class="td_row_even">The password of the collection server</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">http_compression</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">string</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd">
		      <div class="td_row_odd">
		        The HTTP Compression mechanism used by the collection server. The supported compression mechanism are:
			<table>
			<tr><td>GZIP</td></tr>
			<tr><td>Compress</td></tr>
			<tr><td>Deflate</td></tr>
			</table>
		      </div>
		    </td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">http_method</div></td>
                    <td class="td_row_even"><div class="td_row_even">string</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even">
		      <div class="td_row_even">
		        The HTTP method used by the collection server. Two methods are supported:
			<table>
			<tr><td>POST</td></tr>
			<tr><td>PUT</td></tr>
			</table>
		      </div>
		    </td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">http_use_date_header</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">string</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd"><div class="td_row_odd">If set to 1, the CPE encodes the HTTP Date Header</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">http_retry_enable</div></td>
                    <td class="td_row_even"><div class="td_row_even">boolean</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even">0</div></td>
                    <td class="td_row_even"><div class="td_row_even">If set to 1, the CPE retries unsuccessful attempts to transfer data</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">http_retry_minimum_wait_interval</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">integer</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd"><div class="td_row_odd">The data transfer retry wait interval</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">http_retry_interval_multiplier</div></td>
                    <td class="td_row_even"><div class="td_row_even">integer</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even"><div class="td_row_even">The retry interval multiplier</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">http_persist_across_reboot</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">boolean</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">0</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">If set to 1, failed data transfers must be persisted across reboots</div></td>
                  </tr>
                </tbody>
              </table>
            </td>
          </tr>
          <tr>
            <td class="td_row_even"><div class="td_row_even">profile_parameter</div></td>
            <td class="td_row_even"><div class="td_row_even">Configure the bulkdata profile parameters</div></td>
            <td class="td_row_even"><div class="td_row_even">true</div></td>
            <td class="td_row_even">
              <table style="width: 100%;">
                <tbody>
                  <tr>
                    <td><div style="font-weight: bold; font-size: 14px;">name</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">type</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">required</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">default</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">description</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">dm_parent</div></td>
                    <td class="td_row_even"><div class="td_row_even">string</div></td>
                    <td class="td_row_even"><div class="td_row_even">yes</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even"><div class="td_row_even">The profile name of the used profile</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">name</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">string</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd"><div class="td_row_odd">The name of the profile parameter</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">reference</div></td>
                    <td class="td_row_even"><div class="td_row_even">string</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even"><div class="td_row_even">The reference of the profile parameter</div></td>
                  </tr>
                </tbody>
              </table>
            </td>
          </tr>
          <tr>
            <td class="td_row_odd"><div class="td_row_odd">profile_http_request_uri_parameter</div></td>
            <td class="td_row_odd"><div class="td_row_odd">Configure the bulkdata profile HTTP request URI parameters</div></td>
            <td class="td_row_odd"><div class="td_row_odd">true</div></td>
            <td class="td_row_odd">
              <table style="width: 100%;">
                <tbody>
                  <tr>
                    <td><div style="font-weight: bold; font-size: 14px;">name</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">type</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">required</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">default</div></td>
                    <td><div style="font-weight: bold; font-size: 14px;">description</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">dm_parent</div></td>
                    <td class="td_row_even"><div class="td_row_even">string</div></td>
                    <td class="td_row_even"><div class="td_row_even">yes</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even"><div class="td_row_even">The profile name of the used profile</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_odd"><div class="td_row_odd">name</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">string</div></td>
                    <td class="td_row_odd"><div class="td_row_odd">no</div></td>
                    <td class="td_row_odd"><div class="td_row_odd"></div></td>
                    <td class="td_row_odd"><div class="td_row_odd">The name of the Request-URI parameter</div></td>
                  </tr>
                  <tr>
                    <td class="td_row_even"><div class="td_row_even">reference</div></td>
                    <td class="td_row_even"><div class="td_row_even">string</div></td>
                    <td class="td_row_even"><div class="td_row_even">no</div></td>
                    <td class="td_row_even"><div class="td_row_even"></div></td>
                    <td class="td_row_even"><div class="td_row_even">The reference of the profile parameter</div></td>
                  </tr>
                </tbody>
              </table>
            </td>
          </tr>
        </tbody>
      </table>
    </td>
  </tr>
</tbody>
