# Bulk Data

bulkdatad is an implementation of The HTTP bulk data collection mechanism which is an extended feature of CPE and other agents implementing TR-069(CWMP) or TR-369(USP), defined by the Broadband Forum. It provides a means by which an Auto-Configuration Server (ACS), or USP Controller, can configure an agent to periodically send a JSON or CSV formatted set of Device information to an HTTP server running a data collection application.

## Configuration File

The bulkdatad UCI configuration is located in **'/etc/config/bulkdata'**, and contains 4 sections: **bulkdata**, **profile**, **profile\_parameter** and **profile\_http\_request\_uri\_parameter**.

```
config bulkdata 'bulkdata'
	option enable '0'
	#Log levels: Error=1, Warning=2, Info=3, Debug=4
	option log_level '3'

config profile 'profile_1'
	option enable '0'
	option csv_encoding_row_time_stamp 'Unix-Epoch'
	option json_encoding_report_time_stamp 'Unix-Epoch'
	option http_retry_minimum_wait_interval '5'
	option http_retry_interval_multiplier '2000'

config profile_parameter 'profile_param_1'
	option dm_parent 'profile_1'
	option name ''
	option reference ''

config profile_http_request_uri_parameter 'profile_uri_param_1'
	option dm_parent 'profile_1'
	option name ''
	option reference ''
```

> For more detail about UCI parameters please see the [link](./docs/guide/uci_param.md) and for UCI schema [link](./docs/api/uci/bulkdata.md)

## Dependencies

To successfully build bulkdatad, the following libraries are needed:

| Dependency  | Link                                        | License        |
| ----------- | ------------------------------------------- | -------------- |
| libuci      | https://git.openwrt.org/project/uci.git     | LGPL 2.1       |
| libubox     | https://git.openwrt.org/project/libubox.git | BSD            |
| libjson-c   | https://s3.amazonaws.com/json-c_releases    | MIT            |
| libcurl     | https://dl.uxnr.de/mirror/curl              | MIT            |
