/*
 * config.c - common utility functions
 *
 * Copyright (C) 2022-2024, IOPSYS Software Solutions AB.
 *
 * Author: Amin Ben Romdhane <amin.benromdhane@iopsys.eu>
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <time.h>
#include <libubox/uloop.h>

typedef struct device_id {
	char *manufacturer_oui;
	char *product_class;
	char *serial_number;
	int retries;
	struct uloop_timeout dtimer; // collection timer
} device_data;

typedef struct profile_parameter {
	char *name;
	char *reference;
	struct ubus_request *req;
	struct list_head *results;
} profile_parameter;

typedef struct profile_http_request_uri_parameter {
	char *name;
	char *reference;
	struct ubus_request *req;
	char *value;
} profile_http_request_uri_parameter;

typedef struct profile {
	struct uloop_timeout utimer; // collection timer
	struct uloop_timeout ctimer; // async cancel timer
	int nbre_of_retained_failed_reports;
	int nbre_failed_reports;
	int reporting_interval;
	int profile_parameter_number;
	int profile_http_request_uri_parameter_number;
	int http_retry_minimum_wait_interval;
	int http_retry_interval_multiplier;
	int min_retry;
	int retry_count;
	char *profile_name;
	char *protocol;
	char *encoding_type;
	char *csv_encoding_field_separator;
	char *csv_encoding_row_separator;
	char *csv_encoding_escape_character;
	char *csv_encoding_report_format;
	char *csv_encoding_row_time_stamp;
	char *json_encoding_report_format;
	char *json_encoding_report_time_stamp;
	char *http_url;
	char *http_username;
	char *http_password;
	char *http_compression;
	char *http_method;
	char *new_report;
	time_t collection_time;
	time_t time_reference;
	time_t next_retry;
	time_t next_period;
	bool http_persist_across_reboot;
	bool http_use_date_header;
	bool http_retry_enable;
	struct profile_parameter *profile_parameter;
	struct profile_http_request_uri_parameter *profile_http_uri_parameter;
	struct list_head *failed_reports;
} profile;

typedef struct bulkdata {
	bool enable;
	struct profile *profile;
	int profile_number;
} bulkdata;

void bulkdata_config_init(struct bulkdata *bulkdata, struct device_id *device_id);
void bulkdata_config_fini(struct bulkdata *bulkdata);

#endif //__CONFIG_H





