/*
 * buci.h - uci utilities
 *
 * Copyright (C) 2021-2024, IOPSYS Software Solutions AB.
 *
 * Author: Amin Ben Romdhane <amin.benromdhane@iopsys.eu>
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef __BUCI_H
#define __BUCI_H

#include <uci.h>

int buci_init(void);
int buci_fini(void);
struct uci_section *buci_walk_section(const char *package, const char *section_type, struct uci_section *prev_section);
char *buci_get_value_bysection(struct uci_section *section, const char *option);
char *buci_get_value(const char *package, const char *section, const char *option);
void buci_set_value_varstate(const char *uci_param, const char *value);

#define buci_foreach_section(package, section_type, section) \
	for (section = buci_walk_section(package, section_type, NULL); \
		section != NULL; \
		section = buci_walk_section(package, section_type, section))

#endif //__BUCI_H
