# UCI configurations

```
config bulkdata 'bulkdata'
	option enable '0'
	#Log levels: Error=1, Warning=2, Info=3, Debug=4
	option log_level '3'

config profile 'profile_1'
	option enable '0'
	option csv_encoding_row_time_stamp 'Unix-Epoch'
	option json_encoding_report_time_stamp 'Unix-Epoch'
	option http_retry_minimum_wait_interval '5'
	option http_retry_interval_multiplier '2000'

config profile_parameter 'profile_param_1'
	option dm_parent 'profile_1'
	option name ''
	option reference ''

config profile_http_request_uri_parameter 'profile_uri_param_1'
	option dm_parent 'profile_1'
	option name ''
	option reference ''
```

### bulkdata section

It defines **bulkdata configuration**: enable and log\_level.

| Name        |  Type   | Description                                                                                     |
| ----------- | ------- | ----------------------------------------------------------------------------------------------- |
| `enable`    | boolean | Enables the BulkData feature if set to **1**.                                                     |
| `log_level` | integer | Specifies the log type to use, by default **'INFO'**. The possible types are **'EMERG', 'ALERT', 'CRITIC' ,'ERROR', 'WARNING', 'NOTICE', 'INFO' and 'DEBUG'**. |

### profile section

It defines **the profile section configuration**: enable, name,... The possible options for **profile** section are listed below:

| Name                               |  Type   | Description                                    |
| ---------------------------------- | ------- | ---------------------------------------------- |
| `enable`                           | boolean | If set to **1**, enables the bulkdata profile. |
| `name`                             | string  | The name of the profile. |
| `nbre_of_retained_failed_reports`  | integer | The number of failed reports to be retained and transmitted at the end of the current reporting interval. |
| `protocol`                         | string  | The protocol used for the collection profile. |
| `encoding_type`                    | string  | The encoding type used for the collection profile. |
| `reporting_interval`               | integer | The reporting interval in seconds. |
| `time_reference`                   | integer | The time reference to determine when the profile will be transmitted to the ACS collector. |
| `csv_encoding_field_separator`     | string  | The field separator to use when encoding CSV data. |
| `csv_encoding_row_separator`       | string  | The row separator to use when encoding CSV data. |
| `csv_encoding_escape_character`    | string  | The escape character to use when encoding CSV data. |
| `csv_encoding_report_format`       | string  | Describes how reports will be formatted. Two possible formats are supported: **'ParameterPerRow' and 'ParameterPerColumn'**. |
| `csv_encoding_row_time_stamp`      | string  | The format of the timestamp to use for data inserted into the row. The row time stamp supported are **'Unix-Epoch', 'ISO-8601' and 'None'**. |
| `json_encoding_report_format`      | string  | Describes the report format. The supported report formats are **'ObjectHierarchy' and 'NameValuePair'**. |
| `json_encoding_report_time_stamp`  | string  | The format of the timestamp to use for the JSON Object named "CollectionTime". The supported timestamp are **'Unix-Epoch', 'ISO-8601' and 'None'**. |
| `http_url`                         | string  | The URL of the collection server. |
| `http_username`                    | string  | The username of the collection server. |
| `http_password`                    | string  | The password of the collection server. |
| `http_compression`                 | string  | The HTTP Compression mechanism used by the collection server. The supported compression mechanism are **'GZIP', 'Compress' and 'Deflate'**. |
| `http_method`                      | string  | The HTTP method used by the collection server. Two methods are supported: **'POST' and 'PUT'**. |
| `http_use_date_header`             | boolean | If set to **1**, the CPE encodes the HTTP Date Header. |
| `http_retry_enable`                | boolean | If set to **1**, the CPE retries unsuccessful attempts to transfer data. |
| `http_retry_minimum_wait_interval` | integer | The data transfer retry wait interval. |
| `http_retry_interval_multiplier`   | integer | The retry interval multiplier. |
| `http_persist_across_reboot`       | boolean | If set to **1**, failed data transfers must be persisted across reboots. |

### profile_parameter section

It defines **the profile\_parameter section configuration**: profile\_id, name, reference.

| Name         |  Type   | Description                             |
| ------------ | ------- | --------------------------------------- |
| `dm_parent` | string | The profile name of the used profile.             |
| `name`       | string  | The name of the profile parameter.      |
| `reference`  | string  | The reference of the profile parameter. |

### profile_http_request_uri_parameter section

It defines **the profile\_http\_request\_uri\_parameter section configuration**: profile\_id, name, reference.

| Name         |  Type   | Description                             |
| ------------ | ------- | --------------------------------------- |
| `dm_parent` | string | The profile name of the used profile.             |
| `name`       | string  | The name of the Request-URI parameter.  |
| `reference`  | string  | The reference of the profile parameter. |

> Note: For UCI schema click [here](../api/uci/bulkdata.md) and for raw schema click [here](https://dev.iopsys.eu/iopsys/bulkdata/-/tree/devel/schema/uci.json)
