/*
 * Copyright (c) 2025 Genexis B.V. All rights reserved.
 *
 * This Software and its content are protected by the Dutch Copyright Act
 * ('Auteurswet'). All and any copying and distribution of the software
 * and its content without authorization by Genexis B.V. is
 * prohibited. The prohibition includes every form of reproduction and
 * distribution.
 *
 */

export const bridgePortTypeMap = [
    { portType: 'ProviderNetworkPort', devType: '8021ad' },
    { portType: 'CustomerVLANPort', devType: '8021q' },
    { portType: 'CustomerEdgePort', devType: '8021q' },
    { portType: 'CustomerNetworkPort', devType: '8021q' },
    { portType: 'VLANUnawarePort', devType: '' }
];

export function getBridgePortType(devType) {
    const mapping = bridgePortTypeMap.find(map => map.devType === devType);
    return mapping ? mapping.portType : null;
}

export function getBridgeDeviceType(portType) {
    const mapping = bridgePortTypeMap.find(map => map.portType === portType);
    return mapping ? mapping.devType : '';
}

export function getDefaultTPID(deviceType) {
    switch (deviceType) {
        case '8021q':
            return '33024';
        case '8021ad':
            return '34984';
        default:
            return '37120';
    }
}

export function getTPIDFromDeviceType(deviceType, explicitTPID) {
    // If explicit TPID is set, use it
    if (explicitTPID && explicitTPID !== '') {
        return parseInt(explicitTPID, 10);
    }

    // Default TPID based on device type
    switch (deviceType) {
        case '8021q':
            return 33024;
        case '8021ad':
            return 34984;
        default:
            return 37120;
    }
}
