#!/bin/bash

echo "Install dependencies"
ROOT="${PWD}"

source ./gitlab-ci/shared.sh

# install bbfdm
install_bbfdm

# compile
echo "build stage"
cd ${ROOT}/src/

# with driver level vlans backend
echo "Compiling datamodel library (driver level vlan backend)"
echo ""
CFLAGS="-DBBF_VENDOR_PREFIX=\\\"X_IOWRT_EU_\\\"" make all
if [ $? -ne 0 ]; then
	echo "Failed to compile datamodel library (driver level vlan backend)"
	exit 1
fi

# clean and then compile with bridge-vlan backend
echo ""
echo "clean"
echo ""
make clean

echo ""
echo "Compiling datamodel library (bridge-vlan backend)"
echo ""
CFLAGS="-DBBF_VENDOR_PREFIX=\\\"X_IOWRT_EU_\\\" -DBRIDGE_VLAN_BACKEND=\\\"YES\\\"" make all
if [ $? -ne 0 ]; then
	echo "Failed to compile datamodel library (bridge-vlan backend)"
	exit 1
fi