/*
 * Copyright (C) 2024 iopsys Software Solutions AB
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation
 *
 *		Author: Amin Ben Romdhane <amin.benromdhane@iopsys.eu>
 *
 */

#include "common.h"

static void ip___update_child_interfaces(const char *device, const char *option_name, const char *option_value)
{
	struct uci_section *s = NULL;

	if (DM_STRLEN(device) == 0)
		return;

	uci_foreach_option_eq("network", "interface", "device", device, s) {
		dmuci_set_value_by_section(s, option_name, option_value);
	}
}

static void ip___Update_IP_Interface_Layer(const char *path, const char *linker)
{
	struct uci_section *dmmap_s = NULL;

	uci_path_foreach_option_eq(bbfdm, "dmmap_network", "interface", "LowerLayers", path, dmmap_s) {
		struct uci_section *iface_s = NULL;
		char *sec_name = NULL;
		char *instance = NULL;
		char *curr_device = NULL;

		dmuci_get_value_by_section_string(dmmap_s, "ip_int_instance", &instance);
		if (!DM_STRLEN(instance))
			continue;

		dmuci_get_value_by_section_string(dmmap_s, "section_name", &sec_name);
		if (!DM_STRLEN(sec_name))
			continue;

		iface_s = get_origin_section_from_config("network", "interface", sec_name);
		if (!iface_s)
			continue;

		dmuci_get_value_by_section_string(iface_s, "device", &curr_device);

		ip___update_child_interfaces(curr_device, "device", DM_STRLEN(linker) ? linker : section_name(iface_s));
	}
}

void ethernet___Update_Link_Layer(const char *path, const char *linker)
{
	struct uci_section *dmmap_s = NULL;

	char *p = DM_STRRCHR(path, '.');
	if (p) *p = 0;

	uci_path_foreach_option_eq(bbfdm, "dmmap_ethernet", "link", "LowerLayers", path, dmmap_s) {
		char *instance = NULL;
		char curr_path[128] = {0};

		dmuci_get_value_by_section_string(dmmap_s, "link_instance", &instance);
		if (!DM_STRLEN(instance))
			continue;

		dmuci_set_value_by_section(dmmap_s, "device", linker);

		if (match(path, "Device.Bridging.Bridge.*.Port.", 0, NULL)) {
			// Remove unused Interface section created by Bridge Object if it exists
			struct uci_section *s = get_dup_section_in_config_opt("network", "interface", "device", linker);
			dmuci_delete_by_section(s, NULL, NULL);
		}

		snprintf(curr_path, sizeof(curr_path), "Device.Ethernet.Link.%s", instance);

		// Update IP Interface instance if exists
		ip___Update_IP_Interface_Layer(curr_path, linker);
	}
}

bool bridging___is_management_port_instance(struct uci_section *device_sec)
{
	char *mng_port = NULL;

	dmuci_get_value_by_section_string(device_sec, "management", &mng_port);

	return (DM_LSTRCMP(mng_port, "1") == 0);
}
