# Bridge Deployment Scenarios

- Tested on 7.5 XGX-B L2 image.
- This document assumes base Layer2 configuration exists.
- TPID should only be set after VLANPort has been configured, otherwise ethernet port can get wrongly configured.

## Limitations

- Untagged q-in-q is not supported via EasyDM.
- For ProviderBridge, param CVLANcomponents to be set before SVLANcomponent param.
- Only one bridge is allowed in CVLANcomponents as of now.
- For ProviderBridge, 8021ad port should be set in the last.
- Once ProviderBridge has been configured, we cannot change the constituent bridges, for changing, the ProviderBridge has to be deleted and then changes should be done, and ProviderBridge should be created again.

**************************************************************

## 1. Tagged management bridge

### EasyDM

```
start
del EasyDM.Bridge.cpe-1.Port.LAN1
del EasyDM.Bridge.cpe-1.Port.LAN2
del EasyDM.Bridge.cpe-1.Port.LAN3
del EasyDM.Bridge.cpe-1.Port.LAN4
del EasyDM.Bridge.cpe-1.Port.EXT.

set EasyDM.Bridge.cpe-1.Port.WAN.VLANID 100
set EasyDM.Bridge.cpe-1.Port.WAN.Untagged false
commit 
```

### TR-181 data model

```
dmcli -c del Device.IP.Interface.*
dmcli -c del Device.Bridging.Bridge.*
dmcli -c del Device.Ethernet.Link.*
dmcli -c add Device.Bridging.Bridge.
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.1.ManagementPort 1
dmcli -c set Device.Bridging.Bridge.1.Port.2.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.2.ManagementPort 0
dmcli -c set Device.Bridging.Bridge.1.Port.2.LowerLayers Device.Ethernet.Interface.6

dmcli -c add Device.Bridging.Bridge.1.VLAN.
dmcli -c set Device.Bridging.Bridge.1.VLAN.1.VLANID 100
dmcli -c set Device.Bridging.Bridge.1.VLAN.1.Enable 1
dmcli -c add Device.Bridging.Bridge.1.VLANPort.
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.VLAN Device.Bridging.Bridge.1.VLAN.1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.Port Device.Bridging.Bridge.1.Port.2
dmcli -c add Device.Ethernet.Link.
dmcli -c set Device.Ethernet.Link.1.Enable 1
dmcli -c set Device.Ethernet.Link.1.LowerLayers Device.Bridging.Bridge.1.Port.1
dmcli -c add Device.IP.Interface.
dmcli -c set Device.IP.Interface.1.Enable 1
dmcli -c set Device.IP.Interface.1.LowerLayers Device.Ethernet.Link.1
dmcli -c set Device.DHCPv4.Client.1.Enable 1
dmcli -c set Device.DHCPv4.Client.1.Interface Device.IP.Interface.1
```

### UCI

```
config interface 'wan'
	option proto 'dhcp'
	option reqopts '42 43 100 101 121 125 128 132 224 225 226'
	option device 'br-wan'
	option vendorid 'XGX-B,7.5.1beta0,dslforum.org'
	option clientid '01943f0ce18a90'
	option sendopts ' 124:00:00:0D:E9:04:03:75:73:70'
	option macaddr '94:3F:0C:E1:8A:90'

config interface 'wan6'
	option proto 'dhcpv6'
	option device 'br-wan'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'br_wan'
	option name 'br-wan'
	option type 'bridge'
	list ports 'ae_wan.100'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'br_1_port_1'
	option type '8021q'
	option enabled '1'
	option vid '100'
	option ifname 'ae_wan'
	option name 'ae_wan.100'
	option macaddr '94:3F:0C:E1:8A:90'
```

### Simple config test

```
Device gets IP via DHCP:

sh ifconfig br-wan
br-wan    Link encap:Ethernet  HWaddr 94:3F:0C:E1:8A:90  
          inet addr:10.10.10.100  Bcast:10.10.10.255  Mask:255.255.255.0
          inet6 addr: fe80::963f:cff:fee1:8a90/64 Scope:Link
          UP BROADCAST RUNNING MULTICAST  MTU:1500  Metric:1
          RX packets:11 errors:0 dropped:0 overruns:0 frame:0
          TX packets:159 errors:0 dropped:0 overruns:0 carrier:0
          collisions:0 txqueuelen:1000 
          RX bytes:1452 (1.4 KiB)  TX bytes:70532 (68.8 KiB)
```

**************************************************************

## 2. Untagged bridge

### EasyDM
```
start
add EasyDM.Bridge.vlan-untagged
add EasyDM.Bridge.vlan-untagged.Port.LAN1 
add EasyDM.Bridge.vlan-untagged.Port.WAN 
set EasyDM.Bridge.vlan-untagged.Port.WAN.VLANID 200 
set EasyDM.Bridge.vlan-untagged.Port.WAN.Untagged false
commit
```

### TR-181 data model

```
dmcli -c del Device.IP.Interface.*
dmcli -c del Device.Bridging.Bridge.*
dmcli -c del Device.Ethernet.Link.*
dmcli -c add Device.Bridging.Bridge.
dmcli -c set Device.Bridging.Bridge.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Alias vlan-untagged
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.1.ManagementPort 1
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.2.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.2.ManagementPort 0
dmcli -c set Device.Bridging.Bridge.1.Port.2.LowerLayers Device.Ethernet.Interface.1
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.3.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.3.ManagementPort 0
dmcli -c set Device.Bridging.Bridge.1.Port.3.LowerLayers Device.Ethernet.Interface.6
dmcli -c add Device.Bridging.Bridge.1.VLAN.
dmcli -c set Device.Bridging.Bridge.1.VLAN.1.VLANID 200
dmcli -c set Device.Bridging.Bridge.1.VLAN.1.Enable 1
dmcli -c add Device.Bridging.Bridge.1.VLANPort.
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.VLAN Device.Bridging.Bridge.1.VLAN.1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.Port Device.Bridging.Bridge.1.Port.3
dmcli -c set Device.Bridging.Bridge.1.X_IOWRT_EU_VLANFiltering 1
```

### UCI

```
config interface 'iface_br2'
	option device 'br-dev2'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'dev_br2'
	option name 'br-dev2'
	option type 'bridge'
	option bridge_empty '1'
	list ports 'eth0.1'
	list ports 'ae_wan.200'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'br_2_port_1'
	option type '8021q'
	option enabled '1'
	option vid '200'
	option ifname 'ae_wan'
	option name 'ae_wan.200'
	option macaddr '94:3F:0C:E1:8A:90'
```

### Simple config test

```
Client gets IP via DHCP:

ubuntu@Dwan2161:~$ sudo ip addr flush dev eth1
[sudo] password for ubuntu: 
ubuntu@Dwan2161:~$ sudo dhclient eth1 -v
Internet Systems Consortium DHCP Client 4.4.1
Copyright 2004-2018 Internet Systems Consortium.
All rights reserved.
For info, please visit https://www.isc.org/software/dhcp/

Listening on LPF/eth1/aa:00:aa:d8:01:01
Sending on   LPF/eth1/aa:00:aa:d8:01:01
Sending on   Socket/fallback
DHCPREQUEST for 192.168.1.214 on eth1 to 255.255.255.255 port 67 (xid=0x5d4bd6c)
DHCPREQUEST for 192.168.1.214 on eth1 to 255.255.255.255 port 67 (xid=0x5d4bd6c)
DHCPREQUEST for 192.168.1.214 on eth1 to 255.255.255.255 port 67 (xid=0x5d4bd6c)
DHCPDISCOVER on eth1 to 255.255.255.255 port 67 interval 3 (xid=0x81a47e28)
DHCPOFFER of 10.10.20.202 from 10.10.20.1
DHCPREQUEST for 10.10.20.202 on eth1 to 255.255.255.255 port 67 (xid=0x287ea481)
DHCPACK of 10.10.20.202 from 10.10.20.1 (xid=0x81a47e28)
bound to 10.10.20.202 -- renewal in 57 seconds.



ubuntu@Dwan2161:~$ ping 10.10.20.1
PING 10.10.20.1 (10.10.20.1) 56(84) bytes of data.
64 bytes from 10.10.20.1: icmp_seq=1 ttl=64 time=0.727 ms
64 bytes from 10.10.20.1: icmp_seq=2 ttl=64 time=1.05 ms
^C
--- 10.10.20.1 ping statistics ---
2 packets transmitted, 2 received, 0% packet loss, time 1046ms
rtt min/avg/max/mdev = 0.727/0.890/1.053/0.163 ms
```

## 3. Tagged bridge

### EasyDM

```
start
add EasyDM.Bridge.vlan-tagged

add EasyDM.Bridge.vlan-tagged.Port.LAN2 
set EasyDM.Bridge.vlan-tagged.Port.LAN2.VLANID 300 
set EasyDM.Bridge.vlan-tagged.Port.LAN2.Untagged false

add EasyDM.Bridge.vlan-tagged.Port.WAN 
set EasyDM.Bridge.vlan-tagged.Port.WAN.VLANID 300 
set EasyDM.Bridge.vlan-tagged.Port.WAN.Untagged false
commit 
```

### TR-181 data model

```
dmcli -c del Device.IP.Interface.*
dmcli -c del Device.Bridging.Bridge.*
dmcli -c del Device.Ethernet.Link.*

dmcli -c add Device.Bridging.Bridge.
dmcli -c set Device.Bridging.Bridge.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Alias vlan-tagged
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.1.ManagementPort 1
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.2.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.2.ManagementPort 0
dmcli -c set Device.Bridging.Bridge.1.Port.2.LowerLayers Device.Ethernet.Interface.2
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.3.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.3.ManagementPort 0
dmcli -c set Device.Bridging.Bridge.1.Port.3.LowerLayers Device.Ethernet.Interface.6
dmcli -c add Device.Bridging.Bridge.1.VLAN.
dmcli -c set Device.Bridging.Bridge.1.VLAN.1.VLANID 300
dmcli -c set Device.Bridging.Bridge.1.VLAN.1.Enable 1
dmcli -c add Device.Bridging.Bridge.1.VLANPort.
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.VLAN Device.Bridging.Bridge.1.VLAN.1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.Port Device.Bridging.Bridge.1.Port.2
dmcli -c add Device.Bridging.Bridge.1.VLANPort.
dmcli -c set Device.Bridging.Bridge.1.VLANPort.2.Enable 1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.2.VLAN Device.Bridging.Bridge.1.VLAN.1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.2.Port Device.Bridging.Bridge.1.Port.3
```

### UCI

```
config interface 'iface_br3'
	option device 'br-dev3'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'dev_br3'
	option name 'br-dev3'
	option type 'bridge'
	option bridge_empty '1'
	list ports 'eth0.2.300'
	list ports 'ae_wan.300'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'br_3_port_1'
	option type '8021q'
	option enabled '1'
	option vid '300'
	option ifname 'eth0.2'
	option name 'eth0.2.300'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'br_3_port_2'
	option type '8021q'
	option enabled '1'
	option vid '300'
	option ifname 'ae_wan'
	option name 'ae_wan.300'
	option macaddr '94:3F:0C:E1:8A:90'
```

### Simple config test

Client gets IP via DHCP:

```

ubuntu@Dwan2171:~$ sudo dhclient eth1.300 -v
Internet Systems Consortium DHCP Client 4.4.1
Copyright 2004-2018 Internet Systems Consortium.
All rights reserved.
For info, please visit https://www.isc.org/software/dhcp/

Listening on LPF/eth1.300/aa:00:aa:d9:01:01
Sending on   LPF/eth1.300/aa:00:aa:d9:01:01
Sending on   Socket/fallback
DHCPDISCOVER on eth1.300 to 255.255.255.255 port 67 interval 3 (xid=0xb5050149)
DHCPOFFER of 10.10.30.200 from 10.10.30.1
DHCPREQUEST for 10.10.30.200 on eth1.300 to 255.255.255.255 port 67 (xid=0x490105b5)
DHCPACK of 10.10.30.200 from 10.10.30.1 (xid=0xb5050149)
bound to 10.10.30.200 -- renewal in 50 seconds.
```

**************************************************************

## 4. Translated bridge

### EasyDM

```
start
add EasyDM.Bridge.vlan-translated

add EasyDM.Bridge.vlan-translated.Port.LAN3. 
set EasyDM.Bridge.vlan-translated.Port.LAN3.VLANID 4 
set EasyDM.Bridge.vlan-translated.Port.LAN3.Untagged false

add EasyDM.Bridge.vlan-translated.Port.WAN. 
set EasyDM.Bridge.vlan-translated.Port.WAN.VLANID 400 
set EasyDM.Bridge.vlan-translated.Port.WAN.Untagged false
commit 
```

### TR-181 data model

```
dmcli -c del Device.IP.Interface.*
dmcli -c del Device.Bridging.Bridge.*
dmcli -c del Device.Ethernet.Link.*

dmcli -c add Device.Bridging.Bridge.
dmcli -c set Device.Bridging.Bridge.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Alias vlan-translated
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.1.ManagementPort 1
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.2.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.2.ManagementPort 0
dmcli -c set Device.Bridging.Bridge.1.Port.2.LowerLayers Device.Ethernet.Interface.3
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.3.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.3.ManagementPort 0
dmcli -c set Device.Bridging.Bridge.1.Port.3.LowerLayers Device.Ethernet.Interface.6
dmcli -c add Device.Bridging.Bridge.1.VLAN.
dmcli -c set Device.Bridging.Bridge.1.VLAN.1.VLANID 4
dmcli -c set Device.Bridging.Bridge.1.VLAN.1.Enable 1
dmcli -c add Device.Bridging.Bridge.1.VLANPort.
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.VLAN Device.Bridging.Bridge.1.VLAN.1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.Port Device.Bridging.Bridge.1.Port.2
dmcli -c add Device.Bridging.Bridge.1.VLAN.
dmcli -c set Device.Bridging.Bridge.1.VLAN.2.VLANID 400
dmcli -c set Device.Bridging.Bridge.1.VLAN.2.Enable 1
dmcli -c add Device.Bridging.Bridge.1.VLANPort.
dmcli -c set Device.Bridging.Bridge.1.VLANPort.2.Enable 1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.2.VLAN Device.Bridging.Bridge.1.VLAN.2
dmcli -c set Device.Bridging.Bridge.1.VLANPort.2.Port Device.Bridging.Bridge.1.Port.3
```

### UCI

```
config interface 'iface_br4'
	option device 'br-dev4'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'dev_br4'
	option name 'br-dev4'
	option type 'bridge'
	option bridge_empty '1'
	list ports 'eth0.3.4'
	list ports 'ae_wan.400'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'br_4_port_1'
	option type '8021q'
	option enabled '1'
	option vid '4'
	option ifname 'eth0.3'
	option name 'eth0.3.4'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'br_4_port_2'
	option type '8021q'
	option enabled '1'
	option vid '400'
	option ifname 'ae_wan'
	option name 'ae_wan.400'
	option macaddr '94:3F:0C:E1:8A:90'
```

### Simple config test

Client gets IP via DHCP:

```
ubuntu@Dwan2181:~$ sudo dhclient eth1.4 -v
[sudo] password for ubuntu: 
Internet Systems Consortium DHCP Client 4.4.1
Copyright 2004-2018 Internet Systems Consortium.
All rights reserved.
For info, please visit https://www.isc.org/software/dhcp/

Listening on LPF/eth1.4/aa:00:aa:da:01:01
Sending on   LPF/eth1.4/aa:00:aa:da:01:01
Sending on   Socket/fallback
DHCPREQUEST for 10.10.40.200 on eth1.4 to 255.255.255.255 port 67 (xid=0x2c7abf53)
DHCPACK of 10.10.40.200 from 10.10.40.1 (xid=0x53bf7a2c)
Error: ipv4: Address already assigned.
bound to 10.10.40.200 -- renewal in 54 seconds.
ubuntu@Dwan2181:~$ ping 10.10.40.1
PING 10.10.40.1 (10.10.40.1) 56(84) bytes of data.
64 bytes from 10.10.40.1: icmp_seq=1 ttl=64 time=0.930 ms
64 bytes from 10.10.40.1: icmp_seq=2 ttl=64 time=0.724 ms
64 bytes from 10.10.40.1: icmp_seq=3 ttl=64 time=1.02 ms
^C
--- 10.10.40.1 ping statistics ---
3 packets transmitted, 3 received, 0% packet loss, time 2025ms
rtt min/avg/max/mdev = 0.724/0.892/1.023/0.124 ms
```

**************************************************************

## 5. Add another port to translated bridge

### EasyDM

```
start
add EasyDM.Bridge.vlan-tagged.Port.LAN4
set EasyDM.Bridge.vlan-tagged.Port.LAN4.VLANID 5
set EasyDM.Bridge.vlan-tagged.Port.LAN4.Untagged false
commit
```

### TR-181 data model

**NOTE**: assuming there is a bridge present already, for example, a vlan-tagged bridge.

```
dmcli -c add Device.Bridging.Bridge.3.Port.
dmcli -c set Device.Bridging.Bridge.3.Port.4.Enable 1
dmcli -c set Device.Bridging.Bridge.3.Port.4.ManagementPort 0
dmcli -c set Device.Bridging.Bridge.3.Port.4.LowerLayers Device.Ethernet.Interface.4
dmcli -c add Device.Bridging.Bridge.3.VLAN.
dmcli -c set Device.Bridging.Bridge.3.VLAN.2.VLANID 5
dmcli -c set Device.Bridging.Bridge.3.VLAN.2.Enable 1
dmcli -c add Device.Bridging.Bridge.3.VLANPort.
dmcli -c set Device.Bridging.Bridge.3.VLANPort.3.Enable 1
dmcli -c set Device.Bridging.Bridge.3.VLANPort.3.VLAN Device.Bridging.Bridge.1.VLAN.2
dmcli -c set Device.Bridging.Bridge.3.VLANPort.3.Port Device.Bridging.Bridge.1.Port.4
```

### UCI

```
config interface 'iface_br3'
	option device 'br-dev3'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'dev_br3'
	option name 'br-dev3'
	option type 'bridge'
	option bridge_empty '1'
	list ports 'eth0.2.300'
	list ports 'ae_wan.300'
	list ports 'eth3.5'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'br_3_port_1'
	option type '8021q'
	option enabled '1'
	option vid '300'
	option ifname 'eth0.2'
	option name 'eth0.2.300'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'br_3_port_2'
	option type '8021q'
	option enabled '1'
	option vid '300'
	option ifname 'ae_wan'
	option name 'ae_wan.300'
	option macaddr '94:3F:0C:E1:8A:90'

config device 'br_3_port_3'
	option type '8021q'
	option enabled '1'
	option vid '5'
	option ifname 'eth3'
	option name 'eth3.5'
	option macaddr '94:3F:0C:E1:8A:90'
```


### Simple config test

```
Client gets IP via DHCP:

ubuntu@Dwan2191:~$ sudo dhclient eth1.5 -v
[sudo] password for ubuntu: 
Internet Systems Consortium DHCP Client 4.4.1
Copyright 2004-2018 Internet Systems Consortium.
All rights reserved.
For info, please visit https://www.isc.org/software/dhcp/

Listening on LPF/eth1.5/aa:00:aa:db:01:01
Sending on   LPF/eth1.5/aa:00:aa:db:01:01
Sending on   Socket/fallback
DHCPREQUEST for 10.10.30.201 on eth1.5 to 255.255.255.255 port 67 (xid=0x5c2a108e)
DHCPACK of 10.10.30.201 from 10.10.30.1 (xid=0x8e102a5c)
Error: ipv4: Address already assigned.
bound to 10.10.30.201 -- renewal in 38 seconds.
```

**************************************************************


## 6. Q-in-Q transparent bridge

### EasyDM

```
start
add EasyDM.Bridge.qinq-transp
add EasyDM.Bridge.qinq-transp.Port.LAN1.
add EasyDM.Bridge.qinq-transp.Port.WAN.  
set EasyDM.Bridge.qinq-transp.Port.WAN.VLANID 2 
set EasyDM.Bridge.qinq-transp.Port.WAN.VLANType 8021ad
commit 
```

### TR-181 data model

```
dmcli -c del Device.IP.Interface.*
dmcli -c del Device.Bridging.Bridge.*
dmcli -c del Device.Ethernet.Link.*

dmcli -c add Device.Bridging.Bridge.
dmcli -c set Device.Bridging.Bridge.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Alias qinq-transparent
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.1.ManagementPort 1
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.2.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.2.ManagementPort 0
dmcli -c set Device.Bridging.Bridge.1.Port.2.LowerLayers Device.Ethernet.Interface.1
dmcli -c add Device.Bridging.Bridge.1.Port.
dmcli -c set Device.Bridging.Bridge.1.Port.3.Enable 1
dmcli -c set Device.Bridging.Bridge.1.Port.3.ManagementPort 0
dmcli -c set Device.Bridging.Bridge.1.Port.3.LowerLayers Device.Ethernet.Interface.6
dmcli -c add Device.Bridging.Bridge.1.VLAN.
dmcli -c set Device.Bridging.Bridge.1.VLAN.1.VLANID 2
dmcli -c set Device.Bridging.Bridge.1.VLAN.1.Enable 1
dmcli -c add Device.Bridging.Bridge.1.VLANPort.
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.Enable 1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.VLAN Device.Bridging.Bridge.1.VLAN.1
dmcli -c set Device.Bridging.Bridge.1.VLANPort.1.Port Device.Bridging.Bridge.1.Port.3
dmcli -c set Device.Bridging.Bridge.1.Port.3.TPID 34984
```

### UCI

```
config interface 'iface_br2'
	option device 'br-dev2'
	option macaddr '58:00:32:EF:3A:80'

config device 'dev_br2'
	option name 'br-dev2'
	option type 'bridge'
	option bridge_empty '1'
	list ports 'eth0.1'
	list ports 'ae_wan.2'
	option macaddr '58:00:32:EF:3A:80'

config device 'br_2_port_1'
	option type '8021ad'
	option enabled '1'
	option vid '2'
	option ifname 'ae_wan'
	option name 'ae_wan.2'
	option macaddr '58:00:32:EF:3A:80'
```

### Simple config test

Tcpdump on WAN

```
08:18:45.031028 58:00:32:ef:3a:80 > aa:00:aa:cf:01:01, ethertype 802.1Q (0x8100), length 83: vlan 100, p 0, ethertype IPv4, (tos 0x0, ttl 64, id 61660, offset 0, flags [DF], proto UDP (17), length 65)
    10.10.10.100.57479 > 172.30.30.108.53: 8865+ A? analytics.iopsys.eu. (37)
08:18:45.031116 58:00:32:ef:3a:80 > aa:00:aa:cf:01:01, ethertype 802.1Q (0x8100), length 83: vlan 100, p 0, ethertype IPv4, (tos 0x0, ttl 64, id 61661, offset 0, flags [DF], proto UDP (17), length 65)
    10.10.10.100.57287 > 172.30.30.108.53: 47181+ AAAA? analytics.iopsys.eu. (37)
08:18:45.031206 58:00:32:ef:3a:80 > aa:00:aa:cf:01:01, ethertype 802.1Q (0x8100), length 83: vlan 100, p 0, ethertype IPv4, (tos 0x0, ttl 64, id 61662, offset 0, flags [DF], proto UDP (17), length 65)
    10.10.10.100.57287 > 172.30.30.108.53: 47181+ AAAA? analytics.iopsys.eu. (37)
```


PING SUCCESSFUL:

```
ubuntu@Dwan2081:~$ sudo ip addr flush dev eth1
ubuntu@Dwan2081:~$ sudo ifconfig eth1 192.168.2.100/24 up
ubuntu@Dwan2081:~$ ping -I eth1 192.168.2.1
PING 192.168.2.1 (192.168.2.1) from 192.168.2.100 eth1: 56(84) bytes of data.
64 bytes from 192.168.2.1: icmp_seq=1 ttl=64 time=1.37 ms
64 bytes from 192.168.2.1: icmp_seq=2 ttl=64 time=0.753 ms
64 bytes from 192.168.2.1: icmp_seq=3 ttl=64 time=0.722 ms
^C
--- 192.168.2.1 ping statistics ---
3 packets transmitted, 3 received, 0% packet loss, time 2025ms
rtt min/avg/max/mdev = 0.722/0.948/1.369/0.297 ms
ubuntu@Dwan2081:~$ ping -I eth1 192.168.2.1
PING 192.168.2.1 (192.168.2.1) from 192.168.2.100 eth1: 56(84) bytes of data.
64 bytes from 192.168.2.1: icmp_seq=1 ttl=64 time=0.716 ms
64 bytes from 192.168.2.1: icmp_seq=2 ttl=64 time=0.679 ms
64 bytes from 192.168.2.1: icmp_seq=3 ttl=64 time=0.683 ms
^C
--- 192.168.2.1 ping statistics ---
3 packets transmitted, 3 received, 0% packet loss, time 2054ms
rtt min/avg/max/mdev = 0.679/0.692/0.716/0.016 ms
```

**************************************************************

## 7. Q-in-Q Tagged on LAN

### EasyDM

```
start
add EasyDM.Bridge.br2 .Enable=1
add EasyDM.Bridge.br2.Port.LAN1 .VLANID=100
add EasyDM.Bridge.br2.Port.WAN .VLANID=300 .VLANType=8021ad
commit 
```

### TR-181 data model

```
root@XGX-B-580032ef3a80:~# dmcli
Welcome to Genexis DMCLI(v1.9.1)!
Device   : XGX-B Y.112408002B
Firmware : 7.5.1beta0

start
del Device.IP.Interface.*
del Device.Bridging.Bridge.*
del Device.Ethernet.Link.*

add Device.Bridging.Bridge.
add Device.Bridging.Bridge.1.Port.
set Device.Bridging.Bridge.1.Port.1.Enable 1
set Device.Bridging.Bridge.1.Port.1.ManagementPort 1
add Device.Bridging.Bridge.1.Port.
set Device.Bridging.Bridge.1.Port.2.Enable 1
set Device.Bridging.Bridge.1.Port.2.ManagementPort 0
set Device.Bridging.Bridge.1.Port.2.LowerLayers Device.Ethernet.Interface.1

add Device.Bridging.Bridge.1.VLAN.
set Device.Bridging.Bridge.1.VLAN.1.VLANID 100

add Device.Bridging.Bridge.1.VLANPort.
set Device.Bridging.Bridge.1.VLANPort.1.Enable 1
set Device.Bridging.Bridge.1.VLANPort.1.VLAN Device.Bridging.Bridge.1.VLAN.1
set Device.Bridging.Bridge.1.VLANPort.1.Port Device.Bridging.Bridge.1.Port.2

add Device.Bridging.Bridge.
add Device.Bridging.Bridge.2.Port.
set Device.Bridging.Bridge.2.Port.1.Enable 1
set Device.Bridging.Bridge.2.Port.1.ManagementPort 1
add Device.Bridging.Bridge.2.Port.
set Device.Bridging.Bridge.2.Port.2.Enable 1
set Device.Bridging.Bridge.2.Port.2.ManagementPort 0
set Device.Bridging.Bridge.2.Port.2.LowerLayers Device.Ethernet.Interface.6

add Device.Bridging.Bridge.2.VLAN.
set Device.Bridging.Bridge.2.VLAN.1.VLANID 300

add Device.Bridging.Bridge.2.VLANPort.
set Device.Bridging.Bridge.2.VLANPort.1.Enable 1
set Device.Bridging.Bridge.2.VLANPort.1.VLAN Device.Bridging.Bridge.2.VLAN.1
set Device.Bridging.Bridge.2.VLANPort.1.Port Device.Bridging.Bridge.2.Port.2

add Device.Bridging.ProviderBridge.

set Device.Bridging.ProviderBridge.1.CVLANcomponents Device.Bridging.Bridge.1
set Device.Bridging.ProviderBridge.1.SVLANcomponent Device.Bridging.Bridge.2
commit
```

### UCI

```
config interface 'iface_br1'
	option device 'br-dev1'
	option macaddr '58:00:32:EF:3A:80'

config device 'pr_br_1'
	option name 'br-dev1'
	option type 'bridge'
	option bridge_empty '1'
	option macaddr '58:00:32:EF:3A:80'
	list ports 'eth0.1.100'
	list ports 'ae_wan.300.100'

config device 'br_1_port_1'
	option type '8021q'
	option enabled '1'
	option vid '100'
	option ifname 'eth0.1'
	option name 'eth0.1.100'
	option macaddr '58:00:32:EF:3A:80'

config device 'br_2_port_1'
	option type '8021ad'
	option enabled '1'
	option vid '300'
	option ifname 'ae_wan'
	option name 'ae_wan.300'
	option macaddr '58:00:32:EF:3A:80'

config device 'br_3_port_1'
	option type '8021q'
	option enabled '1'
	option vid '100'
	option ifname 'ae_wan.300'
	option name 'ae_wan.300.100'
	option macaddr '58:00:32:EF:3A:80'
```


### Simple config test

Tcpdump on WAN

```
11:26:07.652007 aa:00:aa:d0:01:01 > aa:00:aa:cf:01:01, ethertype 802.1Q-QinQ (0x88a8), length 106: vlan 300, p 0, ethertype 802.1Q, vlan 100, p 0, ethertype IPv4, (tos 0x0, ttl 64, id 6987, offset 0, flags [DF], proto ICMP (1), length 84)
    10.10.10.10 > 10.10.10.1: ICMP echo request, id 121, seq 2, length 64
11:26:07.652095 aa:00:aa:cf:01:01 > aa:00:aa:d0:01:01, ethertype 802.1Q-QinQ (0x88a8), length 106: vlan 300, p 0, ethertype 802.1Q, vlan 100, p 0, ethertype IPv4, (tos 0x0, ttl 64, id 17496, offset 0, flags [none], proto ICMP (1), length 84)
    10.10.10.1 > 10.10.10.10: ICMP echo reply, id 121, seq 2, length 64
```

PING SUCCESSFUL:

```
ubuntu@Dwan2081:~$ ping -I eth1.100 10.10.10.1
PING 10.10.10.1 (10.10.10.1) from 10.10.10.100 eth1.100: 56(84) bytes of data.
64 bytes from 10.10.10.1: icmp_seq=1 ttl=64 time=1.51 ms
64 bytes from 10.10.10.1: icmp_seq=2 ttl=64 time=0.695 ms
64 bytes from 10.10.10.1: icmp_seq=3 ttl=64 time=0.773 ms
64 bytes from 10.10.10.1: icmp_seq=4 ttl=64 time=0.833 ms
^C
--- 10.10.10.1 ping statistics ---
8 packets transmitted, 8 received, 0% packet loss, time 7142ms
rtt min/avg/max/mdev = 0.667/0.838/1.505/0.256 ms
```

**************************************************************

## 8. Q-in-Q Untagged on LAN

### TR-181 data model

```
start
del Device.IP.Interface.*
del Device.Bridging.Bridge.*
del Device.Ethernet.Link.*
add Device.Bridging.Bridge.
add Device.Bridging.Bridge.1.Port.
set Device.Bridging.Bridge.1.Port.1.Enable 1
set Device.Bridging.Bridge.1.Port.1.ManagementPort 1
add Device.Bridging.Bridge.1.Port.
set Device.Bridging.Bridge.1.Port.2.Enable 1
set Device.Bridging.Bridge.1.Port.2.ManagementPort 0
set Device.Bridging.Bridge.1.Port.2.LowerLayers Device.Ethernet.Interface.1
add Device.Bridging.Bridge.1.VLAN.
set Device.Bridging.Bridge.1.VLAN.1.VLANID 100
set Device.Bridging.Bridge.1.X_IOWRT_EU_VLANFiltering 1
add Device.Bridging.Bridge.
add Device.Bridging.Bridge.2.Port.
set Device.Bridging.Bridge.2.Port.1.Enable 1
set Device.Bridging.Bridge.2.Port.1.ManagementPort 1
add Device.Bridging.Bridge.2.Port.
set Device.Bridging.Bridge.2.Port.2.Enable 1
set Device.Bridging.Bridge.2.Port.2.ManagementPort 0
set Device.Bridging.Bridge.2.Port.2.LowerLayers Device.Ethernet.Interface.6
add Device.Bridging.Bridge.2.VLAN.
set Device.Bridging.Bridge.2.VLAN.1.VLANID 300
add Device.Bridging.Bridge.2.VLANPort.
set Device.Bridging.Bridge.2.VLANPort.1.Enable 1
set Device.Bridging.Bridge.2.VLANPort.1.VLAN Device.Bridging.Bridge.2.VLAN.1
set Device.Bridging.Bridge.2.VLANPort.1.Port Device.Bridging.Bridge.2.Port.2
add Device.Bridging.ProviderBridge.
set Device.Bridging.ProviderBridge.1.CVLANcomponents Device.Bridging.Bridge.1
set Device.Bridging.ProviderBridge.1.SVLANcomponent Device.Bridging.Bridge.2
commit
```

### UCI

```
config interface 'iface_br1'
	option device 'br-dev1'
	option macaddr '58:00:32:EF:3A:80'

config device 'pr_br_1'
	option name 'br-dev1'
	option type 'bridge'
	option bridge_empty '1'
	option macaddr '58:00:32:EF:3A:80'
	list ports 'eth0.1'
	list ports 'ae_wan.300.100'
	option vlan_filtering '1'

config device 'br_2_port_1'
	option type '8021ad'
	option enabled '1'
	option vid '300'
	option ifname 'ae_wan'
	option name 'ae_wan.300'
	option macaddr '58:00:32:EF:3A:80'

config device 'br_3_port_1'
	option type '8021q'
	option enabled '1'
	option vid '100'
	option ifname 'ae_wan.300'
	option name 'ae_wan.300.100'
	option macaddr '58:00:32:EF:3A:80'
```

### Simple config test

TAGGED TRAFFIC DOES NOT PASS

```
ubuntu@Dwan2081:~$ ping -I eth1.100 10.10.10.1
PING 10.10.10.1 (10.10.10.1) from 10.10.10.10 eth1.100: 56(84) bytes of data.
^C
--- 10.10.10.1 ping statistics ---
3 packets transmitted, 0 received, 100% packet loss, time 2038ms
```


UNTAGGED TRAFFIC PASSES

```
ubuntu@Dwan2081:~$ ping -I eth1 10.10.10.1
PING 10.10.10.1 (10.10.10.1) from 10.10.10.10 eth1: 56(84) bytes of data.
64 bytes from 10.10.10.1: icmp_seq=1 ttl=64 time=1.31 ms
64 bytes from 10.10.10.1: icmp_seq=2 ttl=64 time=0.719 ms
64 bytes from 10.10.10.1: icmp_seq=3 ttl=64 time=0.829 ms
^C
--- 10.10.10.1 ping statistics ---
3 packets transmitted, 3 received, 0% packet loss, time 2018ms
rtt min/avg/max/mdev = 0.719/0.952/1.308/0.255 ms

```

Tcpdump:

```
11:26:07.652007 aa:00:aa:d0:01:01 > aa:00:aa:cf:01:01, ethertype 802.1Q-QinQ (0x88a8), length 106: vlan 300, p 0, ethertype 802.1Q, vlan 100, p 0, ethertype IPv4, (tos 0x0, ttl 64, id 6987, offset 0, flags [DF], proto ICMP (1), length 84)
    10.10.10.10 > 10.10.10.1: ICMP echo request, id 121, seq 2, length 64
11:26:07.652095 aa:00:aa:cf:01:01 > aa:00:aa:d0:01:01, ethertype 802.1Q-QinQ (0x88a8), length 106: vlan 300, p 0, ethertype 802.1Q, vlan 100, p 0, ethertype IPv4, (tos 0x0, ttl 64, id 17496, offset 0, flags [none], proto ICMP (1), length 84)
    10.10.10.1 > 10.10.10.10: ICMP echo reply, id 121, seq 2, length 64
```
