### draft design for new codec sync with terminal capabilities.

#### outgoing calls
```mermaid
sequenceDiagram
    participant A as voicemngr
    participant B as chan-voicemngr
    A->>B: init call
    Note over B: chan_voicemngr_start_calling/chan_voicemngr_new: <br/> require and wait for endpoint cap by ubus_invoke
    B->>A: ubus_invoke(ubus_request_endpoint_codec_cap)
    A->>B: ubus_send_reply(with codec_cap list)
    Note over B: chan_voicemngr_start_calling/chan_voicemngr_new: <br/> update cap and continue with outgoing process
```

#### incoming calls
```mermaid
sequenceDiagram
    participant A as asterisk/pjsip
    participant B as chan-voicemngr
    participant C as voicemngr
    Note left of A : Incoming call
    Note over A: incoming codec offer negotiation with pjsip cap <br/> and keep the list which used for calling chan_voicemngr
    A->>B: chan_voicemngr_new(..., codec_list)
    Note over B: chan_voicemngr_new: <br/> require and wait for endpoint cap by ubus_invoke
    B->>C: ubus_invoke(ubus_request_endpoint_codec_cap)
    C->>B: ubus_send_reply(with codec_cap list)
    Note over B: chan_voicemngr_new: <br/> update cap and continue with incoming process, hangup chan if no shared cap
    B->>A: cap update and continue with incoming process

```

### Tasks need to be done
#### voicemngr
 - init with endpoint capabilities(config file or get from endpoint).
 - get dect cap while handset register
 - new ubus method, ubus_request_endpoint_codec_cap


#### chan-voicemngr
 - get terminal cap while creating new call
```
chan_voicemngr_new(..., struct ast_format_cap *format){
    ...
    
+   ret = ubus_invoke(..,ubus_request_endpoint_codec_cap,..)
    if (format) {
-		ast_format_cap_append_from_cap(caps, format, AST_MEDIA_TYPE_UNKNOWN);
+       incoming call: check with the endpoint codec cap and update the incoming cap, hangup chan if no shared cap.
	} else {
-		ast_format_cap_append_from_cap(caps, default_cap, AST_MEDIA_TYPE_UNKNOWN);
+       outgoing call: using the endpoint codec cap instead of default_cap
	}
	...
}
```

#### asterisk/pjsip
 - keep incoming codecs offer list(only first in the list is kept at the moment) after negotiation with pjsip codec config(pjsip_endpoint.conf, uci sip_service_provider.codec_list) and call chan_voicemngr_new with the cap_list
 - make sure that updated cap from chan-voicemngr is ready before 200OK response, and has been used in the 200OK correctly.