# Function Specification

The scope of asterisk is to expose the APIs over ubus.

```
root@iopsys:~# ubus -v list 
'asterisk' @6f94a0b0
        "event":{"event":"String","line":"Integer"}
        "call_status":{"extension":"Integer","line":"Integer"}
'voice.asterisk' @e43dc4f7
        "status":{}
        "lines":{}
        "codecs":{}
        "supported_countries":{}

```

# Contents
* [asterisk](#asterisk)
* [voice.asterisk](#voiceasterisk)

## APIs

Asterisk publishes two different types objects `asterisk`, `voice.asterisk`.

### asterisk

An object that publishes asterisk information.

| Method			            | Function ID		|
| :---			              	| :---        		|
| [event](#event)               | 1					|
| [call_status](#call_status)   | 2					|

#### Methods

Methods descriptions of the `asterisk` object.
##### event

Exposes event passing to ubus

* [Event documentation](./api/asterisk.md#event)

##### call_status

Exposes callstatus over ubus

* [Call status documentation](./api/asterisk.md#call_status)
### voice.asterisk

Object for voice.asterisk .
````bash
'voice.asterisk' @e43dc4f7
        "status":{}
        "lines":{}
        "codecs":{}
        "supported_countries":{}
````

| Method      								 |Function ID	|
| :--- 	  									 | :---        	|
| [status](#status)					      	 | 3				|
| [lines](#lines)							 | 4				|
| [codecs](#codecs)					         | 5				|
| [supported_countries](#supported_countries)| 6				|


#### Methods

Method descriptions of the `voice.asterisk` object.

##### status

Exposes status of sip client over  ubus.

* [status documentation](./api/voice.asterisk.md#status)

##### lines

Exposes Line details over ubus.

* [Lines documentation](./api/voice.asterisk.md#lines)

##### codecs

Exposes codecs supported over ubus.

* [Codecs documentation](./api/voice.asterisk.md#codecs)

##### supported_countries

Exposes supported countries over ubus.

* [Supported countries documentation](./api/voice.asterisk.md#supported_countries)
