# JSON Schema for the output of the UBUS call voice.asterisk Schema

```
https://www.iopsys.eu/voice.asterisk.json
```

| Custom Properties | Additional Properties |
| ----------------- | --------------------- |
| Forbidden         | Forbidden             |

# JSON Schema for the output of the UBUS call voice.asterisk

| List of Methods                             |
| ------------------------------------------- |
| [codecs](#codecs)                           | Method | JSON Schema for the output of the UBUS call voice.asterisk (this schema) |
| [lines](#lines)                             | Method | JSON Schema for the output of the UBUS call voice.asterisk (this schema) |
| [status](#status)                           | Method | JSON Schema for the output of the UBUS call voice.asterisk (this schema) |
| [supported_countries](#supported_countries) | Method | JSON Schema for the output of the UBUS call voice.asterisk (this schema) |

## codecs

`codecs`

- type: `Method`

### codecs Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | Optional     |
| `output` | object | **Required** |

#### input

`input`

- is optional
- type: `object`

##### input Type

`object` with following properties:

| Property | Type | Required |
| -------- | ---- | -------- |
| None     | None | None     |

### Ubus CLI Example

```
ubus call JSON Schema for the output of the UBUS call voice.asterisk codecs {}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "JSON Schema for the output of the UBUS call voice.asterisk", "codecs", {}]
}
```

#### output

`output`

- is **required**
- type: `object`

##### output Type

`object` with following properties:

| Property    | Type   | Required     |
| ----------- | ------ | ------------ |
| `codec_key` | object | **Required** |

#### codec_key

`codec_key`

- is **required**
- type: `object`

##### codec_key Type

`object` with following properties:

| Property          | Type    | Required     |
| ----------------- | ------- | ------------ |
| `bitrate`         | number  | **Required** |
| `name`            | string  | **Required** |
| `ptime_default`   | integer | **Required** |
| `ptime_increment` | integer | **Required** |
| `ptime_max`       | integer | **Required** |
| `ptime_min`       | integer | **Required** |

#### bitrate

`bitrate`

- is **required**
- type: `number`

##### bitrate Type

`number`

- minimum value: `0`
- maximum value: `100`

#### name

`name`

- is **required**
- type: `enum`

##### name Type

`string`

The value of this property **must** be equal to one of the [known values below](#codecs-known-values).

##### name Known Values

| Value      |
| ---------- |
| G.711MuLaw |
| G.711ALaw  |
| G.729a     |
| G.723.1    |
| G.726      |
| G.728      |
| G.729      |
| G.729e     |
| GSM-FR     |
| GSM-EFR    |
| GSM-HR     |
| AMR        |
| iLBC       |

#### ptime_default

`ptime_default`

- is **required**
- type: `integer`

##### ptime_default Type

`integer`

- minimum value: `0`
- maximum value: `50`

#### ptime_increment

`ptime_increment`

- is **required**
- type: `integer`

##### ptime_increment Type

`integer`

- minimum value: `0`
- maximum value: `50`

#### ptime_max

`ptime_max`

- is **required**
- type: `integer`

##### ptime_max Type

`integer`

- minimum value: `0`
- maximum value: `300`

#### ptime_min

`ptime_min`

- is **required**
- type: `integer`

##### ptime_min Type

`integer`

- minimum value: `0`
- maximum value: `50`

### Output Example

```json
{
  "codec_key": {
    "name": "G.729a",
    "ptime_min": 29,
    "ptime_max": 250,
    "ptime_default": 38,
    "ptime_increment": 35,
    "bitrate": 31.37946823141602
  }
}
```

## lines

`lines`

- type: `Method`

### lines Type

`object` with following properties:

| Property | Type   | Required |
| -------- | ------ | -------- |
| `input`  | object | Optional |
| `output` | object | Optional |

#### input

`input`

- is optional
- type: `object`

##### input Type

`object` with following properties:

| Property | Type | Required |
| -------- | ---- | -------- |
| None     | None | None     |

### Ubus CLI Example

```
ubus call JSON Schema for the output of the UBUS call voice.asterisk lines {}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "JSON Schema for the output of the UBUS call voice.asterisk", "lines", {}]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property          | Type    | Required     |
| ----------------- | ------- | ------------ |
| `num_lines`       | integer | **Required** |
| `num_subchannels` | integer | **Required** |

#### num_lines

`num_lines`

- is **required**
- type: `integer`

##### num_lines Type

`integer`

- minimum value: `0`
- maximum value: `4`

#### num_subchannels

`num_subchannels`

- is **required**
- type: `integer`

##### num_subchannels Type

`integer`

- minimum value: `0`
- maximum value: `2`

### Output Example

```json
{ "num_subchannels": 0, "num_lines": 0 }
```

## status

`status`

- type: `Method`

### status Type

`object` with following properties:

| Property | Type   | Required |
| -------- | ------ | -------- |
| `input`  | object | Optional |
| `output` | object | Optional |

#### input

`input`

- is optional
- type: `object`

##### input Type

`object` with following properties:

| Property | Type | Required |
| -------- | ---- | -------- |
| None     | None | None     |

### Ubus CLI Example

```
ubus call JSON Schema for the output of the UBUS call voice.asterisk status {}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "JSON Schema for the output of the UBUS call voice.asterisk", "status", {}]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `sip`    | array  | **Required** |
| `tel`    | object | **Required** |

#### sip

`sip`

- is **required**
- type: `object[]`

##### sip Type

Array type: `object[]`

All items must be of the type: `object` with following properties:

| Property | Type   | Required |
| -------- | ------ | -------- |
| `sip0`   | object | Optional |

#### sip0

`sip0`

- is optional
- type: `object`

##### sip0 Type

`object` with following properties:

| Property                       | Type   | Required     |
| ------------------------------ | ------ | ------------ |
| `domain`                       | string | **Required** |
| `domain_port`                  | string | **Required** |
| `ip`                           | string | **Required** |
| `last_successful_registration` | string | **Required** |
| `refresh_interval`             | string | **Required** |
| `registered`                   | string | **Required** |
| `registration_time`            | string | **Required** |
| `registry_request_sent`        | string | **Required** |
| `state`                        | string | **Required** |
| `useragent`                    | string | **Required** |
| `username`                     | string | **Required** |

#### domain

`domain`

- is **required**
- type: `string`

##### domain Type

`string`

#### domain_port

`domain_port`

- is **required**
- type: `string`

##### domain_port Type

`string`

All instances must conform to this regular expression (test examples
[here](https://regexr.com/?expression=%5E%5B0-9%5D%2B)):

```regex
^[0-9]+
```

#### ip

`ip`

- is **required**
- type: `string`

##### ip Type

`string`

- format: `ipv4` – IP (v4) address (according to [RFC 2673, section 3.2](https://tools.ietf.org/html/rfc2673))

#### last_successful_registration

`last_successful_registration`

- is **required**
- type: `string`

##### last_successful_registration Type

`string`

#### refresh_interval

`refresh_interval`

- is **required**
- type: `string`

##### refresh_interval Type

`string`

All instances must conform to this regular expression (test examples
[here](https://regexr.com/?expression=%5E%5B0-9%5D%2B)):

```regex
^[0-9]+
```

#### registered

`registered`

- is **required**
- type: `enum`

##### registered Type

`string`

The value of this property **must** be equal to one of the [known values below](#status-known-values).

##### registered Known Values

| Value |
| ----- |
| true  |
| false |

#### registration_time

`registration_time`

- is **required**
- type: `string`

##### registration_time Type

`string`

All instances must conform to this regular expression (test examples
[here](https://regexr.com/?expression=%5E%5B0-9%5D.%2B)):

```regex
^[0-9].+
```

#### registry_request_sent

`registry_request_sent`

- is **required**
- type: `enum`

##### registry_request_sent Type

`string`

The value of this property **must** be equal to one of the [known values below](#status-known-values).

##### registry_request_sent Known Values

| Value |
| ----- |
| true  |
| false |

#### state

`state`

- is **required**
- type: `enum`

##### state Type

`string`

The value of this property **must** be equal to one of the [known values below](#status-known-values).

##### state Known Values

| Value        |
| ------------ |
| Registered   |
| Unregistered |

#### useragent

`useragent`

- is **required**
- type: `string`

##### useragent Type

`string`

All instances must conform to this regular expression (test examples
[here](https://regexr.com/?expression=%5E%5B0-9A-Z%5D.%2B)):

```regex
^[0-9A-Z].+
```

#### username

`username`

- is **required**
- type: `string`

##### username Type

`string`

All instances must conform to this regular expression (test examples
[here](https://regexr.com/?expression=%5E%5Ba-zA-Z%5D%2B)):

```regex
^[a-zA-Z]+
```

#### tel

`tel`

- is **required**
- type: `object`

##### tel Type

`object` with following properties:

| Property | Type | Required |
| -------- | ---- | -------- |
| None     | None | None     |

### Output Example

```json
{
  "sip": [
    {
      "sip0": {
        "registered": "false",
        "registry_request_sent": "false",
        "ip": "117.247.151.170",
        "username": "Fhzgk",
        "domain": "reprehenderit nisi labore sunt dolore",
        "domain_port": "2567684",
        "refresh_interval": "286733",
        "state": "Unregistered",
        "registration_time": "7ivo;&-SYc",
        "last_successful_registration": "fugiat est do reprehenderit",
        "useragent": "LexX:"
      }
    },
    {
      "sip0": {
        "registered": "true",
        "registry_request_sent": "false",
        "ip": "145.58.187.122",
        "username": "uJWxnlFk",
        "domain": "officia reprehen",
        "domain_port": "8",
        "refresh_interval": "123",
        "state": "Unregistered",
        "registration_time": "8LeVyatu;",
        "last_successful_registration": "exercitation esse reprehenderit ea consectetur",
        "useragent": "8T/+1["
      }
    },
    {
      "sip0": {
        "registered": "true",
        "registry_request_sent": "false",
        "ip": "117.175.51.24",
        "username": "zCPlAaEFzF",
        "domain": "m",
        "domain_port": "000",
        "refresh_interval": "0",
        "state": "Registered",
        "registration_time": "5u",
        "last_successful_registration": "irure in non",
        "useragent": "1E9$"
      }
    }
  ],
  "tel": {}
}
```

## supported_countries

`supported_countries`

- type: `Method`

### supported_countries Type

`object` with following properties:

| Property | Type   | Required |
| -------- | ------ | -------- |
| `input`  | object | Optional |
| `output` | object | Optional |

#### input

`input`

- is optional
- type: `object`

##### input Type

`object` with following properties:

| Property | Type | Required |
| -------- | ---- | -------- |
| None     | None | None     |

### Ubus CLI Example

```
ubus call JSON Schema for the output of the UBUS call voice.asterisk supported_countries {}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "JSON Schema for the output of the UBUS call voice.asterisk", "supported_countries", {}]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property    | Type  | Required     |
| ----------- | ----- | ------------ |
| `countries` | array | **Required** |

#### countries

`countries`

- is **required**
- type: `object[]`

##### countries Type

Array type: `object[]`

All items must be of the type: `object` with following properties:

| Property  | Type   | Required     |
| --------- | ------ | ------------ |
| `code`    | string | **Required** |
| `country` | string | **Required** |

#### code

`code`

- is **required**
- type: `string`

##### code Type

`string`

All instances must conform to this regular expression (test examples
[here](https://regexr.com/?expression=%5E%5Ba-z%5D%7B2%2C2%7D%24)):

```regex
^[a-z]{2,2}$
```

#### country

`country`

- is **required**
- type: `string`

##### country Type

`string`

All instances must conform to this regular expression (test examples
[here](https://regexr.com/?expression=%5E%5BA-Za-z%5D%2B)):

```regex
^[A-Za-z]+
```

### Output Example

```json
{
  "countries": [
    { "country": "UpZbdwkp", "code": "dq" },
    { "country": "BZqwsG", "code": "yy" },
    { "country": "KycHDmXWW", "code": "zt" },
    { "country": "QpbXWFM", "code": "fv" }
  ]
}
```
