# asterisk Schema

```
https://www.iopsys.eu/asterisk.json
```

| Custom Properties | Additional Properties |
| ----------------- | --------------------- |
| Forbidden         | Forbidden             |

# asterisk

| List of Methods             |
| --------------------------- |
| [call_status](#call_status) | Method | asterisk (this schema) |
| [event](#event)             | Method | asterisk (this schema) |

## call_status

`call_status`

- type: `Method`

### call_status Type

`object` with following properties:

| Property | Type  | Required |
| -------- | ----- | -------- |
| `input`  | oneOf | Optional |
| `output` | oneOf | Optional |

#### input

`input`

- is optional
- type: complex

##### input Type

**One** of the following _conditions_ need to be fulfilled.

#### Condition 1

`object` with following properties:

| Property | Type    | Required     |
| -------- | ------- | ------------ |
| `line`   | integer | **Required** |

#### line

`line`

- is **required**
- type: `integer`

##### line Type

`integer`

- minimum value: `0`
- maximum value: `10`

#### Condition 2

`object` with following properties:

| Property    | Type    | Required     |
| ----------- | ------- | ------------ |
| `extension` | integer | **Required** |

#### extension

`extension`

- is **required**
- type: `integer`

##### extension Type

`integer`

- minimum value: `0`
- maximum value: `10`

### Ubus CLI Example

```
ubus call asterisk call_status {"extension":7}
```

### JSONRPC Example

```json
{ "jsonrpc": "2.0", "id": 0, "method": "call", "params": ["<SID>", "asterisk", "call_status", { "extension": 7 }] }
```

#### output

`output`

- is optional
- type: complex

##### output Type

**One** of the following _conditions_ need to be fulfilled.

#### Condition 1

`object` with following properties:

| Property      | Type    | Required     |
| ------------- | ------- | ------------ |
| `call_status` | string  | **Required** |
| `line`        | integer | **Required** |

#### call_status

`call_status`

- is **required**
- type: `enum`

##### call_status Type

`string`

The value of this property **must** be equal to one of the [known values below](#-known-values).

##### call_status Known Values

| Value        |
| ------------ |
| Idle         |
| Connected    |
| Disconnected |
| Dialing      |
| Alerting     |

#### line

`line`

- is **required**
- type: `integer`

##### line Type

`integer`

- minimum value: `0`
- maximum value: `10`

#### Condition 2

`object` with following properties:

| Property      | Type    | Required     |
| ------------- | ------- | ------------ |
| `call_status` | string  | **Required** |
| `extension`   | integer | **Required** |

#### call_status

`call_status`

- is **required**
- type: `enum`

##### call_status Type

`string`

The value of this property **must** be equal to one of the [known values below](#-known-values).

##### call_status Known Values

| Value        |
| ------------ |
| Idle         |
| Connected    |
| Disconnected |
| Dialing      |
| Alerting     |

#### extension

`extension`

- is **required**
- type: `integer`

##### extension Type

`integer`

- minimum value: `0`
- maximum value: `10`

### Output Example

```json
{ "extension": 8, "call_status": "Disconnected" }
```

## event

`event`

- type: `Method`

### event Type

`object` with following properties:

| Property | Type   | Required |
| -------- | ------ | -------- |
| `input`  | object | Optional |
| `output` | object | Optional |

#### input

`input`

- is optional
- type: `object`

##### input Type

`object` with following properties:

| Property | Type    | Required     |
| -------- | ------- | ------------ |
| `event`  | string  | **Required** |
| `line`   | integer | **Required** |

#### event

`event`

- is **required**
- type: `enum`

##### event Type

`string`

The value of this property **must** be equal to one of the [known values below](#event-known-values).

##### event Known Values

| Value            |
| ---------------- |
| DTMF0            |
| DTMF1            |
| DTMF2            |
| DTMF3            |
| DTMF4            |
| DTMF5            |
| DTMF6            |
| DTMF7            |
| DTMF8            |
| DTMF9            |
| DTMFA            |
| DTMFB            |
| DTMFC            |
| DTMFD            |
| DTMFS            |
| DTMFH            |
| ONHOOK           |
| OFFHOOK          |
| EARLY_OFFHOOK    |
| EARLY_ONHOOK     |
| FLASH            |
| CALL_REJECT      |
| DECT_UNAVAILABLE |
| MEDIA            |
| SWITCH           |
| JOIN             |
| RELEASE          |

#### line

`line`

- is **required**
- type: `integer`

##### line Type

`integer`

- minimum value: `0`
- maximum value: `10`

### Ubus CLI Example

```
ubus call asterisk event {"line":2,"event":"DTMF4"}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "asterisk", "event", { "line": 2, "event": "DTMF4" }]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property | Type | Required |
| -------- | ---- | -------- |
| None     | None | None     |

### Output Example

```json
{}
```
